/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.repackage.org.jline.keymap.KeyMap;
import org.repackage.org.jline.reader.Binding;
import org.repackage.org.jline.reader.Buffer;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.Reference;
import org.repackage.org.jline.reader.Widget;
import org.repackage.org.jline.reader.impl.BufferImpl;
import org.repackage.org.jline.utils.AttributedString;
import org.repackage.org.jline.utils.AttributedStringBuilder;
import org.repackage.org.jline.utils.AttributedStyle;
import org.repackage.org.jline.utils.Status;

public abstract class Widgets {
    protected static final String AP_TOGGLE = "autopair-toggle";
    protected static final String AP_INSERT = "_autopair-insert";
    protected static final String AP_BACKWARD_DELETE_CHAR = "_autopair-backward-delete-char";
    protected static final String TT_TOGGLE = "tailtip-toggle";
    protected static final String TT_ACCEPT_LINE = "_tailtip-accept-line";
    private final LineReader reader;

    public Widgets(LineReader reader) {
        this.reader = reader;
    }

    public void addWidget(String name, Widget widget) {
        this.reader.getWidgets().put(name, this.namedWidget(name, widget));
    }

    private Widget namedWidget(final String name, final Widget widget) {
        return new Widget(){

            public String toString() {
                return name;
            }

            @Override
            public boolean apply() {
                return widget.apply();
            }
        };
    }

    public void callWidget(String name) {
        if (!name.startsWith("_") && !name.endsWith("-toggle")) {
            name = "." + name;
        }
        this.reader.callWidget(name);
    }

    public void executeWidget(String name) {
        this.getKeyMap().bind((Binding)new Reference(name), (CharSequence)KeyMap.alt(KeyMap.ctrl('X')));
        this.reader.runMacro(KeyMap.alt(KeyMap.ctrl('X')));
    }

    public void aliasWidget(String orig, String alias) {
        this.reader.getWidgets().put(alias, this.widget(orig));
    }

    public String getWidget(String name) {
        return this.widget(name).toString();
    }

    public boolean existsWidget(String name) {
        try {
            this.widget(name);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Widget widget(String name) {
        Widget out = null;
        out = name.startsWith(".") ? this.reader.getBuiltinWidgets().get(name.substring(1)) : this.reader.getWidgets().get(name);
        if (out == null) {
            throw new InvalidParameterException("widget: no such widget " + name);
        }
        return out;
    }

    public KeyMap<Binding> getKeyMap() {
        return this.reader.getKeyMaps().get("main");
    }

    public Buffer buffer() {
        return this.reader.getBuffer();
    }

    public void replaceBuffer(Buffer buffer) {
        this.reader.getBuffer().copyFrom(buffer);
    }

    public List<String> args(String line) {
        return this.reader.getParser().parse(line, 0).words();
    }

    public String prevChar() {
        return String.valueOf((char)this.reader.getBuffer().prevChar());
    }

    public String currChar() {
        return String.valueOf((char)this.reader.getBuffer().currChar());
    }

    public String lastBinding() {
        return this.reader.getLastBinding();
    }

    public void putString(String string) {
        this.reader.getBuffer().write(string);
    }

    public String tailTip() {
        return this.reader.getTailTip();
    }

    public void setTailTip(String tailTip) {
        this.reader.setTailTip(tailTip);
    }

    public void clearTailTip() {
        this.reader.setTailTip("");
    }

    public void setSuggestionType(LineReader.SuggestionType type) {
        this.reader.setAutosuggestion(type);
    }

    public void addDescription(List<AttributedString> desc) {
        Status.getStatus(this.reader.getTerminal()).update(desc);
    }

    public void clearDescription() {
        this.initDescription(0);
    }

    public void initDescription(int size) {
        Status status = Status.getStatus(this.reader.getTerminal(), false);
        if (size > 0) {
            if (status == null) {
                status = Status.getStatus(this.reader.getTerminal());
            }
            status.setBorder(true);
            ArrayList<AttributedString> as = new ArrayList<AttributedString>();
            for (int i = 0; i < size; ++i) {
                as.add(new AttributedString(""));
            }
            this.addDescription(as);
            this.reader.runMacro(KeyMap.ctrl('M'));
        } else if (status != null) {
            if (size < 0) {
                status.update(null);
                this.reader.runMacro(KeyMap.ctrl('M'));
            } else {
                status.clear();
            }
        }
    }

    public void destroyDescription() {
        this.initDescription(-1);
    }

    public static class CmdDesc {
        private List<ArgDesc> argsDesc;
        private TreeMap<String, List<AttributedString>> optsDesc;

        public CmdDesc(List<ArgDesc> argsDesc) {
            this(argsDesc, new HashMap<String, List<AttributedString>>());
        }

        public CmdDesc(List<ArgDesc> argsDesc, Map<String, List<AttributedString>> optsDesc) {
            this.argsDesc = new ArrayList<ArgDesc>(argsDesc);
            this.optsDesc = new TreeMap<String, List<AttributedString>>(optsDesc);
        }

        public List<ArgDesc> getArgsDesc() {
            return this.argsDesc;
        }

        public List<AttributedString> getOptionDescription(String opt) {
            int ind;
            ArrayList<AttributedString> out = new ArrayList<AttributedString>();
            if (!opt.startsWith("-")) {
                return out;
            }
            if (opt.startsWith("--") && (ind = opt.indexOf("=")) > 0) {
                opt = opt.substring(0, ind);
            }
            if (this.optsDesc.containsKey(opt)) {
                out.add(new AttributedString(opt));
                for (AttributedString as : this.optsDesc.get(opt)) {
                    AttributedStringBuilder asb = new AttributedStringBuilder().tabs(8);
                    asb.append("\t");
                    asb.append(as);
                    out.add(asb.toAttributedString());
                }
            } else if (this.optsDesc.containsKey("main")) {
                out = new ArrayList(this.optsDesc.get("main"));
            } else {
                for (Map.Entry<String, List<AttributedString>> entry : this.optsDesc.entrySet()) {
                    if (!entry.getKey().startsWith(opt)) continue;
                    AttributedStringBuilder asb = new AttributedStringBuilder().tabs(8);
                    asb.append(entry.getKey());
                    asb.append("\t");
                    asb.append(entry.getValue().get(0));
                    out.add(asb.toAttributedString());
                }
            }
            return out;
        }
    }

    public static class ArgDesc {
        private String name;
        private List<AttributedString> description = new ArrayList<AttributedString>();

        public ArgDesc(String name) {
            this(name, new ArrayList<AttributedString>());
        }

        public ArgDesc(String name, List<AttributedString> description) {
            this.name = name;
            this.description = new ArrayList<AttributedString>(description);
        }

        public String getName() {
            return this.name;
        }

        public List<AttributedString> getDescription() {
            return this.description;
        }

        public static List<ArgDesc> doArgNames(List<String> names) {
            ArrayList<ArgDesc> out = new ArrayList<ArgDesc>();
            for (String n : names) {
                out.add(new ArgDesc(n));
            }
            return out;
        }
    }

    public static class TailTipWidgets
    extends Widgets {
        private boolean enabled = false;
        private Map<String, CmdDesc> tailTips = new HashMap<String, CmdDesc>();
        private TipType tipType;
        private int descriptionSize = 0;
        private boolean descriptionEnabled = true;

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips) {
            this(reader, tailTips, 0, TipType.COMBINED);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, TipType tipType) {
            this(reader, tailTips, 0, tipType);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, int descriptionSize) {
            this(reader, tailTips, descriptionSize, TipType.COMBINED);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, int descriptionSize, TipType tipType) {
            super(reader);
            if (this.existsWidget(Widgets.TT_ACCEPT_LINE)) {
                throw new IllegalStateException("TailTipWidgets already created!");
            }
            this.tailTips = new HashMap<String, CmdDesc>(tailTips);
            this.descriptionSize = descriptionSize;
            this.tipType = tipType;
            this.addWidget(Widgets.TT_ACCEPT_LINE, this::tailtipAcceptLine);
            this.addWidget("_tailtip-insert", this::tailtipInsert);
            this.addWidget("_tailtip-backward-delete-char", this::tailtipBackwardDelete);
            this.addWidget("_tailtip-delete-char", this::tailtipDelete);
            this.addWidget("_tailtip-expand-or-complete", this::tailtipComplete);
            this.addWidget("tailtip-window", this::toggleWindow);
            this.addWidget(Widgets.TT_TOGGLE, this::toggleKeyBindings);
        }

        public void setDescriptionSize(int descriptionSize) {
            this.descriptionSize = descriptionSize;
            this.initDescription(descriptionSize);
        }

        public int getDescriptionSize() {
            return this.descriptionSize;
        }

        public void setTipType(TipType type) {
            this.tipType = type;
            if (this.tipType == TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
            } else {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            }
        }

        public TipType getTipType() {
            return this.tipType;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void disable() {
            if (this.enabled) {
                this.executeWidget(Widgets.TT_TOGGLE);
            }
        }

        public void enable() {
            if (!this.enabled) {
                this.toggleKeyBindings();
            }
        }

        public boolean tailtipComplete() {
            return this.doTailTip("expand-or-complete");
        }

        public boolean tailtipAcceptLine() {
            if (this.tipType != TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            }
            this.clearDescription();
            return this.clearTailTip("accept-line");
        }

        public boolean tailtipBackwardDelete() {
            return this.doTailTip(this.autopairEnabled() ? Widgets.AP_BACKWARD_DELETE_CHAR : "backward-delete-char");
        }

        private boolean clearTailTip(String widget) {
            this.clearTailTip();
            this.callWidget(widget);
            return true;
        }

        public boolean tailtipDelete() {
            this.clearTailTip();
            return this.doTailTip("delete-char");
        }

        public boolean tailtipInsert() {
            return this.doTailTip(this.autopairEnabled() ? Widgets.AP_INSERT : "self-insert");
        }

        private boolean doTailTip(String widget) {
            Buffer buffer = this.buffer();
            this.callWidget(widget);
            if (buffer.length() == buffer.cursor()) {
                List<String> bp = this.args(buffer.toString());
                int argnum = 0;
                for (String a : bp) {
                    if (a.startsWith("-")) continue;
                    ++argnum;
                }
                String lastArg = !this.prevChar().equals(" ") ? bp.get(bp.size() - 1) : "";
                int bpsize = argnum;
                boolean doTailTip = true;
                if (widget.endsWith("backward-delete-char")) {
                    if (!lastArg.startsWith("-")) {
                        --bpsize;
                    }
                    if (this.prevChar().equals(" ")) {
                        ++bpsize;
                    }
                } else if (!this.prevChar().equals(" ")) {
                    doTailTip = false;
                }
                boolean clearTip = false;
                if (bp.size() > 0 && this.tailTips.containsKey(bp.get(0))) {
                    if (lastArg.startsWith("-")) {
                        this.doDescription(this.tailTips.get(bp.get(0)).getOptionDescription(lastArg));
                    }
                    if (bpsize > 0 && doTailTip) {
                        List<ArgDesc> params = this.tailTips.get(bp.get(0)).getArgsDesc();
                        this.setSuggestionType(this.tipType == TipType.COMPLETER ? LineReader.SuggestionType.COMPLETER : LineReader.SuggestionType.TAIL_TIP);
                        if (bpsize - 1 < params.size()) {
                            if (!lastArg.startsWith("-")) {
                                this.doDescription(params.get(bpsize - 1).getDescription());
                            }
                            StringBuilder tip = new StringBuilder();
                            for (int i = bpsize - 1; i < params.size(); ++i) {
                                tip.append(params.get(i).getName());
                                tip.append(" ");
                            }
                            this.setTailTip(tip.toString());
                        } else if (params.get(params.size() - 1).getName().charAt(0) == '[') {
                            this.setTailTip(params.get(params.size() - 1).getName());
                            this.doDescription(params.get(params.size() - 1).getDescription());
                        }
                    } else if (doTailTip) {
                        clearTip = true;
                    }
                } else {
                    clearTip = true;
                }
                if (clearTip) {
                    this.setTailTip("");
                    if (this.tipType != TipType.TAIL_TIP) {
                        this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
                    }
                }
            }
            return true;
        }

        private void doDescription(List<AttributedString> desc) {
            if (this.descriptionSize == 0 || !this.descriptionEnabled) {
                return;
            }
            if (desc.isEmpty()) {
                this.clearDescription();
            } else if (desc.size() == this.descriptionSize) {
                this.addDescription(desc);
            } else if (desc.size() > this.descriptionSize) {
                AttributedStringBuilder asb = new AttributedStringBuilder();
                asb.append(desc.get(this.descriptionSize - 1)).append("...", new AttributedStyle(AttributedStyle.INVERSE));
                ArrayList<AttributedString> mod = new ArrayList<AttributedString>(desc.subList(0, this.descriptionSize - 1));
                mod.add(asb.toAttributedString());
                this.addDescription(mod);
            } else if (desc.size() < this.descriptionSize) {
                while (desc.size() != this.descriptionSize) {
                    desc.add(new AttributedString(""));
                }
                this.addDescription(desc);
            }
        }

        private boolean autopairEnabled() {
            Binding binding = this.getKeyMap().getBound("(");
            return binding instanceof Reference && ((Reference)binding).name().equals(Widgets.AP_INSERT);
        }

        public boolean toggleWindow() {
            boolean bl = this.descriptionEnabled = !this.descriptionEnabled;
            if (this.descriptionEnabled) {
                this.initDescription(this.descriptionSize);
            } else {
                this.destroyDescription();
            }
            return true;
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
                this.destroyDescription();
            } else {
                this.customBindings();
                if (this.descriptionEnabled) {
                    this.initDescription(this.descriptionSize);
                }
            }
            return this.enabled;
        }

        private boolean defaultBindings() {
            if (!this.enabled) {
                return false;
            }
            this.aliasWidget(".accept-line", "accept-line");
            this.aliasWidget(".backward-delete-char", "backward-delete-char");
            this.aliasWidget(".delete-char", "delete-char");
            this.aliasWidget(".expand-or-complete", "expand-or-complete");
            KeyMap<Binding> map = this.getKeyMap();
            map.bind((Binding)new Reference("self-insert"), (CharSequence)" ");
            map.bind((Binding)new Reference("self-insert"), (CharSequence)"=");
            map.bind((Binding)new Reference("self-insert"), (CharSequence)"-");
            map.bind((Binding)new Reference("self-insert"), KeyMap.range("A-Z"));
            map.bind((Binding)new Reference("self-insert"), KeyMap.range("a-z"));
            this.setSuggestionType(LineReader.SuggestionType.NONE);
            if (this.autopairEnabled()) {
                this.callWidget(Widgets.AP_TOGGLE);
                this.callWidget(Widgets.AP_TOGGLE);
            }
            this.enabled = false;
            return true;
        }

        private void customBindings() {
            if (this.enabled) {
                return;
            }
            this.aliasWidget(Widgets.TT_ACCEPT_LINE, "accept-line");
            this.aliasWidget("_tailtip-backward-delete-char", "backward-delete-char");
            this.aliasWidget("_tailtip-delete-char", "delete-char");
            this.aliasWidget("_tailtip-expand-or-complete", "expand-or-complete");
            KeyMap<Binding> map = this.getKeyMap();
            map.bind((Binding)new Reference("_tailtip-insert"), (CharSequence)" ");
            map.bind((Binding)new Reference("_tailtip-insert"), (CharSequence)"=");
            map.bind((Binding)new Reference("_tailtip-insert"), (CharSequence)"-");
            map.bind((Binding)new Reference("_tailtip-insert"), KeyMap.range("A-Z"));
            map.bind((Binding)new Reference("_tailtip-insert"), KeyMap.range("a-z"));
            if (this.tipType != TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            } else {
                this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
            }
            this.enabled = true;
        }

        public static enum TipType {
            TAIL_TIP,
            COMPLETER,
            COMBINED;

        }
    }

    public static class AutosuggestionWidgets
    extends Widgets {
        private boolean enabled = false;

        public AutosuggestionWidgets(LineReader reader) {
            super(reader);
            if (this.existsWidget("_autosuggest-forward-char")) {
                throw new IllegalStateException("AutosuggestionWidgets already created!");
            }
            this.addWidget("_autosuggest-forward-char", this::autosuggestForwardChar);
            this.addWidget("_autosuggest-end-of-line", this::autosuggestEndOfLine);
            this.addWidget("_autosuggest-forward-word", this::partialAccept);
            this.addWidget("autosuggest-toggle", this::toggleKeyBindings);
        }

        public void disable() {
            this.defaultBindings();
        }

        public void enable() {
            this.customBindings();
        }

        public boolean partialAccept() {
            Buffer buffer = this.buffer();
            if (buffer.cursor() == buffer.length()) {
                int curPos = buffer.cursor();
                buffer.write(this.tailTip());
                buffer.cursor(curPos);
                this.replaceBuffer(buffer);
                this.callWidget("forward-word");
                BufferImpl newBuf = new BufferImpl();
                newBuf.write(this.buffer().substring(0, this.buffer().cursor()));
                this.replaceBuffer(newBuf);
            } else {
                this.callWidget("forward-word");
            }
            return true;
        }

        public boolean autosuggestForwardChar() {
            return this.accept("forward-char");
        }

        public boolean autosuggestEndOfLine() {
            return this.accept("end-of-line");
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
            } else {
                this.customBindings();
            }
            return this.enabled;
        }

        private boolean accept(String widget) {
            Buffer buffer = this.buffer();
            if (buffer.cursor() == buffer.length()) {
                this.putString(this.tailTip());
            } else {
                this.callWidget(widget);
            }
            return true;
        }

        private void customBindings() {
            if (this.enabled) {
                return;
            }
            this.aliasWidget("_autosuggest-forward-char", "forward-char");
            this.aliasWidget("_autosuggest-end-of-line", "end-of-line");
            this.aliasWidget("_autosuggest-forward-word", "forward-word");
            this.enabled = true;
            this.setSuggestionType(LineReader.SuggestionType.HISTORY);
        }

        private void defaultBindings() {
            if (!this.enabled) {
                return;
            }
            this.aliasWidget(".forward-char", "forward-char");
            this.aliasWidget(".end-of-line", "end-of-line");
            this.aliasWidget(".forward-word", "forward-word");
            this.enabled = false;
            this.setSuggestionType(LineReader.SuggestionType.NONE);
        }
    }

    public static class AutopairWidgets
    extends Widgets {
        private static final Map<String, String> LBOUNDS = new HashMap<String, String>();
        private static final Map<String, String> RBOUNDS;
        private final Map<String, String> pairs;
        private final Map<String, Binding> defaultBindings = new HashMap<String, Binding>();
        private boolean enabled;

        public AutopairWidgets(LineReader reader) {
            this(reader, false);
        }

        public AutopairWidgets(LineReader reader, boolean addCurlyBrackets) {
            super(reader);
            this.pairs = new HashMap<String, String>();
            this.pairs.put("`", "`");
            this.pairs.put("'", "'");
            this.pairs.put("\"", "\"");
            this.pairs.put("[", "]");
            this.pairs.put("(", ")");
            this.pairs.put(" ", " ");
            if (this.existsWidget(Widgets.AP_INSERT)) {
                throw new IllegalStateException("AutopairWidgets already created!");
            }
            if (addCurlyBrackets) {
                this.pairs.put("{", "}");
            }
            this.addWidget(Widgets.AP_INSERT, this::autopairInsert);
            this.addWidget("_autopair-close", this::autopairClose);
            this.addWidget(Widgets.AP_BACKWARD_DELETE_CHAR, this::autopairDelete);
            this.addWidget(Widgets.AP_TOGGLE, this::toggleKeyBindings);
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                this.defaultBindings.put(p.getKey(), map.getBound(p.getKey()));
                if (p.getKey().equals(p.getValue())) continue;
                this.defaultBindings.put(p.getValue(), map.getBound(p.getValue()));
            }
        }

        public void enable() {
            if (!this.enabled) {
                this.executeWidget(Widgets.AP_TOGGLE);
            }
        }

        public void disable() {
            if (this.enabled) {
                this.executeWidget(Widgets.AP_TOGGLE);
            }
        }

        public boolean toggle() {
            boolean before = this.enabled;
            this.executeWidget(Widgets.AP_TOGGLE);
            return !before;
        }

        public boolean autopairInsert() {
            if (this.pairs.containsKey(this.lastBinding())) {
                if (this.canSkip(this.lastBinding())) {
                    this.callWidget("forward-char");
                } else if (this.canPair(this.lastBinding())) {
                    this.callWidget("self-insert");
                    this.putString(this.pairs.get(this.lastBinding()));
                    this.callWidget("backward-char");
                } else {
                    this.callWidget("self-insert");
                }
            } else {
                this.callWidget("self-insert");
            }
            return true;
        }

        public boolean autopairClose() {
            if (this.pairs.containsValue(this.lastBinding()) && this.currChar().equals(this.lastBinding())) {
                this.callWidget("forward-char");
            } else {
                this.callWidget("self-insert");
            }
            return true;
        }

        public boolean autopairDelete() {
            if (this.pairs.containsKey(this.prevChar()) && this.pairs.get(this.prevChar()).equals(this.currChar()) && this.canDelete(this.prevChar())) {
                this.callWidget("delete-char");
            }
            this.callWidget("backward-delete-char");
            return true;
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
            } else {
                this.customBindings();
            }
            return this.enabled;
        }

        private void customBindings() {
            boolean ttActive = this.tailtipEnabled();
            if (ttActive) {
                this.callWidget(Widgets.TT_TOGGLE);
            }
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                map.bind((Binding)new Reference(Widgets.AP_INSERT), (CharSequence)p.getKey());
                if (p.getKey().equals(p.getValue())) continue;
                map.bind((Binding)new Reference("_autopair-close"), (CharSequence)p.getValue());
            }
            this.aliasWidget(Widgets.AP_BACKWARD_DELETE_CHAR, "backward-delete-char");
            if (ttActive) {
                this.callWidget(Widgets.TT_TOGGLE);
            }
            this.enabled = true;
        }

        private void defaultBindings() {
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                map.bind(this.defaultBindings.get(p.getKey()), (CharSequence)p.getKey());
                if (p.getKey().equals(p.getValue())) continue;
                map.bind(this.defaultBindings.get(p.getValue()), (CharSequence)p.getValue());
            }
            this.aliasWidget(".backward-delete-char", "backward-delete-char");
            if (this.tailtipEnabled()) {
                this.callWidget(Widgets.TT_TOGGLE);
                this.callWidget(Widgets.TT_TOGGLE);
            }
            this.enabled = false;
        }

        private boolean tailtipEnabled() {
            return this.getWidget("accept-line").equals(Widgets.TT_ACCEPT_LINE);
        }

        private boolean canPair(String d) {
            if (this.balanced(d) && !this.nexToBoundary(d)) {
                return !d.equals(" ") || !this.prevChar().equals(" ") && !this.currChar().equals(" ");
            }
            return false;
        }

        private boolean canSkip(String d) {
            return this.pairs.get(d).equals(d) && d.charAt(0) != ' ' && this.currChar().equals(d) && this.balanced(d);
        }

        private boolean canDelete(String d) {
            return this.balanced(d);
        }

        private boolean balanced(String d) {
            boolean out = false;
            Buffer buf = this.buffer();
            String lbuf = buf.upToCursor();
            String rbuf = buf.substring(lbuf.length());
            String regx1 = this.pairs.get(d).equals(d) ? d : "\\" + d;
            String regx2 = this.pairs.get(d).equals(d) ? this.pairs.get(d) : "\\" + this.pairs.get(d);
            int llen = lbuf.length() - lbuf.replaceAll(regx1, "").length();
            int rlen = rbuf.length() - rbuf.replaceAll(regx2, "").length();
            if (llen == 0 && rlen == 0) {
                out = true;
            } else if (d.charAt(0) == ' ') {
                out = true;
            } else if (this.pairs.get(d).equals(d)) {
                if (llen == rlen || (llen + rlen) % 2 == 0) {
                    out = true;
                }
            } else {
                int l2len = lbuf.length() - lbuf.replaceAll(regx2, "").length();
                int r2len = rbuf.length() - rbuf.replaceAll(regx1, "").length();
                int ltotal = llen - l2len;
                int rtotal = rlen - r2len;
                if (ltotal < 0) {
                    ltotal = 0;
                }
                if (ltotal >= rtotal) {
                    out = true;
                }
            }
            return out;
        }

        private boolean boundary(String lb, String rb) {
            return lb.length() > 0 && this.prevChar().matches(lb) || rb.length() > 0 && this.currChar().matches(rb);
        }

        private boolean nexToBoundary(String d) {
            ArrayList<String> bk = new ArrayList<String>();
            bk.add("all");
            if (d.matches("['\"`]")) {
                bk.add("quotes");
            } else if (d.matches("[{\\[(<]")) {
                bk.add("braces");
            } else if (d.charAt(0) == ' ') {
                bk.add("spaces");
            }
            if (LBOUNDS.containsKey(d) && RBOUNDS.containsKey(d)) {
                bk.add(d);
            }
            for (String k : bk) {
                if (!this.boundary(LBOUNDS.get(k), RBOUNDS.get(k))) continue;
                return true;
            }
            return false;
        }

        static {
            LBOUNDS.put("all", "[.:/\\!]");
            LBOUNDS.put("quotes", "[\\]})a-zA-Z0-9]");
            LBOUNDS.put("spaces", "[^{(\\[]");
            LBOUNDS.put("braces", "");
            LBOUNDS.put("`", "`");
            LBOUNDS.put("\"", "\"");
            LBOUNDS.put("'", "'");
            RBOUNDS = new HashMap<String, String>();
            RBOUNDS.put("all", "[\\[{(<,.:?/%$!a-zA-Z0-9]");
            RBOUNDS.put("quotes", "[a-zA-Z0-9]");
            RBOUNDS.put("spaces", "[^\\]})]");
            RBOUNDS.put("braces", "");
            RBOUNDS.put("`", "");
            RBOUNDS.put("\"", "");
            RBOUNDS.put("'", "");
        }
    }
}

