/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.reader.impl.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.repackage.org.jline.reader.Candidate;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.ParsedLine;
import org.repackage.org.jline.utils.AttributedString;

public class StringsCompleter
implements Completer {
    protected final Collection<Candidate> candidates = new ArrayList<Candidate>();

    public StringsCompleter() {
    }

    public StringsCompleter(String ... strings) {
        this((Iterable<String>)Arrays.asList(strings));
    }

    public StringsCompleter(Iterable<String> strings) {
        assert (strings != null);
        for (String string : strings) {
            this.candidates.add(new Candidate(AttributedString.stripAnsi(string), string, null, null, null, null, true));
        }
    }

    public StringsCompleter(Candidate ... candidates) {
        assert (candidates != null);
        this.candidates.addAll(Arrays.asList(candidates));
    }

    public StringsCompleter(Collection<Candidate> candidates) {
        assert (candidates != null);
        this.candidates.addAll(candidates);
    }

    @Override
    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        assert (commandLine != null);
        assert (candidates != null);
        candidates.addAll(this.candidates);
    }
}

