/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Env
implements Serializable {
    private static final long serialVersionUID = 9002640180394221858L;
    private final Env outer;
    private final int level;
    private final Map<VncSymbol, Var> precompiledGlobalSymbols;
    private final Map<VncSymbol, Var> globalSymbols;
    private final Map<VncSymbol, Var> localSymbols;

    public Env() {
        this((Env)null);
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
        this.precompiledGlobalSymbols = outer == null ? null : outer.precompiledGlobalSymbols;
        this.globalSymbols = outer == null ? new ConcurrentHashMap() : outer.globalSymbols;
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    private Env(Map<VncSymbol, Var> precompiledGlobalSymbols) {
        this.outer = null;
        this.level = 0;
        this.precompiledGlobalSymbols = precompiledGlobalSymbols;
        this.globalSymbols = new ConcurrentHashMap<VncSymbol, Var>();
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    public Env copyGlobalToPrecompiledSymbols() {
        return new Env(this.globalSymbols);
    }

    public VncVal get(VncSymbol sym) {
        VncVal val = this.getOrElse(sym, null);
        if (val != null) {
            return val;
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Symbol '%s' not found.", sym.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public boolean isBound(VncSymbol sym) {
        Env e = this.findEnv(sym);
        if (e != null) {
            return e.getLocalVar(sym) != null;
        }
        return this.getGlobalVar(sym) != null;
    }

    public VncVal getOrNil(VncSymbol sym) {
        return this.getOrElse(sym, Constants.Nil);
    }

    public VncVal getGlobalOrNil(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : Constants.Nil;
    }

    public VncVal getGlobalOrNull(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : null;
    }

    public Var getGlobalVarOrNull(VncSymbol sym) {
        return this.getGlobalVar(sym);
    }

    public int level() {
        return this.level;
    }

    public Env setLocal(VncSymbol sym, VncVal val) {
        if (sym.equals(Namespaces.NS_CURRENT_SYMBOL)) {
            throw new VncException(String.format("Internal error setting var %s", sym.getName()));
        }
        Var v = this.getGlobalVar(sym);
        if (v != null && !v.isOverwritable() && Types.isVncFunction(v.getVal())) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The global var '%s' must not be shadowed by a local var!", sym));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.setLocalVar(sym, new Var(sym, val));
        return this;
    }

    public Env setGlobal(Var val) {
        if (val.getName().equals(Namespaces.NS_CURRENT_SYMBOL)) {
            throw new VncException(String.format("Internal error setting var %s", val.getName().getName()));
        }
        Var v = this.getGlobalVar(val.getName());
        if (v != null && !v.isOverwritable()) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(val.getName()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The existing global var '%s' must not be overwritten!", val.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.setGlobalVar(val.getName(), val);
        return this;
    }

    public Env addGlobalVars(List<Var> vars) {
        if (vars != null) {
            vars.forEach(v -> this.setGlobal((Var)v));
        }
        return this;
    }

    public void addLocalBindings(List<Binding> bindings) {
        for (Binding b : bindings) {
            this.setLocal(b.sym, b.val);
        }
    }

    public void pushGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        if (dv != null) {
            dv.pushVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public VncVal popGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.popVal() : Constants.Nil;
    }

    public VncVal peekGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.peekVal() : Constants.Nil;
    }

    public void setGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        if (dv != null) {
            dv.setVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public void replaceGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar nv = new DynamicVar(sym, Constants.Nil);
        this.setGlobalVar(sym, nv);
        nv.pushVal(val);
    }

    public void removeGlobalSymbol(VncSymbol sym) {
        if (this.precompiledGlobalSymbols != null) {
            this.precompiledGlobalSymbols.remove(sym);
        }
        this.globalSymbols.remove(sym);
    }

    public void removeGlobalSymbolsByNS(VncSymbol ns) {
        String nsName = ns.getName();
        if (Namespaces.isCoreNS(nsName)) {
            return;
        }
        if (this.precompiledGlobalSymbols != null) {
            this.precompiledGlobalSymbols.keySet().stream().filter(s -> nsName.equals(Namespaces.getNamespace(s.getName()))).forEach(s -> this.precompiledGlobalSymbols.remove(s));
        }
        this.globalSymbols.keySet().stream().filter(s -> nsName.equals(Namespaces.getNamespace(s.getName()))).forEach(s -> this.globalSymbols.remove(s));
    }

    public Env getLevelEnv(int level) {
        Env env = this;
        if (env.level == level) {
            return env;
        }
        while (env.outer != null) {
            env = env.outer;
            if (env.level != level) continue;
            return env;
        }
        throw new VncException(String.format("No env level %d", level));
    }

    public int globalsCount() {
        if (this.precompiledGlobalSymbols != null) {
            return this.precompiledGlobalSymbols.size();
        }
        return this.globalSymbols.size();
    }

    public String toString() {
        return "level " + this.level + ":" + "\n   [local]\n" + this.toString(this.localSymbols, "      ", null) + "\n   [global]\n" + this.toString(this.getAllGlobalSymbols(), "      ", null);
    }

    public String localsToString() {
        return "level " + this.level + ":" + "\n   [local]\n" + this.toString(this.localSymbols, "      ", null);
    }

    public String globalsToString() {
        return "[global]\n" + this.toString(this.getAllGlobalSymbols(), "   ", null);
    }

    public String globalsToString(String regexFilter) {
        return "[global]\n" + this.toString(this.getAllGlobalSymbols(), "   ", regexFilter);
    }

    public Env setStdoutPrintStream(PrintStream ps) {
        this.replaceGlobalDynamic(new VncSymbol("*out*"), new VncJavaObject(ps != null ? ps : this.nullPrintStream()));
        return this;
    }

    private String toString(Map<VncSymbol, Var> vars, String indent, String regexFilter) {
        return vars.values().stream().sorted((a, b) -> a.getName().getName().compareTo(b.getName().getName())).filter(v -> regexFilter == null ? true : v.getName().getName().matches(regexFilter)).map(v -> String.format("%s%s: %s", indent, v.getName().getName(), Printer.pr_str(v.getVal(), true))).collect(Collectors.joining("\n"));
    }

    private DynamicVar findGlobalDynamicVar(VncSymbol sym) {
        if (sym.equals(Namespaces.NS_CURRENT_SYMBOL)) {
            throw new VncException(String.format("%s can not be used as a dynamic var", sym.getName()));
        }
        Var dv = this.getGlobalVar(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return (DynamicVar)dv;
            }
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The var '%s' is not defined as dynamic", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return null;
    }

    private VncVal getOrElse(VncSymbol sym, VncVal defaultVal) {
        Env e = this.findEnv(sym);
        if (e != null) {
            Var loc = e.getLocalVar(sym);
            return loc == null ? defaultVal : loc.getVal();
        }
        Var glob = this.getGlobalVar(sym);
        return glob == null ? defaultVal : glob.getVal();
    }

    private Env findEnv(VncSymbol sym) {
        if (this.hasLocalVar(sym)) {
            return this;
        }
        if (this.outer != null) {
            return this.outer.findEnv(sym);
        }
        return null;
    }

    private Var getGlobalVar(VncSymbol sym) {
        VncSymbol qualifiedKey;
        Var v;
        VncSymbol ns;
        String name = sym.getName();
        if (name.equals("*ns*")) {
            return new Var(Namespaces.NS_CURRENT_SYMBOL, Namespaces.getCurrentNS());
        }
        if (ReservedSymbols.isSpecialForm(name)) {
            return null;
        }
        boolean qualified = Namespaces.isQualified(name);
        if (qualified && name.startsWith("core/")) {
            return this.getGlobalVarRaw(new VncSymbol(name.substring(5)));
        }
        if (!qualified && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS()) && (v = this.getGlobalVarRaw(qualifiedKey = new VncSymbol(ns.getName() + "/" + name))) != null) {
            return v;
        }
        return this.getGlobalVarRaw(sym);
    }

    private Var getGlobalVarRaw(VncSymbol sym) {
        Var v;
        if (this.precompiledGlobalSymbols != null && (v = this.precompiledGlobalSymbols.get(sym)) != null) {
            return v;
        }
        return this.globalSymbols.get(sym);
    }

    private void setGlobalVar(VncSymbol sym, Var value) {
        this.globalSymbols.put(sym, value);
    }

    private Var getLocalVar(VncSymbol sym) {
        return this.localSymbols.get(sym);
    }

    private void setLocalVar(VncSymbol sym, Var value) {
        this.localSymbols.put(sym, value);
    }

    private boolean hasLocalVar(VncSymbol sym) {
        return this.localSymbols.containsKey(sym);
    }

    private Map<VncSymbol, Var> getAllGlobalSymbols() {
        HashMap<VncSymbol, Var> all = new HashMap<VncSymbol, Var>();
        if (this.precompiledGlobalSymbols != null) {
            all.putAll(this.precompiledGlobalSymbols);
        }
        all.putAll(this.globalSymbols);
        all.put(Namespaces.NS_CURRENT_SYMBOL, new Var(Namespaces.NS_CURRENT_SYMBOL, Namespaces.getCurrentNS()));
        return all;
    }

    public List<VncSymbol> getAllGlobalFunctionSymbols() {
        return this.getAllGlobalSymbols().entrySet().stream().filter(e -> ((Var)e.getValue()).getVal() instanceof VncFunction).map(e -> {
            VncFunction fn = (VncFunction)((Var)e.getValue()).getVal();
            return ((VncSymbol)e.getKey()).withMeta(VncHashMap.of(new VncKeyword("group"), new VncString(fn.getNamespace()), new VncKeyword("arglists"), fn.getArgLists(), new VncKeyword("doc"), fn.getDoc()));
        }).collect(Collectors.toList());
    }

    private PrintStream nullPrintStream() {
        return new PrintStream(new NullOutputStream(), true);
    }
}

