/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ModuleLoader {
    private static final Map<String, String> modules = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> classpathFiles = new ConcurrentHashMap<String, String>();
    public static final Set<String> VALID_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("app", "benchmark", "cidr", "core", "crypt", "csv", "geoip", "http", "jackson", "java", "kira", "math", "maven", "mercator", "parsatron", "ring", "semver", "shell", "test", "tomcat", "tomcat-util", "webdav", "xchart", "xml")));

    public static String loadModule(String module) {
        if (!VALID_MODULES.contains(module)) {
            throw new VncException(String.format("The Venice module '%s' does not exist", module));
        }
        String name = module + ".venice";
        try {
            return modules.computeIfAbsent(name, k -> new ClassPathResource(VeniceClasspath.getVeniceBasePath() + k).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice module '%s'", name), ex);
        }
    }

    public static String loadClasspathFile(String file) {
        if (!file.endsWith(".venice")) {
            throw new VncException(String.format("Must not load other than Venice (*.venice) resources from classpath. Resource: '%s'", new Object[0]));
        }
        try {
            return classpathFiles.computeIfAbsent(file, k -> new ClassPathResource(file).getResourceAsString("UTF-8"));
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load Venice classpath file '%s'", file), ex);
        }
    }
}

