/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.transducer.Reduced;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class TransducerFunctions {
    public static VncFunction transduce = new VncFunction("transduce", VncFunction.meta().arglists("(transduce xform f coll)", "(transduce xform f init coll)").doc("Reduce with a transformation of a reduction function f (xf). If init is not supplied, (f) will be called to produce it. f should be a reducing step function that accepts both 1 and 2 arguments. Returns the result of applying (the transformed) xf to init and the first item in coll, then applying xf to that result and the 2nd item, etc. If coll contains no items, returns init and f is not called.").examples("(do                                       \n  (def xform (map #(+ % 1)))              \n  (transduce xform + [1 2 3 4]))            ", "(do                                       \n  (def xform (map #(+ % 1)))              \n  (transduce xform conj [1 2 3 4]))         ", "(do                                       \n  (def xform (comp (drop 2) (take 3)))    \n  (transduce xform conj [1 2 3 4 5 6]))     ", "(do                                       \n  (def xform (comp                        \n              (map #(* % 10))             \n              (map #(- % 5))              \n              (sorted compare)            \n              (drop 3)                    \n              (take 2)                    \n              (reverse)))                 \n  (def coll [5 2 1 6 4 3])                \n  (str (transduce xform conj coll)))        ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("transduce", args, 3, 4);
            VncFunction xform = Coerce.toVncFunction(args.first());
            VncFunction reduction_fn = Coerce.toVncFunction(args.second());
            VncSequence coll = TransducerFunctions.coerceToSequence(args.last());
            VncVal init = args.size() == 4 ? args.third() : reduction_fn.apply(new VncList());
            VncFunction xf = (VncFunction)xform.apply(VncList.of(reduction_fn));
            VncVal ret = CoreFunctions.reduce.apply(VncList.of(xf, init, coll));
            return Reduced.unreduced(xf.apply(VncList.of(ret)));
        }
    };
    public static VncFunction reduced = new VncFunction("reduced", VncFunction.meta().arglists("(reduced x)").doc("Wraps x in a way such that a reduce will terminate with the value x.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduced", args, 1);
            return Reduced.reduced(args.first());
        }
    };
    public static VncFunction reduced_Q = new VncFunction("reduced?", VncFunction.meta().arglists("(reduced? x)").doc("Returns true if x is the result of a call to reduced.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reduced?", args, 1);
            return Reduced.isReduced(args.first()) ? Constants.True : Constants.False;
        }
    };
    public static VncFunction map = new VncFunction("map", VncFunction.meta().arglists("(map f coll colls*)").doc("Applys f to the set of first items of each coll, followed by applying f to the set of second items in each coll, until any one of the colls is exhausted. Any remaining items in other colls are ignored. Returns a transducer when no collection is provided.").examples("(map inc [1 2 3 4])", "(map + [1 2 3 4] [10 20 30 40])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 0) {
                return Constants.Nil;
            }
            if (args.size() == 1) {
                final VncFunction fn = Coerce.toVncFunction(args.first());
                return new VncFunction(4.createAnonymousFuncName("map:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        return new VncFunction(1.createAnonymousFuncName("map:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                return rf.apply(VncList.of(result, fn.apply(VncList.of(input))));
                            }
                        };
                    }
                };
            }
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncList lists = FunctionsUtil.removeNilValues(args.rest());
            ArrayList<VncVal> result = new ArrayList<VncVal>();
            if (lists.isEmpty()) {
                return Constants.Nil;
            }
            int index = 0;
            boolean hasMore = true;
            while (hasMore) {
                ArrayList<VncVal> fnArgs = new ArrayList<VncVal>();
                for (int ii = 0; ii < lists.size(); ++ii) {
                    VncVal seq = lists.nth(ii);
                    VncSequence nthList = TransducerFunctions.coerceToSequence(seq);
                    if (nthList.size() <= index) {
                        hasMore = false;
                        break;
                    }
                    fnArgs.add(nthList.nth(index));
                }
                if (!hasMore) continue;
                VncVal val = fn.apply(new VncList(fnArgs));
                result.add(val);
                ++index;
            }
            return new VncList(result);
        }
    };
    public static VncFunction map_indexed = new VncFunction("map-indexed", VncFunction.meta().arglists("(map-indexed f coll)").doc("Retruns a collection of applying f to 0 and the first item of coll, followed by applying f to 1 and the second item of coll, etc. until coll is exhausted. Returns a stateful transducer when no collection is provided.").examples("(map-indexed (fn [idx val] [idx val]) [:a :b :c])", "(map-indexed vector [:a :b :c])", "(map-indexed vector \"abcdef\")", "(map-indexed hash-map [:a :b :c])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            List<VncVal> items;
            if (args.size() == 0) {
                return Constants.Nil;
            }
            if (args.size() == 1) {
                final VncFunction fn = Coerce.toVncFunction(args.first());
                return new VncFunction(5.createAnonymousFuncName("map-indexed:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final AtomicLong idx = new AtomicLong(0L);
                        return new VncFunction(1.createAnonymousFuncName("map-indexed:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                return rf.apply(VncList.of(result, fn.apply(VncList.of(new VncLong(idx.getAndIncrement()), input))));
                            }
                        };
                    }
                };
            }
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncVal coll = args.second();
            if (Types.isVncList(coll)) {
                items = ((VncList)coll).getList();
            } else if (Types.isVncVector(coll)) {
                items = ((VncVector)coll).getList();
            } else if (Types.isVncSet(coll)) {
                items = ((VncSet)coll).getList();
            } else if (Types.isVncMap(coll)) {
                items = ((VncMap)coll).toVncList().getList();
            } else if (Types.isVncString(coll)) {
                items = ((VncString)coll).toVncList().getList();
            } else {
                throw new VncException("Function 'map-indexed' requires a list, vector, set, map, or string as coll argument.");
            }
            ArrayList<VncVal> list = new ArrayList<VncVal>();
            int index = 0;
            for (VncVal v : items) {
                list.add(fn.apply(VncList.of(new VncLong(index++), v)));
            }
            return new VncList(list);
        }
    };
    public static VncFunction filter = new VncFunction("filter", VncFunction.meta().arglists("(filter predicate coll)").doc("Returns a collection of the items in coll for which (predicate item) returns logical true. Returns a transducer when no collection is provided.").examples("(filter even? [1 2 3 4 5 6 7])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("filter", args, 1, 2);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                return new VncFunction(6.createAnonymousFuncName("filter:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        return new VncFunction(1.createAnonymousFuncName("filter:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                VncVal cond = predicate.apply(VncList.of(input));
                                return cond != Constants.False && cond != Constants.Nil ? rf.apply(VncList.of(result, input)) : result;
                            }
                        };
                    }
                };
            }
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = predicate.apply(VncList.of(val));
                if (keep == Constants.False || keep == Constants.Nil) continue;
                items.add(val);
            }
            return coll.withValues(items);
        }
    };
    public static VncFunction drop = new VncFunction("drop", VncFunction.meta().arglists("(drop n coll)").doc("Returns a collection of all but the first n items in coll. Returns a stateful transducer when no collection is provided.").examples("(drop 3 [1 2 3 4 5])", "(drop 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop", args, 1, 2);
            if (args.size() == 1) {
                final long n = Coerce.toVncLong(args.first()).getValue();
                return new VncFunction(7.createAnonymousFuncName("drop:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final AtomicLong nn = new AtomicLong(n);
                        return new VncFunction(1.createAnonymousFuncName("drop:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (nn.getAndDecrement() > 0L) {
                                    return result;
                                }
                                return rf.apply(VncList.of(result, input));
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            return coll.slice((int)Math.min(n.getValue() + 1L, (long)coll.size()));
        }
    };
    public static VncFunction drop_while = new VncFunction("drop-while", VncFunction.meta().arglists("(drop-while predicate coll)").doc("Returns a list of the items in coll starting from the first item for which (predicate item) returns logical false. Returns a stateful transducer when no collection is provided.").examples("(drop-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("drop-while", args, 1, 2);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                return new VncFunction(8.createAnonymousFuncName("drop-while:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final AtomicBoolean take = new AtomicBoolean(false);
                        return new VncFunction(1.createAnonymousFuncName("drop-while:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (take.get()) {
                                    return rf.apply(VncList.of(result, input));
                                }
                                VncVal drop = predicate.apply(VncList.of(input));
                                if (drop == Constants.True) {
                                    return result;
                                }
                                take.set(true);
                                return rf.apply(VncList.of(result, input));
                            }
                        };
                    }
                };
            }
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = predicate.apply(VncList.of(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(i);
            }
            return coll.empty();
        }
    };
    public static VncFunction take = new VncFunction("take", VncFunction.meta().arglists("(take n coll)").doc("Returns a collection of the first n items in coll, or all items if there are fewer than n. Returns a stateful transducer when no collection is provided.").examples("(take 3 [1 2 3 4 5])", "(take 10 [1 2 3 4 5])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take", args, 1, 2);
            if (args.size() == 1) {
                final long n = Coerce.toVncLong(args.first()).getValue();
                return new VncFunction(9.createAnonymousFuncName("take:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final AtomicLong nn = new AtomicLong(n);
                        return new VncFunction(1.createAnonymousFuncName("take:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (nn.getAndDecrement() > 0L) {
                                    return rf.apply(VncList.of(result, input));
                                }
                                return Reduced.reduced(result);
                            }
                        };
                    }
                };
            }
            VncLong n = Coerce.toVncLong(args.first());
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            return coll.slice(0, (int)Math.min(n.getValue(), (long)coll.size()));
        }
    };
    public static VncFunction take_while = new VncFunction("take-while", VncFunction.meta().arglists("(take-while predicate coll)").doc("Returns a list of successive items from coll while (predicate item) returns logical true. Returns a transducer when no collection is provided.").examples("(take-while neg? [-2 -1 0 1 2 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("take-while", args, 1, 2);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                return new VncFunction(10.createAnonymousFuncName("take-while:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        return new VncFunction(1.createAnonymousFuncName("take-while:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                VncVal take = predicate.apply(VncList.of(input));
                                if (take == Constants.True) {
                                    return rf.apply(VncList.of(result, input));
                                }
                                return Reduced.reduced(result);
                            }
                        };
                    }
                };
            }
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            for (int i = 0; i < coll.size(); ++i) {
                VncVal take = predicate.apply(VncList.of(coll.nth(i)));
                if (take != Constants.False) continue;
                return coll.slice(0, i);
            }
            return coll;
        }
    };
    public static VncFunction keep = new VncFunction("keep", VncFunction.meta().arglists("(keep f coll)").doc("Returns a sequence of the non-nil results of (f item). Note, this means false return values will be included. f must be free of side-effects. Returns a transducer when no collection is provided.").examples("(keep even? (range 1 4))", "(keep (fn [x] (if (odd? x) x)) (range 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("keep", args, 1, 2);
            if (args.size() == 1) {
                final VncFunction fn = Coerce.toVncFunction(args.first());
                return new VncFunction(11.createAnonymousFuncName("keep:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        return new VncFunction(1.createAnonymousFuncName("keep:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                VncVal val = fn.apply(VncList.of(input));
                                return val == Constants.Nil ? result : rf.apply(VncList.of(result, input));
                            }
                        };
                    }
                };
            }
            VncVal result = map.apply(args);
            return result == Constants.Nil ? Constants.Nil : FunctionsUtil.removeNilValues(Coerce.toVncList(result));
        }
    };
    public static VncFunction dedupe = new VncFunction("dedupe", VncFunction.meta().arglists("(dedupe coll)").doc("Returns a collection with all consecutive duplicates removed. Returns a stateful transducer when no collection is provided.").examples("(dedupe [1 2 2 2 3 4 4 2 3])", "(dedupe '(1 2 2 2 3 4 4 2 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dedupe", args, 0, 1);
            if (args.isEmpty()) {
                return new VncFunction(12.createAnonymousFuncName("dedupe:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final AtomicReference<VncKeyword> seen = new AtomicReference<VncKeyword>(NONE);
                        return new VncFunction(1.createAnonymousFuncName("dedupe:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (!input.equals(seen.get())) {
                                    seen.set(input);
                                    return rf.apply(VncList.of(result, input));
                                }
                                return result;
                            }
                        };
                    }
                };
            }
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            VncVal seen = NONE;
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (VncVal val : TransducerFunctions.coerceToSequence(args.first()).getList()) {
                if (val.equals(seen)) continue;
                items.add(val);
                seen = val;
            }
            return ((VncSequence)args.first()).withValues(items);
        }
    };
    public static VncFunction remove = new VncFunction("remove", VncFunction.meta().arglists("(remove predicate coll)").doc("Returns a collection of the items in coll for which (predicate item) returns logical false. Returns a transducer when no collection is provided.").examples("(remove even? [1 2 3 4 5 6 7])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove", args, 1, 2);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                VncFunction fn = new VncFunction(13.createAnonymousFuncName("remove:transducer")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        return predicate.apply(args) == Constants.True ? Constants.False : Constants.True;
                    }
                };
                return filter.apply(VncList.of(fn));
            }
            VncSequence coll = TransducerFunctions.coerceToSequence(args.second());
            ArrayList<VncVal> items = new ArrayList<VncVal>();
            for (int i = 0; i < coll.size(); ++i) {
                VncVal val = coll.nth(i);
                VncVal keep = predicate.apply(VncList.of(val));
                if (keep != Constants.False) continue;
                items.add(val);
            }
            return coll.withValues(items);
        }
    };
    public static VncFunction distinct = new VncFunction("distinct", VncFunction.meta().arglists("(distinct coll)").doc("Returns a collection with all duplicates removed. Returns a stateful transducer when no collection is provided.").examples("(distinct [1 2 3 4 2 3 4])", "(distinct '(1 2 3 4 2 3 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("distinct", args, 0, 1);
            if (args.isEmpty()) {
                return new VncFunction(14.createAnonymousFuncName("distinct:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final HashSet seen = new HashSet();
                        return new VncFunction(1.createAnonymousFuncName("distinct:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (seen.contains(input)) {
                                    return result;
                                }
                                seen.add(input);
                                return rf.apply(VncList.of(result, input));
                            }
                        };
                    }
                };
            }
            if (args.first() == Constants.Nil) {
                return new VncList();
            }
            return ((VncSequence)args.first()).withValues(Coerce.toVncSequence(args.first()).getList().stream().distinct().collect(Collectors.toList()));
        }
    };
    public static VncFunction sorted = new VncFunction("sorted", VncFunction.meta().arglists("(sorted cmp coll)").doc("Returns a sorted collection using the compare function cmp. The compare function takes two arguments and returns -1, 0, or 1. Returns a stateful transducer when no collection is provided.").examples("(sorted compare [4 2 1 5 6 3])", "(sorted (comp (partial * -1) compare) [4 2 1 5 6 3])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sorted", args, 1, 2);
            final VncFunction compfn = Coerce.toVncFunction(args.first());
            if (args.size() == 1) {
                return new VncFunction(15.createAnonymousFuncName("sorted:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final ArrayList list = new ArrayList();
                        return new VncFunction(1.createAnonymousFuncName("sorted:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    VncVal sortedList = CoreFunctions.sort.apply(VncList.of(compfn, new VncList(list)));
                                    result = CoreFunctions.reduce.apply(VncList.of(rf, result, sortedList));
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                list.add(input);
                                return result;
                            }
                        };
                    }
                };
            }
            return CoreFunctions.sort.apply(args);
        }
    };
    public static VncFunction reverse = new VncFunction("reverse", VncFunction.meta().arglists("(reverse coll)").doc("Returns a collection of the items in coll in reverse order. Returns a stateful transducer when no collection is provided.").examples("(reverse [1 2 3 4 5 6])", "(reverse \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reverse", args, 0, 1);
            if (args.size() == 0) {
                return new VncFunction(16.createAnonymousFuncName("reverse:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        final ArrayList list = new ArrayList();
                        return new VncFunction(1.createAnonymousFuncName("reverse:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    Collections.reverse(list);
                                    result = CoreFunctions.reduce.apply(VncList.of(rf, result, new VncList(list)));
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                list.add(input);
                                return result;
                            }
                        };
                    }
                };
            }
            VncVal coll = args.first();
            if (coll == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncList(coll)) {
                return TransducerFunctions.reverseList(((VncList)coll).getList());
            }
            if (Types.isVncVector(coll)) {
                return TransducerFunctions.reverseVector(((VncVector)coll).getList());
            }
            if (Types.isVncSet(coll)) {
                return TransducerFunctions.reverseList(((VncSet)coll).getList());
            }
            if (Types.isVncMap(coll)) {
                return TransducerFunctions.reverseList(((VncMap)coll).toVncList().getList());
            }
            if (Types.isVncString(coll)) {
                return TransducerFunctions.reverseList(((VncString)coll).toVncList().getList());
            }
            throw new VncException("Function 'reverse' requires a list, vector, set, map, or string as coll argument.");
        }
    };
    public static VncFunction flatten = new VncFunction("flatten", VncFunction.meta().arglists("(flatten coll)").doc("Takes any nested combination of collections (lists, vectors, etc.) and returns their contents as a single, flat sequence. (flatten nil) returns an empty list.Returns a transducer when no collection is provided.").examples("(flatten [])", "(flatten [[1 2 3] [4 [5 6]] [7 [8 [9]]]])", "(flatten [1 2 {:a 3 :b [4 5 6]}])", "(flatten (seq {:a 1 :b 2}))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("flatten", args, 0, 1);
            if (args.size() == 0) {
                return new VncFunction(17.createAnonymousFuncName("flatten:transducer:wrapped")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public VncVal apply(VncList args) {
                        FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                        final VncFunction rf = Coerce.toVncFunction(args.first());
                        return new VncFunction(1.createAnonymousFuncName("flatten:transducer")){
                            private static final long serialVersionUID = -1L;

                            @Override
                            public VncVal apply(VncList args) {
                                FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                                if (args.size() == 0) {
                                    return rf.apply(new VncList());
                                }
                                if (args.size() == 1) {
                                    VncVal result = args.first();
                                    return rf.apply(VncList.of(result));
                                }
                                VncVal result = args.first();
                                VncVal input = args.second();
                                if (Types.isVncCollection(input)) {
                                    for (VncVal v : TransducerFunctions.flatten(Coerce.toVncCollection(input))) {
                                        result = rf.apply(VncList.of(result, v));
                                    }
                                    return result;
                                }
                                return rf.apply(VncList.of(result, input));
                            }
                        };
                    }
                };
            }
            VncCollection coll = Coerce.toVncCollection(args.first());
            List result = TransducerFunctions.flatten(coll);
            return Types.isVncVector(coll) ? new VncVector(result) : new VncList(result);
        }
    };
    public static VncFunction halt_when = new VncFunction("halt-when", VncFunction.meta().arglists("(halt-when pred)", "(halt-when pred retf)").doc("Returns a transducer that ends transduction when pred returns true for an input. When retf is supplied it must be a fn of 2 arguments - it will be passed the (completed) result so far and the input that triggered the predicate, and its return value (if it does not throw an exception) will be the return value of the  If retf is not supplied, the input that triggered the predicate will be returned. If the predicate never returns true the transduction is unaffected.").examples("(do                                                     \n  (def xf (comp (halt-when #(== % 10)) (filter odd?)))  \n  (transduce xf conj [1 2 3 4 5 6 7 8 9]))                ", "(do                                                     \n  (def xf (comp (halt-when #(> % 5)) (filter odd?)))    \n  (transduce xf conj [1 2 3 4 5 6 7 8 9]))                ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("halt-when", args, 1, 2, 3);
            final VncFunction predicate = Coerce.toVncFunction(args.first());
            final VncFunction halt_return_fn = args.size() > 1 ? Coerce.toVncFunction(args.second()) : null;
            final VncFunction no_halt_return_fn = args.size() > 2 ? Coerce.toVncFunction(args.third()) : null;
            return new VncFunction(18.createAnonymousFuncName("halt-when:transducer:wrapped")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    FunctionsUtil.assertArity(this.getQualifiedName(), args, 1);
                    final VncFunction rf = Coerce.toVncFunction(args.first());
                    return new VncFunction(1.createAnonymousFuncName("halt-when:transducer")){
                        private static final long serialVersionUID = -1L;

                        @Override
                        public VncVal apply(VncList args) {
                            FunctionsUtil.assertArity(this.getQualifiedName(), args, 1, 2, 3);
                            if (args.size() == 0) {
                                return rf.apply(new VncList());
                            }
                            if (args.size() == 1) {
                                VncVal result = args.first();
                                if (Types.isVncMap(result) && ((VncMap)result).containsKey(HALT) == Constants.True) {
                                    return ((VncMap)result).get(HALT);
                                }
                                if (no_halt_return_fn != null) {
                                    return no_halt_return_fn.apply(VncList.of(result));
                                }
                                return rf.apply(VncList.of(result));
                            }
                            VncVal result = args.first();
                            VncVal input = args.second();
                            VncVal cond = predicate.apply(VncList.of(input));
                            if (cond != Constants.False && cond != Constants.Nil) {
                                VncVal haltVal = halt_return_fn != null ? halt_return_fn.apply(VncList.of(rf.apply(VncList.of(result)), input)) : input;
                                return Reduced.reduced(VncHashMap.of(HALT, haltVal));
                            }
                            return rf.apply(VncList.of(result, input));
                        }
                    };
                }
            };
        }
    };
    public static final VncKeyword HALT = new VncKeyword("@halt");
    private static final VncKeyword NONE = new VncKeyword("@none");
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(transduce).add(reduced).add(reduced_Q).add(map).add(map_indexed).add(filter).add(drop).add(drop_while).add(take).add(take_while).add(keep).add(dedupe).add(remove).add(distinct).add(sorted).add(reverse).add(flatten).add(halt_when).toMap();

    private static List<VncVal> flatten(VncVal value) {
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        TransducerFunctions.flatten(value, list);
        return list;
    }

    private static void flatten(VncVal value, List<VncVal> result) {
        if (Types.isVncSequence(value)) {
            Coerce.toVncSequence(value).forEach(v -> TransducerFunctions.flatten(v, result));
        } else {
            result.add(value);
        }
    }

    private static VncList reverseList(List<VncVal> list) {
        ArrayList<VncVal> copy = new ArrayList<VncVal>(list);
        Collections.reverse(copy);
        return new VncList(copy);
    }

    private static VncVector reverseVector(List<VncVal> list) {
        ArrayList<VncVal> copy = new ArrayList<VncVal>(list);
        Collections.reverse(copy);
        return new VncVector(copy);
    }

    private static VncSequence coerceToSequence(VncVal val) {
        if (Types.isVncMap(val)) {
            return new VncList(((VncMap)val).entries());
        }
        if (Types.isVncSet(val)) {
            return ((VncSet)val).toVncList();
        }
        if (Types.isVncString(val)) {
            return ((VncString)val).toVncList();
        }
        return Coerce.toVncSequence(val);
    }
}

