/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.sandbox;

import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import java.io.Serializable;

public class SandboxMaxExecutionTimeChecker
implements Serializable {
    private static final long serialVersionUID = -2470884288885597614L;
    private final long sandboxDeadlineTime = SandboxMaxExecutionTimeChecker.getSandboxDeadlineTime();

    public void check() {
        if (this.sandboxDeadlineTime > 0L && System.currentTimeMillis() > this.sandboxDeadlineTime) {
            throw new SecurityException("Venice Sandbox: The sandbox exceeded the max execution time");
        }
    }

    private static long getSandboxDeadlineTime() {
        Integer maxExecTimeSeconds = JavaInterop.getInterceptor().getMaxExecutionTimeSeconds();
        return maxExecTimeSeconds == null ? -1L : System.currentTimeMillis() + 1000L * maxExecTimeSeconds.longValue();
    }
}

