/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;

public class VncChar
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Character value;

    public VncChar(Character v) {
        this(v, (VncVal)Constants.Nil);
    }

    public VncChar(char v) {
        this(v, (VncVal)Constants.Nil);
    }

    public VncChar(Character v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    public VncChar(char v, VncVal meta) {
        super(meta);
        this.value = Character.valueOf(v);
    }

    public Character getValue() {
        return this.value;
    }

    @Override
    public VncChar withMeta(VncVal meta) {
        return new VncChar(this.value, meta);
    }

    @Override
    public int typeRank() {
        return 5;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncChar(o)) {
            return this.getValue().compareTo(((VncChar)o).getValue());
        }
        if (Types.isVncString(o)) {
            return this.getValue().toString().compareTo(((VncString)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncChar other = (VncChar)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String toString(boolean print_readably) {
        if (print_readably) {
            return "\"" + StringUtil.escape(this.value.toString()) + "\"";
        }
        return this.value.toString();
    }
}

