/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncLong
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Long value;

    public VncLong(Long v) {
        this(v, Constants.Nil);
    }

    public VncLong(Integer v) {
        this(v.longValue(), Constants.Nil);
    }

    public VncLong(Long v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    @Override
    public VncLong withMeta(VncVal meta) {
        return new VncLong(this.value, meta);
    }

    public VncLong negate() {
        return new VncLong(this.value * -1L);
    }

    public Long getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        return this.value.intValue();
    }

    @Override
    public int typeRank() {
        return 2;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).getLongValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToLong((VncDouble)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToLong((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncLong other = (VncLong)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

