/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.Seq;
import org.repackage.io.vavr.collection.Vector;

public class VncList
extends VncSequence {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Vector<VncVal> value;

    public VncList() {
        this((Seq<VncVal>)null, null);
    }

    public VncList(VncVal meta) {
        this((Seq<VncVal>)null, meta);
    }

    public VncList(Collection<? extends VncVal> vals) {
        this(vals, null);
    }

    public VncList(Collection<? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : Vector.ofAll(vals), meta);
    }

    public VncList(Seq<VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? Vector.empty() : (vals instanceof Vector ? (Vector<Object>)vals : Vector.ofAll(vals));
    }

    public static VncList of(VncVal ... mvs) {
        return new VncList(Vector.of(mvs), (VncVal)Constants.Nil);
    }

    @Override
    public VncList empty() {
        return new VncList(this.getMeta());
    }

    @Override
    public VncList withVariadicValues(VncVal ... replaceVals) {
        return VncList.of(replaceVals);
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals) {
        return new VncList(replaceVals, this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return new VncList(replaceVals, meta);
    }

    @Override
    public VncList withMeta(VncVal meta) {
        return new VncList(this.value, meta);
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public List<VncVal> getList() {
        return this.value.toJavaList();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a list of size %d. %s", idx, this.size(), this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.value.get(0))));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.head();
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.last();
    }

    @Override
    public VncList rest() {
        return this.isEmpty() ? new VncList(this.getMeta()) : new VncList(this.value.tail(), this.getMeta());
    }

    @Override
    public VncList slice(int start, int end) {
        return new VncList(this.value.subSequence(start, end), this.getMeta());
    }

    @Override
    public VncList slice(int start) {
        return new VncList(this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return this;
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value, this.getMeta());
    }

    @Override
    public VncList addAtStart(VncVal val) {
        return new VncList(this.value.prepend((Object)val), this.getMeta());
    }

    @Override
    public VncList addAllAtStart(VncSequence list) {
        List<VncVal> items = list.getList();
        Collections.reverse(items);
        return new VncList(this.value.prependAll(items), this.getMeta());
    }

    @Override
    public VncList addAtEnd(VncVal val) {
        return new VncList(this.value.append((Object)val), this.getMeta());
    }

    @Override
    public VncList addAllAtEnd(VncSequence list) {
        return new VncList(this.value.appendAll(list.getList()), this.getMeta());
    }

    @Override
    public VncList setAt(int idx, VncVal val) {
        return new VncList(this.value.update(idx, (Object)val), this.getMeta());
    }

    @Override
    public VncList removeAt(int idx) {
        return new VncList(this.value.removeAt(idx), this.getMeta());
    }

    @Override
    public int typeRank() {
        return 200;
    }

    @Override
    public Object convertToJavaObject() {
        return this.getList().stream().map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncList)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncList other = (VncList)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(" + Printer.join(this.value.toJavaList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.value.toJavaList(), " ", print_readably) + ")";
    }
}

