/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.pdf;

import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextUserAgent;

public class ClasspathUserAgent
extends ITextUserAgent {
    private final Map<String, ByteBuffer> cachedResources = new ConcurrentHashMap<String, ByteBuffer>();

    public ClasspathUserAgent(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    public ClasspathUserAgent addResource(String path, ByteBuffer data) {
        if (StringUtil.isBlank(path)) {
            throw new IllegalArgumentException("A 'resource' path must not be blank");
        }
        if (data == null) {
            throw new IllegalArgumentException("A 'resource' data must not be null");
        }
        if (this.isClasspathScheme(path) || this.isMemoryScheme(path)) {
            throw new RuntimeException("An in-memory resource path must not be an URI with a scheme like 'memory:/charts/001.png' just pass '/charts/001.png'. Path was: " + path);
        }
        this.cachedResources.put(path, data);
        return this;
    }

    protected InputStream resolveAndOpenStream(String uri) {
        if (uri == null) {
            return null;
        }
        boolean debug = this.isDebugScheme(uri);
        if (this.isClasspathScheme(uri)) {
            this.log(debug, "FlyingSaucer: Classpath URI=" + uri);
            ByteBuffer data = this.cachedResources.get(uri);
            if (data != null) {
                this.log(debug, "FlyingSaucer: Resolved '" + uri + "' from cache.");
                return new ByteArrayInputStream(data.array());
            }
            String path = this.stripLeadingSlashes(this.stripScheme(uri));
            data = this.slurp(new ClassPathResource(path));
            if (data != null) {
                this.log(debug, "FlyingSaucer: Resolved reource '" + path + "' from classpath.");
                this.cachedResources.put(uri, data);
                return new ByteArrayInputStream(data.array());
            }
            this.log(debug, "FlyingSaucer: Resource '" + path + "' not found on classpath.");
            return null;
        }
        if (this.isMemoryScheme(uri)) {
            this.log(debug, "FlyingSaucer: Memory URI=" + uri);
            String path = this.stripScheme(uri);
            ByteBuffer data = this.cachedResources.get(path);
            if (data != null) {
                this.log(debug, "FlyingSaucer: Resolved '" + path + "' from memory.");
                return new ByteArrayInputStream(data.array());
            }
            this.log(debug, "FlyingSaucer: Resource '" + path + "' not found in memory.");
            return null;
        }
        this.log(debug, "FlyingSaucer: Unknown URI=" + uri);
        return super.resolveAndOpenStream(uri);
    }

    private boolean isDebugScheme(String uri) {
        return this.isScheme(uri, "classpath-debug:", "memory-debug:");
    }

    private boolean isClasspathScheme(String uri) {
        return this.isScheme(uri, "classpath:", "classpath-debug:");
    }

    private boolean isMemoryScheme(String uri) {
        return this.isScheme(uri, "memory:", "memory-debug:");
    }

    private boolean isScheme(String uri, String ... scheme) {
        return Arrays.stream(scheme).anyMatch(s -> uri.startsWith((String)s));
    }

    private String stripScheme(String uri) {
        int pos = uri.indexOf(58);
        return pos < 0 ? uri : uri.substring(pos + 1);
    }

    private String stripLeadingSlashes(String path) {
        if (StringUtil.isBlank(path)) {
            return path;
        }
        String p = path.trim();
        while (p.startsWith("/")) {
            p = StringUtil.removeStart(p, "/");
        }
        return p;
    }

    private ByteBuffer slurp(ClassPathResource cpResource) {
        return cpResource.getResourceAsByteBuffer();
    }

    private void log(boolean debug, String message) {
        if (debug) {
            System.out.println(message);
        }
    }
}

