/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.repackage.org.jline.builtins.Commands;
import org.repackage.org.jline.builtins.Completers;
import org.repackage.org.jline.builtins.Options;
import org.repackage.org.jline.builtins.TTop;
import org.repackage.org.jline.builtins.Widgets;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.reader.ConfigurationPath;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.Widget;
import org.repackage.org.jline.reader.impl.completer.ArgumentCompleter;
import org.repackage.org.jline.reader.impl.completer.NullCompleter;
import org.repackage.org.jline.reader.impl.completer.StringsCompleter;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.AttributedString;

public class Builtins {
    private ConfigurationPath configPath;
    private final Function<String, Widget> widgetCreator;
    private final Supplier<Path> workDir;
    private Map<Command, String> commandName = new HashMap<Command, String>();
    private Map<String, Command> nameCommand = new HashMap<String, Command>();
    private Map<String, String> aliasCommand = new HashMap<String, String>();
    private final Map<Command, CommandMethods> commandExecute = new HashMap<Command, CommandMethods>();
    private LineReader reader;
    private Exception exception;

    public Builtins(Path workDir, ConfigurationPath configPath, Function<String, Widget> widgetCreator) {
        this(null, () -> workDir, configPath, widgetCreator);
    }

    public Builtins(Set<Command> commands, Path workDir, ConfigurationPath configpath, Function<String, Widget> widgetCreator) {
        this(commands, () -> workDir, configpath, widgetCreator);
    }

    public Builtins(Supplier<Path> workDir, ConfigurationPath configPath, Function<String, Widget> widgetCreator) {
        this(null, workDir, configPath, widgetCreator);
    }

    public Builtins(Set<Command> commands, Supplier<Path> workDir, ConfigurationPath configpath, Function<String, Widget> widgetCreator) {
        this.configPath = configpath;
        this.widgetCreator = widgetCreator;
        this.workDir = workDir;
        HashSet<Object> cmds = new HashSet();
        cmds = commands == null ? new HashSet<Command>(EnumSet.allOf(Command.class)) : new HashSet<Command>(commands);
        for (Command c : cmds) {
            this.commandName.put(c, c.name().toLowerCase());
        }
        this.doNameCommand();
        this.commandExecute.put(Command.NANO, new CommandMethods(this::nano, this::nanoCompleter));
        this.commandExecute.put(Command.LESS, new CommandMethods(this::less, this::lessCompleter));
        this.commandExecute.put(Command.HISTORY, new CommandMethods(this::history, this::historyCompleter));
        this.commandExecute.put(Command.WIDGET, new CommandMethods(this::widget, this::widgetCompleter));
        this.commandExecute.put(Command.KEYMAP, new CommandMethods(this::keymap, this::keymapCompleter));
        this.commandExecute.put(Command.SETOPT, new CommandMethods(this::setopt, this::setoptCompleter));
        this.commandExecute.put(Command.SETVAR, new CommandMethods(this::setvar, this::setvarCompleter));
        this.commandExecute.put(Command.UNSETOPT, new CommandMethods(this::unsetopt, this::unsetoptCompleter));
        this.commandExecute.put(Command.TTOP, new CommandMethods(this::ttop, this::ttopCompleter));
    }

    private void doNameCommand() {
        this.nameCommand = this.commandName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void setLineReader(LineReader reader) {
        this.reader = reader;
    }

    public void rename(Command command, String newName) {
        if (this.nameCommand.containsKey(newName)) {
            throw new IllegalArgumentException("Duplicate command name!");
        }
        if (!this.commandName.containsKey((Object)command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.commandName.put(command, newName);
        this.doNameCommand();
    }

    public void alias(String alias, String command) {
        if (!this.nameCommand.keySet().contains(command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.aliasCommand.put(alias, command);
    }

    public boolean hasCommand(String name) {
        return this.nameCommand.containsKey(name) || this.aliasCommand.containsKey(name);
    }

    public Completers.SystemCompleter compileCompleters() {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        for (Map.Entry<Command, String> entry : this.commandName.entrySet()) {
            out.add(entry.getValue(), this.commandExecute.get((Object)entry.getKey()).compileCompleter().apply(entry.getValue()));
        }
        out.addAliases(this.aliasCommand);
        return out;
    }

    private Command command(String name) {
        Command out = null;
        if (!this.hasCommand(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        if (this.aliasCommand.containsKey(name)) {
            name = this.aliasCommand.get(name);
        }
        if (!this.nameCommand.containsKey(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        out = this.nameCommand.get(name);
        return out;
    }

    private void execute(String command, List<String> args) throws Exception {
        this.execute(command, args, System.in, System.out, System.err);
    }

    public void execute(String command, List<String> args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        this.execute(command, args.toArray(new String[0]), in, out, err);
    }

    public void execute(String command, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        this.exception = null;
        this.commandExecute.get((Object)this.command(command)).execute().accept(new CommandInput(args, in, out, err));
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public Widgets.CmdDesc commandDescription(String command) {
        Widgets.CmdDesc out = null;
        List<String> args = Arrays.asList("--help");
        try {
            this.execute(command, args);
        }
        catch (Options.HelpException e) {
            ArrayList<AttributedString> main = new ArrayList<AttributedString>();
            HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
            String[] msg = e.getMessage().replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
            String prevOpt = null;
            boolean mainDone = false;
            boolean start = false;
            for (String s : msg) {
                int ind;
                if (!start) {
                    if (!s.trim().startsWith("Usage: ")) continue;
                    s = s.split("Usage:")[1];
                    start = true;
                }
                if (s.matches("^\\s+-.*$")) {
                    mainDone = true;
                    ind = s.lastIndexOf("  ");
                    if (ind > 0) {
                        String o = s.substring(0, ind);
                        String d = s.substring(ind);
                        if (o.trim().length() > 0) {
                            prevOpt = o.trim();
                            options.put(prevOpt, new ArrayList<AttributedString>(Arrays.asList(this.highlightComment(d.trim()))));
                        }
                    }
                } else if (s.matches("^[\\s]{20}.*$") && prevOpt != null && options.containsKey(prevOpt)) {
                    ind = s.lastIndexOf("  ");
                    if (ind > 0) {
                        ((List)options.get(prevOpt)).add(this.highlightComment(s.substring(ind).trim()));
                    }
                } else {
                    prevOpt = null;
                }
                if (mainDone) continue;
                main.add(Options.HelpException.highlightSyntax(s.trim(), Options.HelpException.defaultStyle()));
            }
            out = new Widgets.CmdDesc(main, Widgets.ArgDesc.doArgNames(Arrays.asList("")), options);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private Map<String, String> commandOptions(String command) {
        HashMap<String, String> out = new HashMap<String, String>();
        List<String> args = Arrays.asList("--help");
        try {
            this.execute(command, args);
        }
        catch (Options.HelpException e) {
            String[] msg = e.getMessage().replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
            boolean start = false;
            for (String s : msg) {
                int ind;
                if (!start) {
                    if (!s.trim().startsWith("Usage: ")) continue;
                    s = s.split("Usage:")[1];
                    start = true;
                }
                if (!s.matches("^\\s+-.*$") || (ind = s.lastIndexOf("  ")) <= 0) continue;
                String op = s.substring(0, ind).trim();
                String d = s.substring(ind).trim();
                if (op.length() <= 0) continue;
                for (String o : op.split("\\s+")) {
                    out.put(o, d);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private AttributedString highlightComment(String comment) {
        return Options.HelpException.highlightComment(comment, Options.HelpException.defaultStyle());
    }

    private Terminal terminal() {
        return this.reader.getTerminal();
    }

    private void less(CommandInput input) {
        try {
            Commands.less(this.terminal(), input.in(), input.out(), input.err(), this.workDir.get(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void nano(CommandInput input) {
        try {
            Commands.nano(this.terminal(), input.out(), input.err(), this.workDir.get(), input.args(), this.configPath);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void history(CommandInput input) {
        try {
            Commands.history(this.reader, input.out(), input.err(), this.workDir.get(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void widget(CommandInput input) {
        try {
            Commands.widget(this.reader, input.out(), input.err(), this.widgetCreator, input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void keymap(CommandInput input) {
        try {
            Commands.keymap(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void setopt(CommandInput input) {
        try {
            Commands.setopt(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void setvar(CommandInput input) {
        try {
            Commands.setvar(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void unsetopt(CommandInput input) {
        try {
            Commands.unsetopt(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void ttop(CommandInput input) {
        try {
            TTop.ttop(this.terminal(), input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private List<String> unsetOptions(boolean set) {
        ArrayList<String> out = new ArrayList<String>();
        for (LineReader.Option option : LineReader.Option.values()) {
            if (set != (this.reader.isSet(option) == option.isDef())) continue;
            out.add((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
        }
        return out;
    }

    private Set<String> allWidgets() {
        HashSet<String> out = new HashSet<String>();
        for (String s : this.reader.getWidgets().keySet()) {
            out.add(s);
            out.add(this.reader.getWidgets().get(s).toString());
        }
        return out;
    }

    private List<Completer> nanoCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(new Completers.FilesCompleter(this.workDir), this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> lessCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(new Completers.FilesCompleter(this.workDir), this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> historyCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(NullCompleter.INSTANCE, this::commandOptions, 1)));
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter((Iterable<String>)Arrays.asList("-A", "-W", "-R", "-AI", "-RI", "-WI")), new Completers.FilesCompleter(this.workDir), NullCompleter.INSTANCE));
        return completers;
    }

    private List<Completer> widgetCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(NullCompleter.INSTANCE, this::commandOptions, 1)));
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter("-A"), new StringsCompleter(() -> this.allWidgets()), new StringsCompleter(() -> this.reader.getWidgets().keySet()), NullCompleter.INSTANCE));
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter("-D"), new StringsCompleter(() -> this.reader.getWidgets().keySet())));
        return completers;
    }

    private List<Completer> keymapCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> setvarCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter(() -> this.reader.getVariables().keySet()), NullCompleter.INSTANCE));
        return completers;
    }

    private List<Completer> setoptCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter(() -> this.unsetOptions(true))));
        return completers;
    }

    private List<Completer> unsetoptCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new StringsCompleter(() -> this.unsetOptions(false))));
        return completers;
    }

    private List<Completer> ttopCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(new StringsCompleter(name), new Completers.OptionCompleter(NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    private class CommandMethods {
        Consumer<CommandInput> execute;
        Function<String, List<Completer>> compileCompleter;

        public CommandMethods(Consumer<CommandInput> execute, Function<String, List<Completer>> compileCompleter) {
            this.execute = execute;
            this.compileCompleter = compileCompleter;
        }

        public Consumer<CommandInput> execute() {
            return this.execute;
        }

        public Function<String, List<Completer>> compileCompleter() {
            return this.compileCompleter;
        }
    }

    private class CommandInput {
        String[] args;
        InputStream in;
        PrintStream out;
        PrintStream err;

        public CommandInput(String[] args, InputStream in, PrintStream out, PrintStream err) {
            this.args = args;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public String[] args() {
            return this.args;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }

    public static enum Command {
        NANO,
        LESS,
        HISTORY,
        WIDGET,
        KEYMAP,
        SETOPT,
        SETVAR,
        UNSETOPT,
        TTOP;

    }
}

