/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.reader;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.repackage.org.jline.reader.ParsedLine;
import org.repackage.org.jline.reader.SyntaxError;

public interface Parser {
    public ParsedLine parse(String var1, int var2, ParseContext var3) throws SyntaxError;

    default public ParsedLine parse(String line, int cursor) throws SyntaxError {
        return this.parse(line, cursor, ParseContext.UNSPECIFIED);
    }

    default public boolean isEscapeChar(char ch) {
        return ch == '\\';
    }

    public static String getCommand(String line) {
        String out = null;
        Pattern patternCommand = Pattern.compile("^\\s*[a-zA-Z]{1,}[a-zA-Z0-9]*=([a-zA-Z]{1,}[a-zA-Z0-9]*)(\\s+|$)");
        Matcher matcher = patternCommand.matcher(line);
        out = matcher.find() ? matcher.group(1) : line.trim().split("\\s+")[0];
        return out;
    }

    public static enum ParseContext {
        UNSPECIFIED,
        ACCEPT_LINE,
        COMPLETE,
        SECONDARY_PROMPT;

    }
}

