/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.functions.IOFnBlacklisted;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.Interceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RejectAllInterceptor
extends Interceptor {
    private static final String PREFIX = "Venice Sandbox (RejectAllInterceptor)";
    private final Set<String> blacklistedVeniceFunctions = IOFnBlacklisted.getIoFunctions();

    @Override
    public Object onInvokeInstanceMethod(IInvoker invoker, Object receiver, String method, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public Object onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public Object onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public Object onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public Object onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getName()));
    }

    @Override
    public Object onGetInstanceField(IInvoker invoker, Object receiver, String fieldName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to target %s", PREFIX, receiver.getClass().getName()));
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to classpath resource '%s'", PREFIX, resourceName));
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to system property '%s'", PREFIX, propertyName));
    }

    @Override
    public String onReadSystemEnv(String name) throws SecurityException {
        throw new SecurityException(String.format("%s: Access denied to system environment variable '%s'", PREFIX, name));
    }

    @Override
    public void validateVeniceFunction(String funcName) throws SecurityException {
        if (this.blacklistedVeniceFunctions.contains(funcName)) {
            throw new SecurityException(String.format("%s: Access denied to Venice function %s.", PREFIX, funcName));
        }
    }

    @Override
    public void validateLoadModule(String moduleName) throws SecurityException {
        if (!SandboxRules.DEFAULT_WHITELISTED_MODULES.contains(moduleName)) {
            throw new SecurityException(String.format("%s: Access denied to Venice module %s.", PREFIX, moduleName));
        }
    }

    public List<String> getBlacklistedVeniceFunctions() {
        ArrayList<String> list = new ArrayList<String>(this.blacklistedVeniceFunctions);
        Collections.sort(list);
        return list;
    }

    public List<String> getWhitelistedVeniceModules() {
        ArrayList<String> list = new ArrayList<String>(SandboxRules.DEFAULT_WHITELISTED_MODULES);
        Collections.sort(list);
        return list;
    }
}

