/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Benchmark {
    private final String title;
    private final int warmupIterations;
    private final int iterations;
    private final int microIterations;

    public Benchmark(String title, int iterations) {
        this(title, iterations, iterations, 0);
    }

    public Benchmark(String title, int iterations, int microIterations) {
        this(title, iterations, iterations, microIterations);
    }

    public Benchmark(String title, int warmupIterations, int iterations, int microIterations) {
        this.title = title;
        this.warmupIterations = warmupIterations;
        this.iterations = iterations;
        this.microIterations = microIterations;
    }

    public void benchmark(Function<Integer, Long> task) {
        long elapsed;
        for (int ii = 0; ii < this.warmupIterations; ++ii) {
            task.apply(ii);
        }
        ArrayList<Long> raw = new ArrayList<Long>();
        for (int ii = 0; ii < this.iterations; ++ii) {
            elapsed = task.apply(ii);
            raw.add(elapsed);
        }
        List<Long> measures = this.stripOutliers(raw);
        elapsed = this.sum(measures);
        String sElapsed = this.formatNanos(elapsed);
        String sPerCall = this.formatNanos(elapsed / (long)measures.size() / (long)(this.microIterations > 2 ? this.microIterations : 1));
        System.out.println(String.format("%s Elapsed : %12s", this.title, sElapsed));
        System.out.println(String.format("%s Per call: %12s", this.title, sPerCall));
    }

    private String formatNanos(long nanos) {
        String s = ((VncString)SystemFunctions.format_nano_time.apply(VncList.of(new VncLong(nanos)))).getValue();
        return s.endsWith(" s") ? s + " " : s;
    }

    private long sum(List<Long> measures) {
        return measures.stream().mapToLong(p -> p).sum();
    }

    private List<Long> stripOutliers(List<Long> measures) {
        return measures.stream().sorted().limit(measures.size() - measures.size() / 20).collect(Collectors.toList());
    }
}

