/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LoadPath {
    public static List<String> parseFromString(String path) {
        String loadPath = StringUtil.trimToNull(path);
        return loadPath == null ? new ArrayList<String>() : LoadPath.sanitize(Arrays.asList(loadPath.split(";")));
    }

    public static List<String> sanitize(List<String> paths) {
        if (paths == null) {
            return new ArrayList<String>();
        }
        return paths.stream().map(p -> StringUtil.trimToNull(p)).filter(p -> p != null).map(p -> LoadPath.makeCanocicalPath(p)).collect(Collectors.toList());
    }

    public static VncList toVncList(List<String> paths) {
        return paths == null || paths.isEmpty() ? new VncList() : new VncList(paths.stream().map(p -> new VncString((String)p)).collect(Collectors.toList()));
    }

    private static String makeCanocicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot make a canonical path form \"" + path + "\"");
        }
    }
}

