/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.SpecialForms;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.sandbox.SandboxMaxExecutionTimeChecker;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.CatchBlock;
import com.github.jlangch.venice.impl.util.Doc;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private static final VncSymbol LOADED_MODULES_SYMBOL = new VncSymbol("*loaded-modules*");
    private static final VncSymbol LOADED_FILES_SYMBOL = new VncSymbol("*loaded-files*");
    private final IInterceptor interceptor;
    private final List<String> loadPaths;
    private final SandboxMaxExecutionTimeChecker sandboxMaxExecutionTimeChecker;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();

    public VeniceInterpreter() {
        this(new MeterRegistry(false), new AcceptAllInterceptor(), null);
    }

    public VeniceInterpreter(IInterceptor interceptor, List<String> loadPaths) {
        this(new MeterRegistry(false), interceptor, loadPaths);
    }

    public VeniceInterpreter(MeterRegistry perfmeter, IInterceptor interceptor, List<String> loadPaths) {
        this.sandboxMaxExecutionTimeChecker = new SandboxMaxExecutionTimeChecker();
        this.meterRegistry = perfmeter;
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
    }

    public void initNS() {
        this.nsRegistry.clear();
        this.nsRegistry.add(new Namespace(Namespaces.NS_IO));
        this.nsRegistry.add(new Namespace(Namespaces.NS_STR));
        this.nsRegistry.add(new Namespace(Namespaces.NS_REGEX));
        this.nsRegistry.add(new Namespace(Namespaces.NS_TIME));
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public VncVal READ(String script, String filename) {
        long nanos = System.nanoTime();
        VncVal val = Reader.read_str(script, filename);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal EVAL(VncVal ast, Env env) {
        long nanos = System.nanoTime();
        VncVal val = this.evaluate(ast, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
        }
        return val;
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public VncVal RE(String script, String filename, Env env) {
        VncVal ast = this.READ(script, filename);
        VncVal result = this.EVAL(ast, env);
        return result;
    }

    public Env createEnv(boolean macroexpandOnLoad, VncKeyword runMode) {
        return this.createEnv(null, macroexpandOnLoad, runMode);
    }

    public Env createEnv(List<String> preloadExtensionModules, boolean macroexpandOnLoad, VncKeyword runMode) {
        Env env = new Env(null);
        Functions.functions.entrySet().forEach(e -> {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        });
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString("1.7.15"), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*load-path*"), LoadPath.toVncList(this.loadPaths), false));
        env.setGlobal(new Var(new VncSymbol("*macroexpand-on-load*"), macroexpandOnLoad ? Constants.True : Constants.False, true));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode, false));
        env.setGlobal(new Var(LOADED_MODULES_SYMBOL, new VncMutableSet(ModuleLoader.PRELOADED_MODULES), true));
        env.setGlobal(new Var(LOADED_FILES_SYMBOL, new VncMutableSet(), true));
        this.initNS();
        ArrayList<String> modules = new ArrayList<String>();
        modules.add("core");
        modules.addAll(VeniceInterpreter.toEmpty(preloadExtensionModules));
        modules.forEach(m -> {
            long nanos = System.nanoTime();
            this.RE("(eval " + ModuleLoader.loadModule(m) + ")", (String)m, env);
            this.meterRegistry.record("venice.module." + m + ".load", System.nanoTime() - nanos);
            env.setGlobal(new Var(LOADED_MODULES_SYMBOL, ((VncMutableSet)env.getGlobalOrNull(LOADED_MODULES_SYMBOL)).add(new VncKeyword((String)m))));
        });
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(ModuleLoader.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal evaluate(VncVal orig_ast, Env env) {
        VncVal a0;
        VncList ast;
        RecursionPoint recursionPoint = null;
        block155: while (true) {
            String a0sym;
            if (!Types.isVncList(orig_ast)) {
                return this.eval_ast(orig_ast, (Env)env);
            }
            VncVal expanded = this.macroexpand(orig_ast, (Env)env);
            if (!Types.isVncList(expanded)) {
                return this.eval_ast(expanded, (Env)env);
            }
            ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            switch (a0sym = Types.isVncSymbol(a0) ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                case "do": {
                    if (ast.size() < 2) {
                        orig_ast = Constants.Nil;
                        continue block155;
                    }
                    VncList head_exprs = ast.slice(1, ast.size() - 1);
                    this.eval_ast(head_exprs, (Env)env);
                    orig_ast = ast.last();
                    continue block155;
                }
                case "def": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), (Env)env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, (Env)env).withMeta(((VncVal)name).getMeta());
                    ((Env)env).setGlobal(new Var((VncSymbol)name, res2, true));
                    return name;
                }
                case "defonce": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), (Env)env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, (Env)env).withMeta(((VncVal)name).getMeta());
                    ((Env)env).setGlobal(new Var((VncSymbol)name, res2, false));
                    return name;
                }
                case "def-dynamic": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), (Env)env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, (Env)env).withMeta(((VncVal)name).getMeta());
                    ((Env)env).setGlobal(new DynamicVar((VncSymbol)name, res2));
                    return name;
                }
                case "defmacro": {
                    VncVal res2;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("defmacro", ast));
                    Serializable val = null;
                    try {
                        res2 = this.defmacro_(ast, (Env)env);
                        return res2;
                    }
                    catch (Throwable res2) {
                        val = res2;
                        throw res2;
                    }
                    finally {
                        if (cs3 != null) {
                            if (val != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)val).addSuppressed(throwable);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "set!": {
                    Serializable val;
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), (Env)env));
                    Var globVar = ((Env)env).getGlobalVarOrNull((VncSymbol)name);
                    if (globVar != null) {
                        VncVal expr = ast.third();
                        val = this.evaluate(expr, (Env)env).withMeta(((VncVal)name).getMeta());
                        if (globVar instanceof DynamicVar) {
                            ((Env)env).popGlobalDynamic(globVar.getName());
                            ((Env)env).pushGlobalDynamic(globVar.getName(), (VncVal)val);
                        } else {
                            ((Env)env).setGlobal(new Var(globVar.getName(), (VncVal)val));
                        }
                        return val;
                    }
                    Object cs = new WithCallStack(CallFrame.fromVal((VncVal)name));
                    val = null;
                    try {
                        try {
                            throw new VncException(String.format("The global var or thread-local '%s' does not exist!", ((VncSymbol)name).getName()));
                        }
                        catch (Throwable throwable) {
                            val = throwable;
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable throwable2) {
                                    ((Throwable)val).addSuppressed(throwable2);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                        throw throwable;
                    }
                }
                case "defmulti": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), (Env)env));
                    VncVal dispatchFn = Types.isVncKeyword(ast.third()) ? (VncKeyword)ast.third() : (Types.isVncSymbol(ast.third()) ? Coerce.toVncFunction(((Env)env).get((VncSymbol)ast.third())) : this.fn_(Coerce.toVncList(ast.third()), (Env)env));
                    VncVal multiFn2 = new VncMultiFunction(((VncSymbol)name).getName(), (IVncFunction)((Object)dispatchFn));
                    ((Env)env).setGlobal(new Var((VncSymbol)name, multiFn2, false));
                    return multiFn2;
                }
                case "defmethod": {
                    Object cs;
                    Serializable val;
                    VncSymbol multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(ast.second()));
                    VncVal multiFnVal = ((Env)env).getGlobalOrNull(multiFnName);
                    if (multiFnVal == null) {
                        cs = new WithCallStack(CallFrame.fromVal(ast));
                        val = null;
                        try {
                            try {
                                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
                            }
                            catch (Throwable throwable) {
                                val = throwable;
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (cs != null) {
                                if (val != null) {
                                    try {
                                        ((WithCallStack)cs).close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)val).addSuppressed(throwable3);
                                    }
                                } else {
                                    ((WithCallStack)cs).close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    VncVal multiFn2 = Coerce.toVncMultiFunction(multiFnVal);
                    Serializable dispatchVal = ast.third();
                    VncVector params = Coerce.toVncVector(ast.fourth());
                    if (params.size() != ((VncMultiFunction)multiFn2).getParams().size()) {
                        WithCallStack cs2 = new WithCallStack(CallFrame.fromVal(ast));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), ((VncMultiFunction)multiFn2).getParams().size()));
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (cs2 != null) {
                                if (throwable != null) {
                                    try {
                                        cs2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    cs2.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    VncVector preConditions = this.getFnPreconditions(ast.nth(4));
                    VncList body = ast.slice(preConditions == null ? 4 : 5);
                    VncFunction fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, (Env)env);
                    return ((VncMultiFunction)multiFn2).addFn((VncVal)dispatchVal, fn);
                }
                case "ns": {
                    VncSymbol ns = Coerce.toVncSymbol(ast.second());
                    Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns));
                    return ns;
                }
                case "ns-remove": {
                    VncSymbol ns = Namespaces.lookupNS(ast.second(), (Env)env);
                    if (Namespaces.isCoreNS(ns)) {
                        throw new VncException("Cannot remove namespace core");
                    }
                    ((Env)env).removeGlobalSymbolsByNS(ns);
                    this.nsRegistry.remove(ns);
                    return Constants.Nil;
                }
                case "ns-unmap": {
                    VncSymbol ns = Namespaces.lookupNS(ast.second(), (Env)env);
                    if (Namespaces.isCoreNS(ns)) {
                        throw new VncException("Cannot remove a core symbol");
                    }
                    Serializable sym = Namespaces.qualifySymbol(ns, Coerce.toVncSymbol(ast.third()));
                    ((Env)env).removeGlobalSymbol((VncSymbol)sym);
                    return Constants.Nil;
                }
                case "import": {
                    VncVal multiFn2;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("import", ast));
                    Serializable sym = null;
                    try {
                        ast.rest().forEach(i -> Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue()));
                        multiFn2 = Constants.Nil;
                        return multiFn2;
                    }
                    catch (Throwable multiFn2) {
                        sym = multiFn2;
                        throw multiFn2;
                    }
                    finally {
                        if (cs3 != null) {
                            if (sym != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)sym).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "imports": {
                    if (ast.size() == 1) {
                        return Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                    }
                    VncSymbol ns = Coerce.toVncSymbol(ast.second());
                    Object namespace = this.nsRegistry.get(ns);
                    if (namespace != null) {
                        return ((Namespace)namespace).getJavaImportsAsVncList();
                    }
                    Object cs = new WithCallStack(CallFrame.fromVal("imports", ast));
                    Serializable dispatchVal = null;
                    try {
                        try {
                            throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
                        }
                        catch (Throwable params) {
                            dispatchVal = params;
                            throw params;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cs != null) {
                            if (dispatchVal != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable throwable7) {
                                    ((Throwable)dispatchVal).addSuppressed(throwable7);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                        throw throwable;
                    }
                }
                case "resolve": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), (Env)env));
                    return ((Env)env).getOrNil(sym);
                }
                case "var-get": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), (Env)env));
                    return ((Env)env).getOrNil(sym);
                }
                case "inspect": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), (Env)env));
                    return Inspector.inspect(((Env)env).get(sym));
                }
                case "macroexpand": {
                    Object cs;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("macroexpand", ast));
                    Object namespace = null;
                    try {
                        cs = this.macroexpand(this.evaluate(ast.second(), (Env)env), (Env)env);
                        return cs;
                    }
                    catch (Throwable cs4) {
                        namespace = cs4;
                        throw cs4;
                    }
                    finally {
                        if (cs3 != null) {
                            if (namespace != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)namespace).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "quote": {
                    return ast.second();
                }
                case "quasiquote": {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    continue block155;
                }
                case "doc": {
                    Object name = ((VncString)CoreFunctions.name.apply(ast.rest())).getValue();
                    VncVal docVal = SpecialForms.ns.get(new VncSymbol((String)name));
                    if (docVal == null) {
                        docVal = ((Env)env).get(new VncSymbol((String)name));
                    }
                    orig_ast = VncList.of(new VncSymbol("println"), Doc.getDoc(docVal));
                    continue block155;
                }
                case "eval": {
                    Serializable dispatchVal;
                    Namespace ns = Namespaces.getCurrentNamespace();
                    try {
                        dispatchVal = this.evaluate(Coerce.toVncSequence(this.eval_ast(ast.rest(), (Env)env)).last(), (Env)env);
                        return dispatchVal;
                    }
                    finally {
                        Namespaces.setCurrentNamespace(ns);
                    }
                }
                case "let": {
                    env = new Env((Env)env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    VncVal expressions = ast.slice(2);
                    for (int i2 = 0; i2 < bindings.size(); i2 += 2) {
                        VncVal sym = bindings.nth(i2);
                        VncVal val = this.evaluate(bindings.nth(i2 + 1), (Env)env);
                        ((Env)env).addLocalBindings(Destructuring.destructure(sym, val));
                    }
                    if (((VncList)expressions).isEmpty()) {
                        orig_ast = Constants.Nil;
                        continue block155;
                    }
                    this.eval_ast(((VncList)expressions).slice(0, ((VncList)expressions).size() - 1), (Env)env);
                    orig_ast = ((VncList)expressions).last();
                    continue block155;
                }
                case "binding": {
                    return this.binding_(ast, new Env((Env)env));
                }
                case "bound?": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), (Env)env));
                    return ((Env)env).isBound(sym) ? Constants.True : Constants.False;
                }
                case "global-vars-count": {
                    return new VncLong(((Env)env).globalsCount());
                }
                case "loop": {
                    env = new Env((Env)env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    VncVal expressions = ast.nth(2);
                    ArrayList<VncSymbol> bindingNames = new ArrayList<VncSymbol>();
                    for (int i3 = 0; i3 < bindings.size(); i3 += 2) {
                        VncVal sym = bindings.nth(i3);
                        VncVal val = this.evaluate(bindings.nth(i3 + 1), (Env)env);
                        ((Env)env).setLocal((VncSymbol)sym, val);
                        bindingNames.add((VncSymbol)sym);
                    }
                    recursionPoint = new RecursionPoint(bindingNames, expressions, (Env)env);
                    orig_ast = expressions;
                    continue block155;
                }
                case "recur": {
                    List<VncSymbol> bindingNames = recursionPoint.getLoopBindingNames();
                    Serializable recur_env = recursionPoint.getLoopEnv();
                    if (ast.size() == 2) {
                        ((Env)recur_env).setLocal(bindingNames.get(0), this.evaluate(ast.second(), (Env)env));
                    } else if (ast.size() == 3) {
                        VncVal v1 = this.evaluate(ast.second(), (Env)env);
                        VncVal v2 = this.evaluate(ast.third(), (Env)env);
                        ((Env)recur_env).setLocal(bindingNames.get(0), v1);
                        ((Env)recur_env).setLocal(bindingNames.get(1), v2);
                    } else {
                        VncList values = ast.rest();
                        VncVal[] newValues = new VncVal[values.size()];
                        int kk = 0;
                        for (VncVal v : values.getList()) {
                            newValues[kk++] = this.evaluate(v, (Env)env);
                        }
                        for (int ii = 0; ii < bindingNames.size(); ++ii) {
                            ((Env)recur_env).setLocal(bindingNames.get(ii), newValues[ii]);
                        }
                    }
                    orig_ast = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    continue block155;
                }
                case "try": {
                    Object cs = new WithCallStack(CallFrame.fromVal("try", ast));
                    Serializable recur_env = null;
                    try {
                        VncVal values = this.try_(ast, new Env((Env)env));
                        return values;
                    }
                    catch (Throwable values) {
                        recur_env = values;
                        throw values;
                    }
                    finally {
                        if (cs != null) {
                            if (recur_env != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable newValues) {
                                    ((Throwable)recur_env).addSuppressed(newValues);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                    }
                }
                case "try-with": {
                    Object cs = new WithCallStack(CallFrame.fromVal("try-with", ast));
                    Serializable recur_env = null;
                    try {
                        VncVal values = this.try_with_(ast, new Env((Env)env));
                        return values;
                    }
                    catch (Throwable values) {
                        recur_env = values;
                        throw values;
                    }
                    finally {
                        if (cs != null) {
                            if (recur_env != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable newValues) {
                                    ((Throwable)recur_env).addSuppressed(newValues);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                    }
                }
                case "dorun": {
                    return this.dorun_(ast, (Env)env);
                }
                case "dobench": {
                    return this.dobench_(ast, (Env)env);
                }
                case "if": {
                    VncVal cond = this.evaluate(ast.second(), (Env)env);
                    if (cond == Constants.False || cond == Constants.Nil) {
                        if (ast.size() > 3) {
                            orig_ast = ast.nth(3);
                            continue block155;
                        }
                        return Constants.Nil;
                    }
                    orig_ast = ast.nth(2);
                    continue block155;
                }
                case "fn": {
                    return this.fn_(ast, (Env)env);
                }
                case "prof": {
                    return this.prof_(ast, (Env)env);
                }
                case "locking": {
                    return this.locking_(ast, (Env)env);
                }
            }
            break;
        }
        VncList el = (VncList)this.eval_ast(ast, (Env)env);
        VncVal elFirst = el.first();
        VncList elArgs = el.rest();
        if (Types.isVncFunction(elFirst)) {
            VncFunction fn = (VncFunction)elFirst;
            String fnName = fn.getQualifiedName();
            long nanos = System.nanoTime();
            this.interceptor.validateVeniceFunction(fnName);
            this.checkInterrupted("interrupted while about processing function " + fnName);
            this.sandboxMaxExecutionTimeChecker.check();
            CallStack callStack = ThreadLocalMap.getCallStack();
            CallFrame callFrame = CallFrame.fromFunction(fn, a0);
            try {
                callStack.push(callFrame);
                VncVal vncVal = fn.apply(elArgs);
                return vncVal;
            }
            finally {
                callStack.pop();
                this.checkInterrupted("interrupted after processing function " + fnName);
                this.sandboxMaxExecutionTimeChecker.check();
                if (this.meterRegistry.enabled) {
                    this.meterRegistry.record(fn.getQualifiedName(), System.nanoTime() - nanos);
                }
            }
        }
        if (Types.isIVncFunction(elFirst)) {
            return ((IVncFunction)((Object)elFirst)).apply(elArgs);
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(ast));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Not a function or keyword/map used as function: '%s'", this.PRINT(elFirst)));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
        catch (Throwable throwable9) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable9;
        }
    }

    private VncVal eval_ast(VncVal ast, Env env) {
        if (Types.isVncSymbol(ast)) {
            return env.get((VncSymbol)ast);
        }
        if (Types.isVncSequence(ast)) {
            VncSequence seq = (VncSequence)ast;
            switch (seq.size()) {
                case 0: {
                    return seq;
                }
                case 1: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env));
                }
                case 2: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
                }
            }
            ArrayList<VncVal> vals = new ArrayList<VncVal>();
            for (VncVal v : seq.getList()) {
                vals.add(this.evaluate(v, env));
            }
            return seq.withValues(vals);
        }
        if (Types.isVncMap(ast)) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>();
            for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
            }
            return map.withValues(vals);
        }
        return ast;
    }

    private VncVal macroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = System.nanoTime();
        VncVal ast_ = ast;
        boolean expanded = false;
        while (Types.isVncList(ast_) && Types.isVncSymbol(a0 = ((VncList)ast_).first()) && Types.isVncMacro(fn = env.getGlobalOrNull((VncSymbol)a0))) {
            VncFunction macro = (VncFunction)fn;
            this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            expanded = true;
            ast_ = macro.apply(((VncList)ast_).rest());
        }
        if (expanded && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private static boolean is_pair(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return VncList.of(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncSequence(ast).first();
        if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
            return ((VncSequence)ast).second();
        }
        if (VeniceInterpreter.is_pair(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        int argPos = 1;
        VncSymbol macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.nth(argPos++), env));
        VncVal meta = macroName.getMeta();
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String name = macroName.getName();
        String ns = Namespaces.getNamespace(macroName.getName());
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, Constants.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            int n = ++argPos;
            ++argPos;
            VncVal body = ast.nth(n);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, VncList.of(body), null, env);
            macroFn.setMacro();
            macroFn.setNamespace(ns);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, env));
        });
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns).withMeta(meta);
        macroFn.setMacro();
        macroFn.setNamespace(ns);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dorun", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dorun requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        long count = Coerce.toVncLong(ast.second()).getValue();
        if (count <= 0L) {
            return Constants.Nil;
        }
        VncVal expr = ast.third();
        try {
            VncVal first = this.evaluate(expr, env);
            int ii = 1;
            while ((long)ii < count) {
                VncVal result = this.evaluate(expr, env);
                this.checkInterrupted("interrupted while in (dorun ...)");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncVal vncVal = first;
            return vncVal;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dobench", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dobench requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        try {
            long count = Coerce.toVncLong(ast.second()).getValue();
            VncVal expr = ast.third();
            ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
            int ii = 0;
            while ((long)ii < count) {
                long start = System.nanoTime();
                VncVal result = this.evaluate(expr, env);
                long end = System.nanoTime();
                elapsed.add(new VncLong(end - start));
                this.checkInterrupted("interrupted while in (dobench ...)");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncList vncList = new VncList(elapsed);
            return vncList;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(VncList ast, Env env) {
        VncVal mutex;
        if (ast.size() < 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("locking", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("locking requires a lockee and one or more expressions to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        VncVal vncVal = mutex = this.evaluate(ast.second(), env);
        synchronized (vncVal) {
            return this.evaluateBody(ast.slice(2), env);
        }
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSymbol name;
        int argPos;
        if (Types.isVncSymbol(ast.second())) {
            argPos = 2;
            name = (VncSymbol)ast.second();
        } else {
            argPos = 1;
            name = new VncSymbol(VncFunction.createAnonymousFuncName());
        }
        VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
        ReservedSymbols.validateNotReservedSymbol(fnName);
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        if (Types.isVncVector(paramsOrSig)) {
            VncVector preConditions;
            VncVector params = (VncVector)paramsOrSig;
            if ((preConditions = this.getFnPreconditions(ast.nth(++argPos))) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(fnName.getName(), params, body, preConditions, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preConditions = this.getFnPreconditions(sig.nth(pos));
            if (preConditions != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(fnName.getName(), params, body, preConditions, env));
        });
        return new VncMultiArityFunction(fnName.getName(), fns);
    }

    private VncVal prof_(VncList ast, Env env) {
        if (Types.isVncKeyword(ast.second())) {
            VncKeyword cmd = (VncKeyword)ast.second();
            switch (cmd.getValue()) {
                case "on": 
                case "enable": {
                    this.meterRegistry.enable();
                    return new VncKeyword("on");
                }
                case "off": 
                case "disable": {
                    this.meterRegistry.disable();
                    return new VncKeyword("off");
                }
                case "status": {
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear": {
                    this.meterRegistry.reset();
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear-all-but": {
                    this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "data": {
                    return this.meterRegistry.getVncTimerData();
                }
                case "data-formatted": {
                    String title = ast.size() == 3 ? Coerce.toVncString(ast.third()).getValue() : "Metrics";
                    return new VncString(this.meterRegistry.getTimerDataFormatted(title));
                }
            }
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal("prof", ast));
        Object object = null;
        try {
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (cs != null) {
                if (object != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            for (Binding b : Destructuring.destructure(sym, val)) {
                vars.add(new Var(b.sym, b.val));
            }
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            if (expressions.isEmpty()) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            this.eval_ast(expressions.slice(0, expressions.size() - 1), env);
            VncVal vncVal = ((VncList)this.eval_ast(VncList.of(expressions.last()), env)).first();
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.evaluateBody(this.getTryBody(ast), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
            if (catchBlock == null) {
                throw th;
            }
            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), env);
            return vncVal;
        }
        finally {
            VncList finallyBlock = this.findFirstFinallyBlock(ast);
            if (finallyBlock != null) {
                this.eval_ast(finallyBlock.rest(), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block12: {
            VncSequence bindings = Coerce.toVncSequence(ast.second());
            ArrayList<Binding> boundResources = new ArrayList<Binding>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                env.setLocal((VncSymbol)sym, val);
                boundResources.add(new Binding((VncSymbol)sym, val));
            }
            result = Constants.Nil;
            try {
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block12;
                    this.eval_ast(finallyBlock.rest(), env);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block13: {
                        try {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env);
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock == null) break block13;
                            this.eval_ast(finallyBlock.rest(), env);
                        }
                        catch (Throwable throwable) {
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock != null) {
                                this.eval_ast(finallyBlock.rest(), env);
                            }
                            throw throwable;
                        }
                    }
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        VncVal resource = b.val;
                        if (Types.isVncJavaObject(resource)) {
                            Object r = ((VncJavaObject)resource).getDelegate();
                            if (r instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                            if (r instanceof Closeable) {
                                try {
                                    ((Closeable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                        }
                    });
                    return vncVal;
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.val;
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = ast.rest().getList().iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return new VncList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        return new VncFunction(name, params){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(env);
                Namespace curr_ns = Namespaces.getCurrentNamespace();
                try {
                    if (!name.equals("macroexpand-all")) {
                        Namespaces.setCurrentNamespace(ns);
                    }
                    localEnv.addLocalBindings(Destructuring.destructure(params, args));
                    VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                    VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv);
                    return vncVal;
                }
                finally {
                    Namespaces.setCurrentNamespace(curr_ns);
                }
            }

            @Override
            public VncVal getBody() {
                return body;
            }
        };
    }

    private VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? ((VncSequence)result).first() == Constants.True : result == Constants.True;
    }

    private void validateFnPreconditions(String fnName, VncVector preConditions, Env env) {
        if (preConditions != null && !preConditions.isEmpty()) {
            Env local = new Env(env);
            for (VncVal v : preConditions.getList()) {
                if (this.isFnConditionTrue(this.evaluate(v, local))) continue;
                WithCallStack cs = new WithCallStack(CallFrame.fromVal(fnName, v));
                Throwable throwable = null;
                try {
                    try {
                        throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncList.of(v))).getValue()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private VncVal evaluateBody(VncList body, Env env) {
        if (body.isEmpty()) {
            return Constants.Nil;
        }
        if (body.size() == 1) {
            return this.evaluate(body.first(), env);
        }
        if (body.size() == 2) {
            this.evaluate(body.first(), env);
            return this.evaluate(body.last(), env);
        }
        this.eval_ast(body.slice(0, body.size() - 1), env);
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String message) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(message);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (Namespaces.isQualified(sym)) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), Namespaces.getNamespace(sym.getName())));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        return new VncSymbol(Namespaces.isCoreNS(ns) ? sym.getName() : ns.getName() + "/" + sym.getName(), MetaUtil.setNamespace(sym.getMeta(), ns.getName()));
    }
}

