/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.repl.ReplCompleter;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplParser;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.Licenses;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.repackage.org.jline.reader.EndOfFileException;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;

public class REPL {
    private static final String HELP = "Venice REPL: V" + Venice.getVersion() + "\n\nCommands: \n  !reload      reload Venice environment\n  !?, !help    help\n  !config      show a sample REPL config\n  !lic         prints the licenses for 3rd party\n               libs included with Venice\n  !macroexpand enable macro expansion while loading\n               files and modules. \n               This can speed-up script execution by\n               a factor 3 or 5 and even more with\n               complex code!\n  !env         print env symbols:\n                 !env print {symbol-name}\n                 !env global\n                 !env global io/*\n                 !env global *file*\n                 !env local {level}\n                 !env levels\n  !sandbox     sandbox\n                 !sandbox status\n                 !sandbox config\n                 !sandbox accept-all\n                 !sandbox reject-all\n                 !sandbox customized\n                 !sandbox add-rule rule\n  !java-ex     print Java exception\n  !exit        quit the REPL\n\nHistory: \n  A history of the last three result values is kept by\n  the REPL, accessible through the symbols `*1`, `*2`, `*3`,\n  and `**`. E.g. (printl *1)\n\nShortcuts:\n  ctrl-A   move the cursor to the start\n  ctrl-C   stop the running command, cancel a multi-line\n           edit, or break out of the REPL\n  ctrl-E   move the cursor to the end\n  ctrl-K   remove the text after the cursor and store it\n           in a cut-buffer\n  ctrl-L   clear the screen\n  ctrl-Y   yank the text from the cut-buffer\n  ctrl-_   undo\n";
    private static final String HELP_ENV = "Please choose from:\n   !env print {symbol-name}\n   !env global\n   !env global io/*\n   !env global *file*\n   !env local {level}\n   !env levels\n";
    private static final String HELP_SANDBOX = "Please choose from:\n   !sandbox status\n   !sandbox config\n   !sandbox accept-all\n   !sandbox reject-all\n   !sandbox customized\n   !sandbox add-rule class:java.lang.Math:*\n   !sandbox add-rule system.property:os.name\n   !sandbox add-rule blacklist:venice:func:io/exists-dir?\n   !sandbox add-rule blacklist:venice:func:*io*\n   !sandbox add-rule venice:module:shell\n";
    private static final String DELIM = StringUtil.repeat('-', 80);
    private final List<String> loadPaths;
    private ReplConfig config;
    private IInterceptor interceptor;
    private VeniceInterpreter venice;
    private TerminalPrinter printer;
    private boolean macroexpand = false;

    public REPL(IInterceptor interceptor, List<String> loadPaths) {
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
    }

    public void run(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        try {
            System.out.println("Venice REPL: V" + Venice.getVersion());
            this.config = ReplConfig.load(cli);
            System.out.println("Type '!' for help.");
            this.repl(cli);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void repl(CommandLineArgs cli) throws Exception {
        VncVal result;
        String prompt = this.config.getPrompt();
        String secondaryPrompt = this.config.getSecondaryPrompt();
        String resultPrefix = this.config.getResultPrefix();
        TerminalBuilder builder = TerminalBuilder.builder();
        final Thread mainThread = Thread.currentThread();
        Terminal terminal = builder.encoding("UTF-8").type("xterm-256color").system(true).nativeSignals(true).signalHandler(new Terminal.SignalHandler(){

            @Override
            public void handle(Terminal.Signal signal) {
                if (signal == Terminal.Signal.INT) {
                    mainThread.interrupt();
                }
            }
        }).build();
        PrintStream ps = this.config.useColors() ? new ReplPrintStream(Charset.defaultCharset().name(), System.out, terminal, this.config.getColor("colors.stdout")) : System.out;
        this.printer = new TerminalPrinter(this.config, terminal, false);
        this.venice = new VeniceInterpreter(this.interceptor, this.loadPaths);
        Env env = this.loadEnv(cli, ps);
        ReplParser parser = new ReplParser(this.venice);
        ReplCompleter completer = new ReplCompleter(this.venice, env, this.loadPaths);
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Venice").terminal(terminal).history(history).completer(completer).parser(parser).variable("secondary-prompt-pattern", secondaryPrompt).build();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        try {
            String loadFile = this.config.getLoadFile();
            if (loadFile != null) {
                this.printer.println("stdout", "loading file \"" + loadFile + "\"");
                result = this.venice.RE("(load-file \"" + loadFile + "\")", "user", env);
                this.printer.println("stdout", resultPrefix + this.venice.PRINT(result));
            }
        }
        catch (Exception ex) {
            this.printer.printex("error", ex);
        }
        while (true) {
            String line;
            resultHistory.mergeToEnv(env);
            try {
                Thread.interrupted();
                line = reader.readLine(prompt, null, (MaskingCallback)null, null);
                if (line == null) continue;
                if (line.startsWith("!")) {
                    String[] params;
                    String cmd = StringUtil.trimToEmpty(line.substring(1));
                    if (cmd.equals("reload")) {
                        env = this.loadEnv(cli, ps);
                        this.printer.println("system", "reloaded");
                        continue;
                    }
                    if (cmd.equals("macroexpand")) {
                        this.macroexpand = true;
                        this.setMacroexpandOnLoad(env, true);
                        this.printer.println("system", "macroexpansion enabled");
                        continue;
                    }
                    if (cmd.isEmpty() || cmd.equals("?") || cmd.equals("help")) {
                        this.printer.println("stdout", HELP);
                        continue;
                    }
                    if (cmd.equals("config")) {
                        this.handleConfigCommand();
                        continue;
                    }
                    if (cmd.equals("env")) {
                        this.handleEnvCommand(new String[0], env);
                        continue;
                    }
                    if (cmd.startsWith("env ")) {
                        params = StringUtil.trimToEmpty(cmd.substring(3)).split(" +");
                        this.handleEnvCommand(params, env);
                        continue;
                    }
                    if (cmd.startsWith("java-ex")) {
                        this.printer.setPrintJavaEx(true);
                        this.printer.println("stdout", "Printing Java exceptions");
                        continue;
                    }
                    if (cmd.equals("sandbox")) {
                        this.handleSandboxCommand(new String[0], terminal, env);
                        continue;
                    }
                    if (cmd.startsWith("sandbox ")) {
                        params = StringUtil.trimToEmpty(cmd.substring(7)).split(" +");
                        this.handleSandboxCommand(params, terminal, env);
                        continue;
                    }
                    if (cmd.equals("lic")) {
                        Licenses.lics().entrySet().forEach(e -> {
                            this.printer.println("stdout", "");
                            this.printer.println("stdout", DELIM);
                            this.printer.println("stdout", (String)e.getKey() + " License");
                            this.printer.println("stdout", DELIM);
                            this.printer.println("stdout", (String)e.getValue());
                        });
                        continue;
                    }
                    if (cmd.equals("colors")) {
                        this.printer.println("default", "default");
                        this.printer.println("result", "result");
                        this.printer.println("stdout", "stdout");
                        this.printer.println("error", "error");
                        this.printer.println("system", "system");
                        this.printer.println("interrupt", "interrupt");
                        continue;
                    }
                    if (cmd.equals("exit")) {
                        this.printer.println("interrupt", " good bye ");
                        Thread.sleep(1000L);
                        break;
                    }
                    this.printer.println("error", "invalid command");
                    continue;
                }
            }
            catch (ContinueException ex) {
                continue;
            }
            catch (UserInterruptException ex) {
                Thread.interrupted();
                if (parser.isEOF()) {
                    this.printer.println("interrupt", " cancel ");
                    parser.reset();
                    continue;
                }
                this.printer.println("interrupt", " ! interrupted ! ");
                Thread.sleep(1000L);
                break;
            }
            catch (EofException | EndOfFileException ex) {
                break;
            }
            catch (ParseError ex) {
                history.add(reader.getBuffer().toString());
                this.printer.printex("error", ex);
                continue;
            }
            catch (Exception ex) {
                this.printer.printex("error", ex);
                continue;
            }
            try {
                ThreadLocalMap.clearCallStack();
                result = this.venice.RE(line, "user", env);
                resultHistory.add(result);
                this.printer.println("result", resultPrefix + this.venice.PRINT(result));
            }
            catch (ContinueException ex) {
            }
            catch (Exception ex) {
                this.printer.printex("error", ex);
            }
            catch (Throwable ex) {
                this.printer.printex("error", ex);
            }
        }
    }

    private void handleConfigCommand() {
        this.printer.println("stdout", "Sample REPL configuration. Save it as 'repl.json'");
        this.printer.println("stdout", "in the REPL's working directory:");
        this.printer.println();
        this.printer.println("stdout", ReplConfig.getRawClasspathConfig());
    }

    private void handleEnvCommand(String[] params, Env env) {
        if (params.length == 0) {
            this.printer.println("stdout", HELP_ENV);
            return;
        }
        if (params[0].equals("levels")) {
            if (params.length == 1) {
                this.printer.println("stdout", "Levels: " + (env.level() + 1));
                return;
            }
        } else if (params[0].equals("print")) {
            if (params.length == 2) {
                VncVal val = env.get(new VncSymbol(params[1]));
                this.printer.println("stdout", this.venice.PRINT(val));
                return;
            }
        } else if (params[0].equals("global")) {
            if (params.length == 1) {
                this.printer.println("stdout", env.globalsToString());
                return;
            }
            if (params.length == 2) {
                String filter = StringUtil.trimToNull(params[1]);
                filter = filter == null ? null : filter.replaceAll("[*]", ".*");
                this.printer.println("stdout", env.globalsToString(filter));
                return;
            }
        } else if (params[0].equals("local") && params.length == 2) {
            int level = Integer.valueOf(params[1]);
            this.printer.println("stdout", env.getLevelEnv(level).localsToString());
            return;
        }
        this.printer.println("error", "invalid env command");
    }

    private void handleSandboxCommand(String[] params, Terminal terminal, Env env) {
        if (params.length == 0) {
            terminal.writer().println(HELP_SANDBOX);
            return;
        }
        String interceptorName = this.interceptor.getClass().getSimpleName();
        if (params.length == 1) {
            if (params[0].equals("status")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "No sandbox active (" + interceptorName + ")");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "Sandbox active (" + interceptorName + "). Rejects all Java calls and default blacklisted Venice functions");
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "Customized sandbox active (" + interceptorName + ")");
                    return;
                }
                this.printer.println("stdout", "Sandbox: " + interceptorName);
                return;
            }
            if (params[0].equals("accept-all")) {
                this.activate(new AcceptAllInterceptor());
                return;
            }
            if (params[0].equals("reject-all")) {
                this.activate(new RejectAllInterceptor());
                return;
            }
            if (params[0].equals("customized")) {
                this.activate(new SandboxInterceptor(new SandboxRules()));
                return;
            }
            if (params[0].equals("config")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "[accept-all] NO sandbox active");
                    this.printer.println("stdout", "All Java calls accepted, no Venice calls rejected");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "[reject-all] SAFE restricted sandbox");
                    this.printer.println("stdout", "Java calls:\n   All rejected!");
                    this.printer.println("stdout", "Whitelisted Venice modules:\n" + ((RejectAllInterceptor)this.interceptor).getWhitelistedVeniceModules().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    this.printer.println("stdout", "Blacklisted Venice functions:\n" + ((RejectAllInterceptor)this.interceptor).getBlacklistedVeniceFunctions().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "[customized] Customized sandbox");
                    this.printer.println("stdout", "Sandbox rules:\n" + ((SandboxInterceptor)this.interceptor).getRules().toString());
                    return;
                }
                this.printer.println("stdout", "[" + interceptorName + "]");
                this.printer.println("stdout", "no info");
                return;
            }
        } else if (params.length == 2 && params[0].equals("add-rule")) {
            String rule = params[1];
            if (!(this.interceptor instanceof SandboxInterceptor)) {
                this.printer.println("system", "rules can only be added to a customized sandbox");
                return;
            }
            SandboxRules rules = ((SandboxInterceptor)this.interceptor).getRules();
            if (rule.startsWith("class:")) {
                rules.withClasses(rule);
            } else if (rule.startsWith("system.property:")) {
                rules.withSystemProperties(rule);
            } else if (rule.startsWith("system.env:")) {
                rules.withSystemEnvs(rule);
            } else if (rule.startsWith("venice:module:")) {
                rules.withVeniceModules(rule);
            } else if (rule.startsWith("blacklist:venice:func:")) {
                rules.rejectVeniceFunctions(rule);
            } else {
                terminal.writer().println(HELP_SANDBOX);
                return;
            }
            this.activate(new SandboxInterceptor(rules));
            return;
        }
        this.printer.println("error", "invalid sandbox command: " + Arrays.asList(params));
    }

    private Env loadEnv(CommandLineArgs cli, PrintStream ps) {
        return this.venice.createEnv(this.macroexpand, new VncKeyword("repl")).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false)).setStdoutPrintStream(ps);
    }

    private void setMacroexpandOnLoad(Env env, boolean macroexpandOnLoad) {
        env.setGlobal(new Var(new VncSymbol("*macroexpand-on-load*"), macroexpandOnLoad ? Constants.True : Constants.False, true));
    }

    private void activate(IInterceptor interceptor) {
        this.interceptor = interceptor;
        this.venice = new VeniceInterpreter(interceptor, this.loadPaths);
        JavaInterop.register(interceptor);
    }
}

