/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class VncSet
extends VncCollection
implements IVncFunction {
    private static final long serialVersionUID = -1848883965231344442L;

    public VncSet(VncVal meta) {
        super(meta);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("set", args, 1, 2);
        VncVal first = args.first();
        if (args.size() == 1) {
            return this.contains(first) ? first : Constants.Nil;
        }
        return this.contains(first) ? first : args.second();
    }

    @Override
    public abstract VncSet empty();

    public abstract VncSet withValues(Collection<? extends VncVal> var1);

    public abstract VncSet withValues(Collection<? extends VncVal> var1, VncVal var2);

    @Override
    public abstract VncSet withMeta(VncVal var1);

    public abstract VncSet add(VncVal var1);

    public abstract VncSet addAll(VncSet var1);

    public abstract VncSet addAll(VncSequence var1);

    public abstract VncSet remove(VncVal var1);

    public abstract VncSet removeAll(VncSet var1);

    public abstract VncSet removeAll(VncSequence var1);

    public abstract boolean contains(VncVal var1);

    public abstract Set<VncVal> getSet();

    public abstract List<VncVal> getList();

    @Override
    public Object convertToJavaObject() {
        return this.getSet().stream().map(v -> v.convertToJavaObject()).collect(Collectors.toSet());
    }
}

