/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncTunnelAsJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.StreamUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaInteropFunctions {
    private static Set<String> skippedFn = new HashSet<String>(Arrays.asList("clone", "equals", "hashCode", "notify", "notifyAll", "getClass", "toString", "wait"));
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(new JavaFn()).add(new ProxifyFn()).add(new DelegateFn()).add(new SupersFn()).add(new BasesFn()).add(new DescribeJavaClassFn()).add(new JavaClassFn()).add(new JavaObjQFn()).add(new JavaEnumToListFn()).add(new JavaIterToListFn()).add(new JavaObjWrapFn()).add(new JavaObjUnwrapFn()).toMap();

    private static VncHashMap mapField(Field f) {
        return new VncHashMap().assoc(new VncKeyword(":name"), new VncKeyword(f.getName())).assoc(new VncKeyword(":type"), new VncKeyword(f.getType().getName())).assoc(new VncKeyword(":static"), ReflectionUtil.isStatic(f) ? Constants.True : Constants.False);
    }

    private static VncHashMap mapMethod(Method m) {
        Parameter[] params = m.getParameters();
        Type[] types = m.getGenericParameterTypes();
        Type ret = m.getGenericReturnType();
        return new VncHashMap().assoc(new VncKeyword(":name"), new VncKeyword(m.getName())).assoc(new VncKeyword(":params"), JavaInteropFunctions.mapParams(params, types)).assoc(new VncKeyword(":return"), new VncKeyword(ret.getTypeName())).assoc(new VncKeyword(":static"), ReflectionUtil.isStatic(m) ? Constants.True : Constants.False);
    }

    private static VncHashMap mapConstructor(Constructor<?> c) {
        Parameter[] params = c.getParameters();
        Type[] types = c.getGenericParameterTypes();
        return new VncHashMap().assoc(new VncKeyword(":default"), params.length == 0 ? Constants.True : Constants.False).assoc(new VncKeyword(":params"), JavaInteropFunctions.mapParams(params, types));
    }

    private static VncHashMap mapParams(Parameter[] params, Type[] types) {
        VncHashMap map = new VncHashMap();
        for (int ii = 0; ii < params.length; ++ii) {
            map = map.assoc(new VncKeyword(params[ii].getName()), new VncKeyword(types[ii].getTypeName()));
        }
        return map;
    }

    private static VncHashMap mapBeanGetter(Method m) {
        String name = ReflectionUtil.getBeanPropertyName(m);
        Type type = m.getGenericReturnType();
        return new VncHashMap().assoc(new VncKeyword(":property"), new VncKeyword(name)).assoc(new VncKeyword(":type"), new VncKeyword(type.getTypeName())).assoc(new VncKeyword(":getter"), Constants.True);
    }

    private static VncHashMap mapBeanSetter(Method m) {
        String name = ReflectionUtil.getBeanPropertyName(m);
        Type type = m.getGenericParameterTypes()[0];
        return new VncHashMap().assoc(new VncKeyword(":property"), new VncKeyword(name)).assoc(new VncKeyword(":type"), new VncKeyword(type.getTypeName())).assoc(new VncKeyword(":setter"), Constants.True);
    }

    public static class JavaObjUnwrapFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjUnwrapFn() {
            super("java-unwrap", VncFunction.meta().arglists("(java-unwrap val)").doc("Unwraps a venice value").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-unwrap", args, 1);
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? ((VncTunnelAsJavaObject)arg).getDelegate() : arg;
        }
    }

    public static class JavaObjWrapFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjWrapFn() {
            super("java-wrap", VncFunction.meta().arglists("(java-wrap val)").doc("Wraps a venice value").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-wrap", args, 1);
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? arg : new VncTunnelAsJavaObject(arg);
        }
    }

    public static class JavaIterToListFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaIterToListFn() {
            super("java-iterator-to-list", VncFunction.meta().arglists("(java-iterator-to-list e)").doc("Converts a Java iterator to a list").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-iterator-to-list", args, 1);
            if (Types.isVncJavaObject(args.first(), Iterator.class)) {
                Iterator i = (Iterator)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(i).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return new VncList(list);
            }
            throw new VncException(String.format("Function 'java-iterator-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    }

    public static class JavaEnumToListFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaEnumToListFn() {
            super("java-enumeration-to-list", VncFunction.meta().arglists("(java-enumeration-to-list e)").doc("Converts a Java enumeration to a list").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-enumeration-to-list", args, 1);
            if (Types.isVncJavaObject(args.first(), Enumeration.class)) {
                Enumeration e = (Enumeration)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(e).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return new VncList(list);
            }
            throw new VncException(String.format("Function 'java-enumeration-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    }

    public static class JavaObjQFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjQFn() {
            super("java-obj?", VncFunction.meta().arglists("(java-obj? obj)").doc("Returns true if obj is a Java object").examples("(java-obj? (. :java.math.BigInteger :new \"0\"))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("java-obj?", args, 1);
            return Types.isVncJavaObject(args.first()) ? Constants.True : Constants.False;
        }
    }

    public static class DescribeJavaClassFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public DescribeJavaClassFn() {
            super("describe-class", VncFunction.meta().arglists("(describe-class class)").doc("Describes a Java class.").examples("(describe :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("describe-class", args, 1);
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            VncHashMap map = new VncHashMap();
            map = map.assoc(new VncKeyword("constructors"), new VncList(ReflectionUtil.getPublicConstructors(clazz).stream().map(c -> JavaInteropFunctions.mapConstructor(c)).collect(Collectors.toList())));
            map = map.assoc(new VncKeyword("methods"), VncTinyList.empty().addAllAtEnd(new VncList(ReflectionUtil.getAllPublicInstanceMethods(clazz, true).stream().filter(m -> !skippedFn.contains(m.getName())).map(m -> JavaInteropFunctions.mapMethod(m)).collect(Collectors.toList()))).addAllAtEnd(new VncList(ReflectionUtil.getAllPublicStaticMethods(clazz, true).stream().filter(m -> !skippedFn.contains(m.getName())).map(m -> JavaInteropFunctions.mapMethod(m)).collect(Collectors.toList()))));
            map = map.assoc(new VncKeyword("fields"), VncTinyList.empty().addAllAtEnd(new VncList(ReflectionUtil.getPublicInstanceFields(clazz).stream().map(m -> JavaInteropFunctions.mapField(m)).collect(Collectors.toList()))).addAllAtEnd(new VncList(ReflectionUtil.getPublicStaticFields(clazz).stream().map(m -> JavaInteropFunctions.mapField(m)).collect(Collectors.toList()))));
            map = map.assoc(new VncKeyword("bean"), VncTinyList.empty().addAllAtEnd(new VncList(ReflectionUtil.getBeanGetterMethods(clazz).stream().map(m -> JavaInteropFunctions.mapBeanGetter(m)).collect(Collectors.toList()))).addAllAtEnd(new VncList(ReflectionUtil.getBeanSetterMethods(clazz).stream().map(m -> JavaInteropFunctions.mapBeanSetter(m)).collect(Collectors.toList()))));
            return map;
        }
    }

    public static class BasesFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public BasesFn() {
            super("bases", VncFunction.meta().arglists("(bases class)").doc("Returns the immediate superclass and interfaces of class, if any.").examples("(bases :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("bases", args, 1);
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            ArrayList classes = new ArrayList();
            Class<?> superclass = ReflectionUtil.getSuperclass(clazz);
            if (superclass != null) {
                classes.add(superclass);
            }
            classes.addAll(ReflectionUtil.getAllDirectInterfaces(clazz));
            return new VncList(JavaInteropUtil.toVncKeywords(ReflectionUtil.distinct(classes)));
        }
    }

    public static class SupersFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public SupersFn() {
            super("supers", VncFunction.meta().arglists("(supers class)").doc("Returns the immediate and indirect superclasses and interfaces of class, if any.").examples("(supers :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("supers", args, 1);
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            ArrayList classes = new ArrayList();
            List<Class<?>> superclasses = ReflectionUtil.getAllSuperclasses(clazz);
            List<Class<?>> interfaces = ReflectionUtil.getAllInterfaces(superclasses);
            classes.addAll(superclasses);
            classes.addAll(interfaces);
            return new VncList(JavaInteropUtil.toVncKeywords(ReflectionUtil.distinct(classes)));
        }
    }

    public static class JavaClassFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassFn() {
            super("class", VncFunction.meta().arglists("(class name)").doc("Returns the Java class for the given name.").examples("(class :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("class", args, 1);
            return new VncJavaObject(JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports()));
        }
    }

    public static class DelegateFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public DelegateFn() {
            super("delegate", VncFunction.meta().arglists("(delegate classname object)").doc("Wraps the delegate object with an instance of type classname").build());
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() != 2) {
                throw new ArityException(2, "delegate");
            }
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            Object delegate = Coerce.toVncJavaObject(args.second()).getDelegate();
            return VncJavaObject.from(ReflectionAccessor.invokeConstructor(clazz, new Object[]{delegate}));
        }
    }

    public static class ProxifyFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public ProxifyFn() {
            super("proxify", VncFunction.meta().arglists("(proxify classname method-map)").doc("Proxifies a Java interface to be passed as a Callback object to Java functions. The interface's methods are implemented by Venice functions.").examples("(do \n   (import :java.io.File :java.io.FilenameFilter) \n\n   (def file-filter \n        (fn [dir name] (str/ends-with? name \".xxx\"))) \n\n   (let [dir (io/tmp-dir )] \n        ;; create a dynamic proxy for the interface FilenameFilter\n        ;; and implement its function 'accept' by 'file-filter'\n        (. dir :list (proxify :FilenameFilter {:accept file-filter}))) \n)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            if (args.size() != 2) {
                throw new ArityException(2, "proxify");
            }
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            return new VncJavaObject(DynamicInvocationHandler.proxify(CallFrame.fromVal("proxify(:" + clazz.getName() + ")", args), clazz, Coerce.toVncMap(args.second())));
        }
    }

    public static class JavaFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaFn() {
            super(".", VncFunction.meta().arglists("(. classname :new args)", "(. classname method-name args)", "(. classname field-name)", "(. classname :class)", "(. object method-name args)", "(. object field-name)", "(. object :class)").doc("Java interop. Calls a constructor or an class/object method or accesses a class/instance field. The function is sandboxed.").examples(";; invoke constructor \n(. :java.lang.Long :new 10)", ";; invoke static method \n(. :java.time.ZonedDateTime :now)", ";; invoke static method \n(. :java.lang.Math :min 10 20)", ";; access static field \n(. :java.lang.Math :PI)", ";; invoke method \n(. (. :java.lang.Long :new 10) :toString)", ";; get class name \n(. :java.lang.Math :class)", ";; get class name \n(. (. :java.io.File :new \"/temp\") :class)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            return JavaInteropUtil.applyJavaAccess(args, Namespaces.getCurrentNamespace().getJavaImports());
        }
    }

    private static abstract class AbstractJavaFn
    extends VncFunction {
        private static final long serialVersionUID = -1848883965231344442L;

        public AbstractJavaFn(String name, VncVal meta) {
            super(name, meta);
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    }
}

