/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class VncFunction
extends VncVal
implements IVncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncVector params;
    private volatile boolean macro = false;
    private final String simpleName;
    private final String qualifiedName;
    private final int fixedArgsCount;
    private final boolean variadicArgs;
    private final AtomicReference<VncVal> fnMeta = new AtomicReference<VncConstant>(Constants.Nil);
    private volatile boolean _private;
    private volatile String ns;

    public VncFunction(String name) {
        this(name, null, null);
    }

    public VncFunction(String name, VncVal meta) {
        this(name, null, meta);
    }

    public VncFunction(String name, VncVector params) {
        this(name, params, Constants.Nil);
    }

    public VncFunction(String name, VncVector params, VncVal meta) {
        super(Constants.Nil);
        String ns = VncFunction.getNamespace(name);
        this.simpleName = VncFunction.getSimpleName(name);
        this.params = params;
        this.qualifiedName = "core".equals(ns) ? this.simpleName : ns + "/" + this.simpleName;
        this.fnMeta.set(MetaUtil.setNamespace(meta, ns));
        this._private = MetaUtil.isPrivate(meta);
        this.ns = ns;
        this.fixedArgsCount = params == null ? 0 : VncFunction.countFixedArgs(params);
        this.variadicArgs = params == null ? false : VncFunction.hasRemaingsArgs(params);
    }

    @Override
    public VncFunction withMeta(VncVal meta) {
        this.fnMeta.set(meta);
        this._private = MetaUtil.isPrivate(meta);
        return this;
    }

    @Override
    public abstract VncVal apply(VncList var1);

    public void setNamespace(String ns) {
        this.fnMeta.set(MetaUtil.setNamespace(this.fnMeta.get(), ns));
        this.ns = ns;
    }

    public boolean isRedefinable() {
        return true;
    }

    public VncVector getParams() {
        return this.params;
    }

    public boolean isMacro() {
        return this.macro;
    }

    public void setMacro() {
        this.macro = true;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public VncList getArgLists() {
        return (VncList)this.getMetaVal(MetaUtil.ARGLIST, VncTinyList.empty());
    }

    public VncVal getDoc() {
        return this.getMetaVal(MetaUtil.DOC);
    }

    public VncList getExamples() {
        return (VncList)this.getMetaVal(MetaUtil.EXAMPLES, VncTinyList.empty());
    }

    public int getFixedArgsCount() {
        return this.fixedArgsCount;
    }

    public boolean hasVariadicArgs() {
        return this.variadicArgs;
    }

    public VncVal getBody() {
        return Constants.Nil;
    }

    @Override
    public VncVal getMeta() {
        return this.fnMeta.get();
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    public String getNamespace() {
        return this.ns;
    }

    @Override
    public int typeRank() {
        return 100;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return String.format("%s %s %s", this.isMacro() ? "macro" : "function", this.getQualifiedName(), new StringBuilder().append("{").append("visibility ").append(this.isPrivate() ? ":private" : ":public").append(", ns ").append(StringUtil.quote(this.ns == null ? "" : this.ns, '\"')).append("}"));
    }

    public static String createAnonymousFuncName() {
        return VncFunction.createAnonymousFuncName(null);
    }

    public static String createAnonymousFuncName(String name) {
        return StringUtil.isEmpty(name) ? "anonymous-" + UUID.randomUUID().toString() : "anonymous-" + name + "-" + UUID.randomUUID().toString();
    }

    private static String getNamespace(String qualifiedName) {
        int pos = qualifiedName.indexOf("/");
        return pos < 1 ? "core" : qualifiedName.substring(0, pos);
    }

    private static String getSimpleName(String qualifiedName) {
        int pos = qualifiedName.indexOf("/");
        return pos < 1 ? qualifiedName : qualifiedName.substring(pos + 1);
    }

    private static int countFixedArgs(VncVector params) {
        int fixedArgs = 0;
        for (VncVal p : params.getList()) {
            if (VncFunction.isElisionSymbol(p)) break;
            ++fixedArgs;
        }
        return fixedArgs;
    }

    private static boolean hasRemaingsArgs(VncVector params) {
        for (VncVal p : params.getList()) {
            if (!VncFunction.isElisionSymbol(p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isElisionSymbol(VncVal val) {
        return Types.isVncSymbol(val) && ((VncSymbol)val).getName().equals("&");
    }

    public static MetaBuilder meta() {
        return new MetaBuilder();
    }

    public static class MetaBuilder {
        private final HashMap<VncVal, VncVal> meta = new HashMap();

        public MetaBuilder arglists(String ... arglists) {
            this.meta.put(MetaUtil.ARGLIST, new VncList(Arrays.stream(arglists).map(s -> new VncString((String)s)).collect(Collectors.toList())));
            return this;
        }

        public MetaBuilder doc(String doc) {
            this.meta.put(MetaUtil.DOC, new VncString(doc));
            return this;
        }

        public MetaBuilder examples(String ... examples) {
            this.meta.put(MetaUtil.EXAMPLES, new VncList(Arrays.stream(examples).map(s -> new VncString((String)s)).collect(Collectors.toList())));
            return this;
        }

        public VncHashMap build() {
            return new VncHashMap(this.meta);
        }
    }
}

