/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.ArrayList;

public class VncString
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private static VncString EMPTY = new VncString("");
    private final String value;

    public VncString(String v) {
        this(v, Constants.Nil);
    }

    public VncString(String v, VncVal meta) {
        super(meta);
        this.value = v == null ? "" : v;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public VncString withMeta(VncVal meta) {
        return new VncString(this.value, meta);
    }

    public int size() {
        return this.value.length();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.length()) {
            throw new VncException(String.format("nth: index %d out of range for a string of length %d", idx, this.value.length()));
        }
        return new VncString(String.valueOf(this.value.charAt(idx)));
    }

    public VncVal nthOrDefault(int idx, VncString defaultVal) {
        return idx < 0 || idx >= this.value.length() ? defaultVal : this.nth(idx);
    }

    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.nth(0);
    }

    public VncVal second() {
        return this.size() < 2 ? Constants.Nil : this.nth(1);
    }

    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.nth(this.value.length() - 1);
    }

    public VncList toVncList() {
        ArrayList<VncString> list = new ArrayList<VncString>();
        for (char c : this.value.toCharArray()) {
            list.add(new VncString(String.valueOf(c)));
        }
        return new VncList(list);
    }

    public VncSymbol toSymbol() {
        return new VncSymbol(this.getValue());
    }

    @Override
    public int typeRank() {
        return 5;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncChar(o)) {
            return this.getValue().compareTo(((VncChar)o).getValue().toString());
        }
        if (Types.isVncString(o)) {
            return this.getValue().compareTo(((VncString)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncString other = (VncString)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String toString(boolean print_readably) {
        if (print_readably) {
            return "\"" + StringUtil.escape(this.value) + "\"";
        }
        return this.value;
    }

    public static VncString empty() {
        return EMPTY;
    }
}

