/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VncMutableSet
extends VncSet {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Set<VncVal> value = new HashSet<VncVal>();

    public VncMutableSet() {
        this(null, null);
    }

    public VncMutableSet(VncVal meta) {
        this(null, meta);
    }

    public VncMutableSet(Collection<? extends VncVal> val) {
        this(val, null);
    }

    public VncMutableSet(Collection<? extends VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        if (val != null) {
            this.value.addAll(val);
        }
    }

    public static VncMutableSet ofAll(Collection<? extends VncVal> val) {
        return new VncMutableSet(val);
    }

    public static VncMutableSet ofAll(VncSequence val) {
        return new VncMutableSet(val.getList());
    }

    public static VncMutableSet of(VncVal ... mvs) {
        return new VncMutableSet(Arrays.asList(mvs));
    }

    @Override
    public VncMutableSet emptyWithMeta() {
        return new VncMutableSet(this.getMeta());
    }

    @Override
    public VncMutableSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncMutableSet(replaceVals, this.getMeta());
    }

    @Override
    public VncMutableSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncMutableSet(replaceVals, meta);
    }

    @Override
    public VncMutableSet withMeta(VncVal meta) {
        return new VncMutableSet(this.value, meta);
    }

    @Override
    public VncMutableSet add(VncVal val) {
        this.value.add(val);
        return this;
    }

    @Override
    public VncMutableSet addAll(VncSet val) {
        this.value.addAll(val.getSet());
        return this;
    }

    @Override
    public VncMutableSet addAll(VncSequence val) {
        this.value.addAll(val.getList());
        return this;
    }

    @Override
    public VncMutableSet remove(VncVal val) {
        this.value.remove(val);
        return this;
    }

    @Override
    public VncMutableSet removeAll(VncSet val) {
        this.value.removeAll(val.getSet());
        return this;
    }

    @Override
    public VncMutableSet removeAll(VncSequence val) {
        this.value.removeAll(val.getList());
        return this;
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public Set<VncVal> getSet() {
        return Collections.unmodifiableSet(this.value);
    }

    @Override
    public List<VncVal> getList() {
        return Collections.unmodifiableList(new ArrayList<VncVal>(this.value));
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getList(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int typeRank() {
        return 206;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncMutableSet(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncMutableSet)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncMutableSet other = (VncMutableSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getList(), " ", print_readably) + "}";
    }
}

