/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.repackage.org.jline.builtins.CommandRegistry;
import org.repackage.org.jline.builtins.Commands;
import org.repackage.org.jline.builtins.Completers;
import org.repackage.org.jline.builtins.Options;
import org.repackage.org.jline.builtins.TTop;
import org.repackage.org.jline.builtins.Widgets;
import org.repackage.org.jline.reader.Candidate;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.reader.ConfigurationPath;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.Widget;
import org.repackage.org.jline.reader.impl.completer.ArgumentCompleter;
import org.repackage.org.jline.reader.impl.completer.NullCompleter;
import org.repackage.org.jline.reader.impl.completer.StringsCompleter;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.AttributedString;

public class Builtins
implements CommandRegistry {
    private ConfigurationPath configPath;
    private final Function<String, Widget> widgetCreator;
    private final Supplier<Path> workDir;
    private Map<Command, String> commandName = new HashMap<Command, String>();
    private Map<String, Command> nameCommand = new HashMap<String, Command>();
    private Map<String, String> aliasCommand = new HashMap<String, String>();
    private final Map<Command, CommandMethods> commandExecute = new HashMap<Command, CommandMethods>();
    private Map<Command, List<String>> commandInfo = new HashMap<Command, List<String>>();
    private LineReader reader;
    private Exception exception;

    public Builtins(Path workDir, ConfigurationPath configPath, Function<String, Widget> widgetCreator) {
        this(null, () -> workDir, configPath, widgetCreator);
    }

    public Builtins(Set<Command> commands, Path workDir, ConfigurationPath configpath, Function<String, Widget> widgetCreator) {
        this(commands, () -> workDir, configpath, widgetCreator);
    }

    public Builtins(Supplier<Path> workDir, ConfigurationPath configPath, Function<String, Widget> widgetCreator) {
        this(null, workDir, configPath, widgetCreator);
    }

    public Builtins(Set<Command> commands, Supplier<Path> workDir, ConfigurationPath configpath, Function<String, Widget> widgetCreator) {
        this.configPath = configpath;
        this.widgetCreator = widgetCreator;
        this.workDir = workDir;
        HashSet<Object> cmds = new HashSet();
        cmds = commands == null ? new HashSet<Command>(EnumSet.allOf(Command.class)) : new HashSet<Command>(commands);
        for (Command c : cmds) {
            this.commandName.put(c, c.name().toLowerCase());
        }
        this.doNameCommand();
        this.commandExecute.put(Command.NANO, new CommandMethods(this::nano, this::nanoCompleter));
        this.commandExecute.put(Command.LESS, new CommandMethods(this::less, this::lessCompleter));
        this.commandExecute.put(Command.HISTORY, new CommandMethods(this::history, this::historyCompleter));
        this.commandExecute.put(Command.WIDGET, new CommandMethods(this::widget, this::widgetCompleter));
        this.commandExecute.put(Command.KEYMAP, new CommandMethods(this::keymap, this::keymapCompleter));
        this.commandExecute.put(Command.SETOPT, new CommandMethods(this::setopt, this::setoptCompleter));
        this.commandExecute.put(Command.SETVAR, new CommandMethods(this::setvar, this::setvarCompleter));
        this.commandExecute.put(Command.UNSETOPT, new CommandMethods(this::unsetopt, this::unsetoptCompleter));
        this.commandExecute.put(Command.TTOP, new CommandMethods(this::ttop, this::ttopCompleter));
    }

    @Override
    public Set<String> commandNames() {
        return this.nameCommand.keySet();
    }

    @Override
    public Map<String, String> commandAliases() {
        return this.aliasCommand;
    }

    @Override
    public List<String> commandInfo(String command) {
        if (!this.commandInfo.containsKey((Object)this.command(command))) {
            this.commandOptions(command);
        }
        return this.commandInfo.get((Object)this.command(command));
    }

    private void doNameCommand() {
        this.nameCommand = this.commandName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public void setLineReader(LineReader reader) {
        this.reader = reader;
    }

    public void rename(Command command, String newName) {
        if (this.nameCommand.containsKey(newName)) {
            throw new IllegalArgumentException("Duplicate command name!");
        }
        if (!this.commandName.containsKey((Object)command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.commandName.put(command, newName);
        this.doNameCommand();
    }

    public void alias(String alias, String command) {
        if (!this.nameCommand.keySet().contains(command)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        this.aliasCommand.put(alias, command);
    }

    @Override
    public boolean hasCommand(String name) {
        return this.nameCommand.containsKey(name) || this.aliasCommand.containsKey(name);
    }

    @Override
    public Completers.SystemCompleter compileCompleters() {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        for (Map.Entry<Command, String> entry : this.commandName.entrySet()) {
            out.add(entry.getValue(), this.commandExecute.get((Object)entry.getKey()).compileCompleter().apply(entry.getValue()));
        }
        out.addAliases(this.aliasCommand);
        return out;
    }

    private Command command(String name) {
        Command out = null;
        if (!this.hasCommand(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        if (this.aliasCommand.containsKey(name)) {
            name = this.aliasCommand.get(name);
        }
        if (!this.nameCommand.containsKey(name)) {
            throw new IllegalArgumentException("Command does not exists!");
        }
        out = this.nameCommand.get(name);
        return out;
    }

    private void execute(String command, List<String> args) throws Exception {
        this.execute(command, args, System.in, System.out, System.err);
    }

    public void execute(String command, List<String> args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        this.execute(command, args.toArray(new String[0]), in, out, err);
    }

    public void execute(String command, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        this.exception = null;
        this.commandExecute.get((Object)this.command(command)).execute().accept(new CommandInput(args, in, out, err));
        if (this.exception != null) {
            throw this.exception;
        }
    }

    @Override
    public Widgets.CmdDesc commandDescription(String command) {
        Widgets.CmdDesc out = null;
        List<String> args = Arrays.asList("--help");
        try {
            this.execute(command, args);
        }
        catch (Options.HelpException e) {
            ArrayList<AttributedString> main = new ArrayList<AttributedString>();
            HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
            String[] msg = e.getMessage().replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
            String prevOpt = null;
            boolean mainDone = false;
            boolean start = false;
            for (String s : msg) {
                int ind;
                if (!start) {
                    if (!s.trim().startsWith("Usage: ")) continue;
                    s = s.split("Usage:")[1];
                    start = true;
                }
                if (s.matches("^\\s+-.*$")) {
                    mainDone = true;
                    ind = s.lastIndexOf("  ");
                    if (ind > 0) {
                        String o = s.substring(0, ind);
                        String d = s.substring(ind);
                        if (o.trim().length() > 0) {
                            prevOpt = o.trim();
                            options.put(prevOpt, new ArrayList<AttributedString>(Arrays.asList(this.highlightComment(d.trim()))));
                        }
                    }
                } else if (s.matches("^[\\s]{20}.*$") && prevOpt != null && options.containsKey(prevOpt)) {
                    ind = s.lastIndexOf("  ");
                    if (ind > 0) {
                        ((List)options.get(prevOpt)).add(this.highlightComment(s.substring(ind).trim()));
                    }
                } else {
                    prevOpt = null;
                }
                if (mainDone) continue;
                main.add(Options.HelpException.highlightSyntax(s.trim(), Options.HelpException.defaultStyle()));
            }
            out = new Widgets.CmdDesc(main, Widgets.ArgDesc.doArgNames(Arrays.asList("")), options);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private List<Completers.OptDesc> commandOptions(String command) {
        ArrayList<Completers.OptDesc> out = new ArrayList<Completers.OptDesc>();
        List<String> args = Arrays.asList("--help");
        try {
            this.execute(command, args);
        }
        catch (Options.HelpException e) {
            ArrayList<String> info = new ArrayList<String>();
            String[] msg = e.getMessage().replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
            boolean start = false;
            boolean first = true;
            for (String s : msg) {
                int ind;
                if (!start) {
                    if (s.trim().startsWith("Usage: ")) {
                        s = s.split("Usage:")[1];
                        start = true;
                    } else {
                        if (first && s.contains(" - ")) {
                            info.add(s.substring(s.indexOf(" - ") + 3).trim());
                        } else {
                            info.add(s.trim());
                        }
                        first = false;
                        continue;
                    }
                }
                if (!s.matches("^\\s+-.*$") || (ind = s.lastIndexOf("  ")) <= 0) continue;
                String[] op = s.substring(0, ind).trim().split("\\s+");
                String d = s.substring(ind).trim();
                String so = null;
                String lo = null;
                if (op.length == 1) {
                    if (op[0].startsWith("--")) {
                        lo = op[0];
                    } else {
                        so = op[0];
                    }
                } else {
                    so = op[0];
                    lo = op[1];
                }
                lo = lo == null ? lo : lo.split("=")[0];
                out.add(new Completers.OptDesc(so, lo, d));
            }
            this.commandInfo.put(this.command(command), info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private AttributedString highlightComment(String comment) {
        return Options.HelpException.highlightComment(comment, Options.HelpException.defaultStyle());
    }

    private Terminal terminal() {
        return this.reader.getTerminal();
    }

    private void less(CommandInput input) {
        try {
            Commands.less(this.terminal(), input.in(), input.out(), input.err(), this.workDir.get(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void nano(CommandInput input) {
        try {
            Commands.nano(this.terminal(), input.out(), input.err(), this.workDir.get(), input.args(), this.configPath);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void history(CommandInput input) {
        try {
            Commands.history(this.reader, input.out(), input.err(), this.workDir.get(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void widget(CommandInput input) {
        try {
            Commands.widget(this.reader, input.out(), input.err(), this.widgetCreator, input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void keymap(CommandInput input) {
        try {
            Commands.keymap(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void setopt(CommandInput input) {
        try {
            Commands.setopt(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void setvar(CommandInput input) {
        try {
            Commands.setvar(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void unsetopt(CommandInput input) {
        try {
            Commands.unsetopt(this.reader, input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void ttop(CommandInput input) {
        try {
            TTop.ttop(this.terminal(), input.out(), input.err(), input.args());
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private List<String> unsetOptions(boolean set) {
        ArrayList<String> out = new ArrayList<String>();
        for (LineReader.Option option : LineReader.Option.values()) {
            if (set != (this.reader.isSet(option) == option.isDef())) continue;
            out.add((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
        }
        return out;
    }

    private Set<String> allWidgets() {
        HashSet<String> out = new HashSet<String>();
        for (String s : this.reader.getWidgets().keySet()) {
            out.add(s);
            out.add(this.reader.getWidgets().get(s).toString());
        }
        return out;
    }

    private List<Completer> nanoCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new Completers.FilesCompleter(this.workDir), this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> lessCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)new Completers.FilesCompleter(this.workDir), this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> historyCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        List<Completers.OptDesc> optDescs = this.commandOptions(this.commandName.get((Object)Command.HISTORY));
        for (Completers.OptDesc o : optDescs) {
            if (o.shortOption() == null || !o.shortOption().equals("-A") && !o.shortOption().equals("-W") && !o.shortOption().equals("-R")) continue;
            o.setValueCompleter(new Completers.FilesCompleter(this.workDir));
        }
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, optDescs, 1)));
        return completers;
    }

    private List<Completer> widgetCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        List<Completers.OptDesc> optDescs = this.commandOptions(this.commandName.get((Object)Command.WIDGET));
        Candidate aliasOption = new Candidate("-A", "-A", null, null, null, null, true);
        Iterator<Completers.OptDesc> i = optDescs.iterator();
        while (i.hasNext()) {
            Completers.OptDesc o = i.next();
            if (o.shortOption() == null) continue;
            if (o.shortOption().equals("-D")) {
                o.setValueCompleter(new StringsCompleter(() -> this.reader.getWidgets().keySet()));
                continue;
            }
            if (!o.shortOption().equals("-A")) continue;
            aliasOption = new Candidate(o.shortOption(), o.shortOption(), null, o.description(), null, null, true);
            i.remove();
        }
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, optDescs, 1)));
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new StringsCompleter(aliasOption), new StringsCompleter(() -> this.allWidgets()), new StringsCompleter(() -> this.reader.getWidgets().keySet()), NullCompleter.INSTANCE));
        return completers;
    }

    private List<Completer> keymapCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    private List<Completer> setvarCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new StringsCompleter(() -> this.reader.getVariables().keySet()), NullCompleter.INSTANCE));
        return completers;
    }

    private List<Completer> setoptCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new StringsCompleter(() -> this.unsetOptions(true))));
        return completers;
    }

    private List<Completer> unsetoptCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new StringsCompleter(() -> this.unsetOptions(false))));
        return completers;
    }

    private List<Completer> ttopCompleter(String name) {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        completers.add(new ArgumentCompleter(NullCompleter.INSTANCE, new Completers.OptionCompleter((Completer)NullCompleter.INSTANCE, this::commandOptions, 1)));
        return completers;
    }

    public static class CommandMethods {
        Consumer<CommandInput> execute;
        Function<String, List<Completer>> compileCompleter;

        public CommandMethods(Consumer<CommandInput> execute, Function<String, List<Completer>> compileCompleter) {
            this.execute = execute;
            this.compileCompleter = compileCompleter;
        }

        public Consumer<CommandInput> execute() {
            return this.execute;
        }

        public Function<String, List<Completer>> compileCompleter() {
            return this.compileCompleter;
        }
    }

    public static class CommandInput {
        String[] args;
        InputStream in;
        PrintStream out;
        PrintStream err;

        public CommandInput(String[] args) {
            this(args, null, null, null);
        }

        public CommandInput(String[] args, InputStream in, PrintStream out, PrintStream err) {
            this.args = args;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public String[] args() {
            return this.args;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }

    public static enum Command {
        NANO,
        LESS,
        HISTORY,
        WIDGET,
        KEYMAP,
        SETOPT,
        SETVAR,
        UNSETOPT,
        TTOP;

    }
}

