/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.HashSet;

public class VncJavaSet
extends VncSet
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Set<Object> value;

    public VncJavaSet() {
        this(null, null);
    }

    public VncJavaSet(VncVal meta) {
        this(null, meta);
    }

    public VncJavaSet(Set<Object> val) {
        this(val, null);
    }

    public VncJavaSet(Set<Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncJavaSet emptyWithMeta() {
        return new VncJavaSet(this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncHashSet(HashSet.ofAll(replaceVals), this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncHashSet(HashSet.ofAll(replaceVals), meta);
    }

    @Override
    public VncJavaSet withMeta(VncVal meta) {
        return new VncJavaSet(this.value, meta);
    }

    @Override
    public VncJavaSet add(VncVal val) {
        this.value.add(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaSet addAll(VncSet val) {
        if (Types.isVncJavaSet(val)) {
            this.value.addAll(((VncJavaSet)val).value);
        } else {
            val.getList().forEach(v -> this.add((VncVal)v));
        }
        return this;
    }

    @Override
    public VncJavaSet addAll(VncSequence val) {
        if (Types.isVncJavaList(val)) {
            this.value.addAll((List)((VncJavaList)val).getDelegate());
        } else {
            val.getList().forEach(v -> this.add((VncVal)v));
        }
        return this;
    }

    @Override
    public VncJavaSet remove(VncVal val) {
        this.value.remove(val.convertToJavaObject());
        return this;
    }

    @Override
    public VncJavaSet removeAll(VncSet val) {
        if (Types.isVncJavaSet(val)) {
            this.value.removeAll(((VncJavaSet)val).value);
        } else {
            val.getList().forEach(v -> this.remove((VncVal)v));
        }
        return this;
    }

    @Override
    public VncJavaSet removeAll(VncSequence val) {
        if (Types.isVncJavaList(val)) {
            this.value.removeAll((List)((VncJavaList)val).getDelegate());
        } else {
            val.getList().forEach(v -> this.remove((VncVal)v));
        }
        return this;
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val.convertToJavaObject());
    }

    @Override
    public Set<VncVal> getSet() {
        return Collections.unmodifiableSet(this.getVncValueSet());
    }

    @Override
    public List<VncVal> getList() {
        return Collections.unmodifiableList(this.getVncValueList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getVncValueList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getVncValueList(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int typeRank() {
        return 206;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaSet(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncJavaSet)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaSet other = (VncJavaSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getVncValueList(), " ", print_readably) + "}";
    }

    private List<VncVal> getVncValueList() {
        return this.value.stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
    }

    private Set<VncVal> getVncValueSet() {
        return this.value.stream().map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toSet());
    }
}

