/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;

public class VncStack
extends VncCollection {
    private static final long serialVersionUID = -564531670922145260L;
    private final ConcurrentLinkedDeque<VncVal> stack;

    public VncStack() {
        super(Constants.Nil);
        this.stack = new ConcurrentLinkedDeque();
    }

    private VncStack(VncStack stack, VncVal meta) {
        super(meta);
        this.stack = stack.stack;
    }

    @Override
    public VncCollection emptyWithMeta() {
        return new VncStack();
    }

    @Override
    public VncStack withMeta(VncVal meta) {
        return new VncStack(this, meta);
    }

    @Override
    public VncList toVncList() {
        return VncList.of(this.stack.toArray(new VncVal[0]));
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.of(this.stack.toArray(new VncVal[0]));
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public VncStack push(VncVal val) {
        this.stack.push(val);
        return this;
    }

    public VncVal pop() {
        return this.toNil(this.stack.poll());
    }

    public VncVal peek() {
        return this.toNil(this.stack.peek());
    }

    public void clear() {
        this.stack.clear();
    }

    @Override
    public int typeRank() {
        return 203;
    }

    @Override
    public Object convertToJavaObject() {
        return Arrays.stream(this.stack.toArray(new VncVal[0])).map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    public String toString() {
        return "(" + Printer.join(this.toVncList().getList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.toVncList().getList(), " ", print_readably) + ")";
    }

    private VncVal toNil(VncVal val) {
        return val == null ? Constants.Nil : val;
    }
}

