/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.util;

import com.github.jlangch.venice.impl.functions.MathOp;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedMap;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Map;

public class Types {
    public static boolean isIDeref(Object val) {
        return val != null && val instanceof IDeref;
    }

    public static boolean isVncVal(Object val) {
        return val != null && val instanceof VncVal;
    }

    public static boolean isVncConstant(VncVal val) {
        return val != null && val instanceof VncConstant;
    }

    public static boolean isVncAtom(VncVal val) {
        return val != null && val instanceof VncAtom;
    }

    public static boolean isVncVolatile(VncVal val) {
        return val != null && val instanceof VncVolatile;
    }

    public static boolean isVncThreadLocal(VncVal val) {
        return val != null && val instanceof VncThreadLocal;
    }

    public static boolean isVncString(VncVal val) {
        return val != null && val instanceof VncString;
    }

    public static boolean isVncChar(VncVal val) {
        return val != null && val instanceof VncChar;
    }

    public static boolean isVncKeyword(VncVal val) {
        return val != null && val instanceof VncKeyword;
    }

    public static boolean isVncSymbol(VncVal val) {
        return val != null && val instanceof VncSymbol;
    }

    public static boolean isVncBoolean(VncVal val) {
        return val == Constants.True || val == Constants.False;
    }

    public static boolean isVncInteger(VncVal val) {
        return val != null && val instanceof VncInteger;
    }

    public static boolean isVncLong(VncVal val) {
        return val != null && val instanceof VncLong;
    }

    public static boolean isVncDouble(VncVal val) {
        return val != null && val instanceof VncDouble;
    }

    public static boolean isVncBigDecimal(VncVal val) {
        return val != null && val instanceof VncBigDecimal;
    }

    public static boolean isVncNumber(VncVal val) {
        return val != null && (Types.isVncLong(val) || Types.isVncInteger(val) || Types.isVncDouble(val) || Types.isVncBigDecimal(val));
    }

    public static boolean isVncByteBuffer(VncVal val) {
        return val != null && val instanceof VncByteBuffer;
    }

    public static boolean isVncCollection(VncVal val) {
        return val != null && val instanceof VncCollection;
    }

    public static boolean isVncSet(VncVal val) {
        return val != null && val instanceof VncSet;
    }

    public static boolean isVncHashSet(VncVal val) {
        return val != null && val instanceof VncHashSet;
    }

    public static boolean isVncSortedSet(VncVal val) {
        return val != null && val instanceof VncSortedSet;
    }

    public static boolean isVncMutableSet(VncVal val) {
        return val != null && val instanceof VncMutableSet;
    }

    public static boolean isVncSequence(VncVal val) {
        return val != null && val instanceof VncSequence;
    }

    public static boolean isVncList(VncVal val) {
        return val != null && val instanceof VncList;
    }

    public static boolean isVncVector(VncVal val) {
        return val != null && val instanceof VncVector;
    }

    public static boolean isVncMap(VncVal val) {
        return val != null && val instanceof VncMap;
    }

    public static boolean isVncHashMap(VncVal val) {
        return val != null && val instanceof VncHashMap;
    }

    public static boolean isVncOrderedMap(VncVal val) {
        return val != null && val instanceof VncOrderedMap;
    }

    public static boolean isVncSortedMap(VncVal val) {
        return val != null && val instanceof VncSortedMap;
    }

    public static boolean isVncMutableMap(VncVal val) {
        return val != null && val instanceof VncMutableMap;
    }

    public static boolean isVncMapEntry(VncVal val) {
        return val != null && val instanceof VncMapEntry;
    }

    public static boolean isVncStack(VncVal val) {
        return val != null && val instanceof VncStack;
    }

    public static boolean isVncQueue(VncVal val) {
        return val != null && val instanceof VncQueue;
    }

    public static boolean isIVncFunction(VncVal val) {
        return val != null && val instanceof IVncFunction;
    }

    public static boolean isVncFunction(VncVal val) {
        return val != null && val instanceof VncFunction;
    }

    public static boolean isVncMultiArityFunction(VncVal val) {
        return val != null && val instanceof VncMultiArityFunction;
    }

    public static boolean isVncMultiFunction(VncVal val) {
        return val != null && val instanceof VncMultiFunction;
    }

    public static boolean isVncMacro(VncVal val) {
        return val != null && Types.isVncFunction(val) && ((VncFunction)val).isMacro();
    }

    public static boolean isVncFunctionOrKeyword(VncVal val) {
        return val != null && (val instanceof VncFunction || val instanceof VncKeyword);
    }

    public static boolean isVncJavaObject(VncVal val) {
        return val != null && val instanceof VncJavaObject;
    }

    public static boolean isVncJavaObject(VncVal val, Class<?> type) {
        return val != null && val instanceof VncJavaObject && type.isAssignableFrom(((VncJavaObject)val).getDelegate().getClass());
    }

    public static boolean isVncJavaList(VncVal val) {
        return val != null && val instanceof VncJavaList;
    }

    public static boolean isVncJavaSet(VncVal val) {
        return val != null && val instanceof VncJavaSet;
    }

    public static boolean isVncJavaMap(VncVal val) {
        return val != null && val instanceof VncJavaMap;
    }

    public static VncKeyword getType(VncVal val) {
        if (val == Constants.Nil) {
            return new VncKeyword("venice.Nil");
        }
        if (val == Constants.True || val == Constants.False) {
            return new VncKeyword("venice.Boolean");
        }
        if (Types.isVncAtom(val)) {
            return new VncKeyword("venice.Atom");
        }
        if (Types.isVncVolatile(val)) {
            return new VncKeyword("venice.Volatile");
        }
        if (Types.isVncThreadLocal(val)) {
            return new VncKeyword("venice.ThreadLocal");
        }
        if (Types.isVncLong(val)) {
            return new VncKeyword("venice.Long");
        }
        if (Types.isVncInteger(val)) {
            return new VncKeyword("venice.Integer");
        }
        if (Types.isVncDouble(val)) {
            return new VncKeyword("venice.Double");
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncKeyword("venice.Decimal");
        }
        if (Types.isVncByteBuffer(val)) {
            return new VncKeyword("venice.ByteBuffer");
        }
        if (Types.isVncMultiArityFunction(val)) {
            return ((VncFunction)val).isMacro() ? new VncKeyword("venice.Macro") : new VncKeyword("venice.Function");
        }
        if (Types.isVncMultiFunction(val)) {
            return new VncKeyword("venice.MultiFunction");
        }
        if (Types.isVncFunction(val)) {
            return ((VncFunction)val).isMacro() ? new VncKeyword("venice.Macro") : new VncKeyword("venice.Function");
        }
        if (Types.isVncSymbol(val)) {
            return new VncKeyword("venice.Symbol");
        }
        if (Types.isVncKeyword(val)) {
            return new VncKeyword("venice.Keyword");
        }
        if (Types.isVncString(val)) {
            return new VncKeyword("venice.String");
        }
        if (Types.isVncVector(val)) {
            return new VncKeyword("venice.Vector");
        }
        if (Types.isVncList(val)) {
            return new VncKeyword("venice.List");
        }
        if (Types.isVncHashSet(val)) {
            return new VncKeyword("venice.HashSet");
        }
        if (Types.isVncSortedSet(val)) {
            return new VncKeyword("venice.SortedSet");
        }
        if (Types.isVncHashMap(val)) {
            return new VncKeyword("venice.HashMap");
        }
        if (Types.isVncOrderedMap(val)) {
            return new VncKeyword("venice.OrderedMap");
        }
        if (Types.isVncSortedMap(val)) {
            return new VncKeyword("venice.SortedMap");
        }
        if (Types.isVncMutableMap(val)) {
            return new VncKeyword("venice.MutableMap");
        }
        if (Types.isVncMapEntry(val)) {
            return new VncKeyword("venice.MapEntry");
        }
        if (Types.isVncJavaObject(val)) {
            return new VncKeyword(((IVncJavaObject)((Object)val)).getDelegate().getClass().getName());
        }
        if (Types.isVncJavaSet(val)) {
            return new VncKeyword(((IVncJavaObject)((Object)val)).getDelegate().getClass().getName());
        }
        if (Types.isVncJavaList(val)) {
            return new VncKeyword(((IVncJavaObject)((Object)val)).getDelegate().getClass().getName());
        }
        if (Types.isVncJavaMap(val)) {
            return new VncKeyword(((IVncJavaObject)((Object)val)).getDelegate().getClass().getName());
        }
        if (Types.isVncSet(val)) {
            return new VncKeyword("venice.Set");
        }
        if (Types.isVncMap(val)) {
            return new VncKeyword("venice.Map");
        }
        if (Types.isVncStack(val)) {
            return new VncKeyword("venice.Stack");
        }
        if (Types.isVncQueue(val)) {
            return new VncKeyword("venice.Queue");
        }
        return new VncKeyword(val.getClass().getName());
    }

    public static boolean isInstanceOf(VncKeyword type, VncVal val) {
        String clazz;
        switch (clazz = type.getValue()) {
            case "venice.Nil": {
                return val == Constants.Nil;
            }
            case "venice.Boolean": {
                return val == Constants.True || val == Constants.False;
            }
            case "venice.Atom": {
                return Types.isVncAtom(val);
            }
            case "venice.Volatile": {
                return Types.isVncVolatile(val);
            }
            case "venice.ThreadLocal": {
                return Types.isVncThreadLocal(val);
            }
            case "venice.Long": {
                return Types.isVncLong(val);
            }
            case "venice.Integer": {
                return Types.isVncInteger(val);
            }
            case "venice.Double": {
                return Types.isVncDouble(val);
            }
            case "venice.Decimal": {
                return Types.isVncBigDecimal(val);
            }
            case "venice.ByteBuffer": {
                return Types.isVncByteBuffer(val);
            }
            case "venice.Function": {
                return Types.isVncFunction(val);
            }
            case "venice.String": {
                return Types.isVncString(val);
            }
            case "venice.Symbol": {
                return Types.isVncSymbol(val);
            }
            case "venice.Keyword": {
                return Types.isVncKeyword(val);
            }
            case "venice.Collection": {
                return Types.isVncCollection(val);
            }
            case "venice.Sequence": {
                return Types.isVncSequence(val);
            }
            case "venice.Vector": {
                return Types.isVncVector(val);
            }
            case "venice.List": {
                return Types.isVncList(val);
            }
            case "venice.Set": {
                return Types.isVncSet(val);
            }
            case "venice.HashSet": {
                return Types.isVncHashSet(val);
            }
            case "venice.SortedSet": {
                return Types.isVncSortedSet(val);
            }
            case "venice.Map": {
                return Types.isVncMap(val);
            }
            case "venice.HashMap": {
                return Types.isVncHashMap(val);
            }
            case "venice.OrderedMap": {
                return Types.isVncOrderedMap(val);
            }
            case "venice.SortedMap": {
                return Types.isVncSortedMap(val);
            }
            case "venice.MutableMap": {
                return Types.isVncMutableMap(val);
            }
            case "venice.MapEntry": {
                return Types.isVncMapEntry(val);
            }
        }
        try {
            if (Types.isVncJavaObject(val)) {
                return Class.forName(clazz).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaSet(val)) {
                return Class.forName(clazz).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaList(val)) {
                return Class.forName(clazz).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            if (Types.isVncJavaMap(val)) {
                return Class.forName(clazz).isAssignableFrom(((IVncJavaObject)((Object)val)).getDelegate().getClass());
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean _equal_Q(VncVal a, VncVal b) {
        if (Types.isVncNumber(a) && Types.isVncNumber(b)) {
            return Numeric.calc(MathOp.EQU, a, b) == Constants.True;
        }
        if (Types.isVncString(a) && Types.isVncChar(b)) {
            return ((VncString)a).getValue().equals(((VncChar)b).getValue().toString());
        }
        if (Types.isVncChar(a) && Types.isVncString(b)) {
            return ((VncChar)a).getValue().toString().equals(((VncString)b).getValue());
        }
        return Types._equal_strict_Q(a, b);
    }

    public static boolean _equal_strict_Q(VncVal a, VncVal b) {
        Class<?> otb;
        Class<?> ota = a.getClass();
        if (!(ota == (otb = b.getClass()) || a instanceof VncString && b instanceof VncString || a instanceof VncList && b instanceof VncList)) {
            return false;
        }
        if (a instanceof VncConstant) {
            return (VncConstant)a == (VncConstant)b;
        }
        if (a instanceof VncLong) {
            return ((VncLong)a).getValue().equals(((VncLong)b).getValue());
        }
        if (a instanceof VncInteger) {
            return ((VncInteger)a).getValue().equals(((VncInteger)b).getValue());
        }
        if (a instanceof VncDouble) {
            return ((VncDouble)a).getValue().equals(((VncDouble)b).getValue());
        }
        if (a instanceof VncBigDecimal) {
            return ((VncBigDecimal)a).getValue().equals(((VncBigDecimal)b).getValue());
        }
        if (a instanceof VncSymbol) {
            return ((VncSymbol)a).getName().equals(((VncSymbol)b).getName());
        }
        if (a instanceof VncString) {
            return ((VncString)a).getValue().equals(((VncString)b).getValue());
        }
        if (a instanceof VncSequence) {
            if (((VncSequence)a).size() != ((VncSequence)b).size()) {
                return false;
            }
            Integer i = 0;
            while (i < ((VncSequence)a).size()) {
                if (!Types._equal_Q(((VncSequence)a).nth(i), ((VncSequence)b).nth(i))) {
                    return false;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return true;
        }
        if (a instanceof VncHashSet) {
            if (((VncHashSet)a).size() != ((VncHashSet)b).size()) {
                return false;
            }
            return ((VncHashSet)a).getList().stream().allMatch(v -> ((VncHashSet)b).contains((VncVal)v));
        }
        if (a instanceof VncMap) {
            if (((VncMap)a).getMap().size() != ((VncMap)b).getMap().size()) {
                return false;
            }
            VncMap mhm = (VncMap)a;
            Map<VncVal, VncVal> hm = mhm.getMap();
            for (VncVal k : hm.keySet()) {
                VncVal valA = ((VncMap)a).getMap().get(k);
                VncVal valB = ((VncMap)b).getMap().get(k);
                if (valA == null && valB == null) {
                    return true;
                }
                if (valA != null && valB != null) {
                    if (Types._equal_Q(valA, valB)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (a instanceof VncJavaList) {
            return a.equals(b);
        }
        if (a instanceof VncJavaSet) {
            return a.equals(b);
        }
        if (a instanceof VncJavaMap) {
            return a.equals(b);
        }
        return a.equals(b);
    }
}

