/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncJust
extends VncVal
implements IDeref {
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncVal value;

    public VncJust(VncVal v) {
        this(v, Constants.Nil);
    }

    public VncJust(VncVal v, VncVal meta) {
        super(meta);
        this.value = v == null ? Constants.Nil : v;
    }

    public VncVal getValue() {
        return this.value;
    }

    @Override
    public VncVal deref() {
        return this.value;
    }

    @Override
    public VncJust withMeta(VncVal meta) {
        return new VncJust(this.value, meta);
    }

    @Override
    public int typeRank() {
        return 5;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value.convertToJavaObject();
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJust(o)) {
            return this.getValue().compareTo(((VncJust)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJust other = (VncJust)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean print_readably) {
        return String.format("(just %s)", this.value.toString(print_readably));
    }
}

