/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Destructuring {
    private static final VncKeyword KEYWORD_AS = new VncKeyword(":as");
    private static final VncKeyword KEYWORD_OR = new VncKeyword(":or");
    private static final VncKeyword KEYWORD_KEYS = new VncKeyword(":keys");
    private static final VncKeyword KEYWORD_SYMS = new VncKeyword(":syms");
    private static final VncKeyword KEYWORD_STRS = new VncKeyword(":strs");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Binding> destructure(VncVal symVal, VncVal bindVal) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (Types.isVncSymbol(symVal)) {
            bindings.add(new Binding((VncSymbol)symVal, bindVal));
            return bindings;
        } else if (Types.isVncSequence(symVal)) {
            if (Types.isVncSequence(bindVal)) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, (VncSequence)bindVal, bindings);
                return bindings;
            } else if (Types.isVncString(bindVal)) {
                Destructuring.sequential_string_destructure((VncSequence)symVal, (VncString)bindVal, bindings);
                return bindings;
            } else if (Types.isVncMapEntry(bindVal)) {
                Destructuring.sequential_list_destructure((VncSequence)symVal, ((VncMapEntry)bindVal).toVector(), bindings);
                return bindings;
            } else {
                if (bindVal != Constants.Nil) throw new VncException(String.format("Invalid sequential destructuring bind value type %s. Expected list, vector, or string. %s", Types.getType(bindVal), ErrorMessage.buildErrLocation(bindVal)));
                Destructuring.sequential_list_destructure((VncSequence)symVal, VncTinyList.empty(), bindings);
            }
            return bindings;
        } else {
            if (!Types.isVncMap(symVal)) throw new VncException(String.format("Invalid destructuring sym value type %s. Expected symbol. %s", Types.getType(symVal), ErrorMessage.buildErrLocation(symVal)));
            if (Types.isVncMap(bindVal)) {
                Destructuring.associative_map_destructure((VncMap)symVal, (VncMap)bindVal, bindings);
                return bindings;
            } else {
                if (Types.isVncVector(bindVal)) {
                    throw new VncException(String.format("Associative destructuring on vector is not yet implemented", Types.getType(bindVal), ErrorMessage.buildErrLocation(bindVal)));
                }
                if (bindVal != Constants.Nil) throw new VncException(String.format("Invalid associative destructuring bind value type %s. Expected map. %s", Types.getType(bindVal), ErrorMessage.buildErrLocation(bindVal)));
                Destructuring.associative_map_destructure((VncMap)symVal, new VncHashMap(), bindings);
            }
        }
        return bindings;
    }

    private static void sequential_list_destructure(VncSequence symVal, VncSequence bindVal, List<Binding> bindings) {
        List<VncVal> symbols = symVal.getList();
        List<VncVal> values = bindVal.getList();
        int symIdx = 0;
        int valIdx = 0;
        while (symIdx < symbols.size()) {
            VncVal val;
            VncVal syms;
            VncVal sVal = symbols.get(symIdx);
            if (Types.isVncSymbol(sVal)) {
                VncVal val2;
                VncSymbol sym;
                String symName = ((VncSymbol)sVal).getName();
                if (symName.equals("_")) {
                    ++symIdx;
                    ++valIdx;
                    continue;
                }
                if (symName.equals("&")) {
                    sym = (VncSymbol)symbols.get(symIdx + 1);
                    val2 = valIdx < values.size() ? bindVal.slice(valIdx) : VncTinyList.empty();
                    bindings.add(new Binding(sym, val2));
                    symIdx += 2;
                    valIdx = values.size();
                    continue;
                }
                sym = (VncSymbol)sVal;
                val2 = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
                bindings.add(new Binding(sym, val2));
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (Destructuring.isAsKeyword(sVal)) {
                VncSymbol sym = (VncSymbol)symbols.get(symIdx + 1);
                bindings.add(new Binding(sym, bindVal));
                symIdx += 2;
                continue;
            }
            if (Types.isVncSequence(sVal)) {
                syms = sVal;
                val = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
                bindings.addAll(Destructuring.destructure(syms, val));
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (!Types.isVncMap(sVal)) continue;
            syms = (VncMap)sVal;
            val = valIdx < values.size() ? values.get(valIdx) : new VncHashMap();
            Destructuring.associative_map_destructure((VncMap)syms, (VncMap)val, bindings);
            ++symIdx;
            ++valIdx;
        }
    }

    private static void sequential_string_destructure(VncSequence symVal, VncString bindVal, List<Binding> bindings) {
        List<VncVal> symbols = symVal.getList();
        List<VncVal> values = bindVal.toVncList().getList();
        int symIdx = 0;
        int valIdx = 0;
        while (symIdx < symbols.size()) {
            VncVal sVal = symbols.get(symIdx);
            if (Types.isVncSymbol(sVal)) {
                VncVal val;
                VncSymbol sym;
                String symName = ((VncSymbol)sVal).getName();
                if (symName.equals("_")) {
                    ++symIdx;
                    ++valIdx;
                    continue;
                }
                if (symName.equals("&")) {
                    sym = (VncSymbol)symbols.get(symIdx + 1);
                    val = valIdx < values.size() ? bindVal.toVncList().slice(valIdx) : VncTinyList.empty();
                    bindings.add(new Binding(sym, val));
                    symIdx += 2;
                    valIdx = values.size();
                    continue;
                }
                sym = (VncSymbol)sVal;
                val = valIdx < values.size() ? values.get(valIdx) : Constants.Nil;
                bindings.add(new Binding(sym, val));
                ++symIdx;
                ++valIdx;
                continue;
            }
            if (Destructuring.isAsKeyword(sVal)) {
                VncSymbol sym = (VncSymbol)symbols.get(symIdx + 1);
                bindings.add(new Binding(sym, bindVal));
                symIdx += 2;
                continue;
            }
            throw new VncException(String.format("Invalid sequential string destructuring symbol type %s. %s", Types.getType(sVal), ErrorMessage.buildErrLocation(sVal)));
        }
    }

    private static void associative_map_destructure(VncMap symVal, VncMap bindVal, List<Binding> bindings) {
        ArrayList<Binding> local_bindings = new ArrayList<Binding>();
        List<VncVal> symbols = Destructuring.sortAssociativeNames(symVal.keys().getList());
        for (int ii = 0; ii < symbols.size(); ++ii) {
            VncVal v;
            VncVal symbol;
            VncVal symValName = symbols.get(ii);
            if (symValName.equals(KEYWORD_KEYS)) {
                symbol = symVal.get(KEYWORD_KEYS);
                if (Types.isVncVector(symbol)) {
                    for (VncVal vncVal : ((VncVector)symbol).getList()) {
                        VncSymbol s = (VncSymbol)vncVal;
                        v = bindVal.get(new VncKeyword(s.getName()));
                        local_bindings.add(new Binding(s, v));
                    }
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :keys symbol type %s. Expected vector. %s", Types.getType(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KEYWORD_SYMS)) {
                symbol = symVal.get(KEYWORD_SYMS);
                if (Types.isVncVector(symbol)) {
                    for (VncVal vncVal : ((VncVector)symbol).getList()) {
                        VncSymbol s = (VncSymbol)vncVal;
                        v = bindVal.get(s);
                        local_bindings.add(new Binding(s, v));
                    }
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :syms symbol type %s. Expected vector. %s", Types.getType(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KEYWORD_STRS)) {
                symbol = symVal.get(KEYWORD_STRS);
                if (Types.isVncVector(symbol)) {
                    for (VncVal vncVal : ((VncVector)symbol).getList()) {
                        VncSymbol s = (VncSymbol)vncVal;
                        v = bindVal.get(new VncString(s.getName()));
                        local_bindings.add(new Binding(s, v));
                    }
                    continue;
                }
                throw new VncException(String.format("Invalid associative destructuring with :strs symbol type %s. Expected vector. %s", Types.getType(symbol), ErrorMessage.buildErrLocation(symbol)));
            }
            if (symValName.equals(KEYWORD_OR)) {
                symbol = symVal.get(KEYWORD_OR);
                if (symbol == Constants.Nil || !Types.isVncMap(symbol)) continue;
                for (Map.Entry entry : ((VncMap)symbol).getMap().entrySet()) {
                    int bIdx = Binding.getBindingIndex((VncSymbol)entry.getKey(), local_bindings);
                    if (bIdx == -1) {
                        local_bindings.add(new Binding((VncSymbol)entry.getKey(), (VncVal)entry.getValue()));
                        continue;
                    }
                    Binding b = (Binding)local_bindings.get(bIdx);
                    if (b.val != Constants.Nil) continue;
                    local_bindings.set(bIdx, new Binding((VncSymbol)entry.getKey(), (VncVal)entry.getValue()));
                }
                continue;
            }
            if (symValName.equals(KEYWORD_AS)) {
                symbol = symVal.get(KEYWORD_AS);
                if (symbol == Constants.Nil || !Types.isVncSymbol(symbol)) continue;
                local_bindings.add(new Binding((VncSymbol)symbol, bindVal));
                continue;
            }
            if (Types.isVncMap(symValName)) {
                VncVal v2 = bindVal.get(symVal.get(symValName));
                Destructuring.associative_map_destructure((VncMap)symValName, v2 == Constants.Nil ? new VncHashMap() : (VncMap)v2, local_bindings);
                continue;
            }
            if (Types.isVncVector(symValName)) {
                Destructuring.sequential_list_destructure((VncVector)symValName, (VncSequence)bindVal.get(symVal.get(symValName)), local_bindings);
                continue;
            }
            if (Types.isVncList(symValName)) {
                Destructuring.sequential_list_destructure((VncList)symValName, (VncSequence)bindVal.get(symVal.get(symValName)), local_bindings);
                continue;
            }
            if (Types.isVncSymbol(symValName)) {
                VncVal s = symVal.get(symValName);
                VncVal v3 = bindVal.get(s);
                local_bindings.add(new Binding((VncSymbol)symValName, v3));
                continue;
            }
            throw new VncException(String.format("Invalid associative destructuring name type %s. %s", Types.getType(symValName), ErrorMessage.buildErrLocation(symValName)));
        }
        bindings.addAll(local_bindings);
    }

    private static boolean isAsKeyword(VncVal val) {
        return Types.isVncKeyword(val) && ((VncKeyword)val).equals(KEYWORD_AS);
    }

    private static List<VncVal> sortAssociativeNames(List<VncVal> names) {
        ArrayList<VncVal> sorted = new ArrayList<VncVal>();
        for (VncVal n : names) {
            if (!Destructuring.is_KEYS_SYMS_STRS(n)) continue;
            sorted.add(n);
        }
        for (VncVal n : names) {
            if (n == Constants.Nil || Destructuring.is_KEYS_SYMS_STRS(n) || Destructuring.is_AS_OR(n)) continue;
            sorted.add(n);
        }
        for (VncVal n : names) {
            if (!Destructuring.is_AS_OR(n)) continue;
            sorted.add(n);
        }
        return sorted;
    }

    private static boolean is_KEYS_SYMS_STRS(VncVal n) {
        return n.equals(KEYWORD_KEYS) || n.equals(KEYWORD_SYMS) || n.equals(KEYWORD_STRS);
    }

    private static boolean is_AS_OR(VncVal n) {
        return n.equals(KEYWORD_AS) || n.equals(KEYWORD_OR);
    }
}

