/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.XmlAttributesWrapper;
import com.github.jlangch.venice.util.IXMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private final IXMLHandler h;

    public XMLHandler(IXMLHandler h) {
        this.h = h;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.h.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.h.startDocument();
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.h.endDocument();
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.h.startPrefixMapping(prefix, uri);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        try {
            this.h.endPrefixMapping(prefix);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.h.startElement(uri, localName, qName, new XmlAttributesWrapper(attrs));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.h.endElement(uri, localName, qName);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.h.characters(new String(ch).substring(start, start + length));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.h.ignorableWhitespace(new String(ch).substring(start, start + length));
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.h.processingInstruction(target, data);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.h.skippedEntity(name);
        }
        catch (VncException ex) {
            throw new SAXException(ex.printVeniceStackTraceToString(), ex);
        }
    }
}

