/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.SpecialForms;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.sandbox.SandboxMaxExecutionTimeChecker;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.CatchBlock;
import com.github.jlangch.venice.impl.util.Doc;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private static final VncSymbol LOADED_MODULES_SYMBOL = new VncSymbol("*loaded-modules*");
    private static final VncSymbol LOADED_FILES_SYMBOL = new VncSymbol("*loaded-files*");
    private static final VncSymbol VERSION_SYMBOL = new VncSymbol("*version*");
    private static final VncSymbol NEWLINE_SYMBOL = new VncSymbol("*newline*");
    private static final VncSymbol LOAD_PATH_SYMBOL = new VncSymbol("*load-path*");
    private static final VncSymbol RUN_MODE_SYMBOL = new VncSymbol("*run-mode*");
    private static final VncSymbol MACRO_EXPAND_ON_LOAD_SYMBOL = new VncSymbol("*macroexpand-on-load*");
    private static final VncString VERSION = new VncString(Version.VERSION);
    private static final VncString NEWLINE = new VncString(System.lineSeparator());
    private static final Var VERSION_VAR = new Var(VERSION_SYMBOL, VERSION, false);
    private static final Var NEWLINE_VAR = new Var(NEWLINE_SYMBOL, NEWLINE, false);
    private static final Var DISABLED_MACRO_EXPAND_ON_LOAD_SYMBOL_VAR = new Var(MACRO_EXPAND_ON_LOAD_SYMBOL, Constants.False, true);
    private final IInterceptor interceptor;
    private final List<String> loadPaths;
    private final SandboxMaxExecutionTimeChecker sandboxMaxExecutionTimeChecker;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private final AtomicBoolean sealedSystemNS = new AtomicBoolean(false);

    public VeniceInterpreter() {
        this(new MeterRegistry(false), new AcceptAllInterceptor(), null);
    }

    public VeniceInterpreter(IInterceptor interceptor, List<String> loadPaths) {
        this(new MeterRegistry(false), interceptor, loadPaths);
    }

    public VeniceInterpreter(MeterRegistry perfmeter, IInterceptor interceptor, List<String> loadPaths) {
        this.sandboxMaxExecutionTimeChecker = new SandboxMaxExecutionTimeChecker();
        this.meterRegistry = perfmeter;
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
    }

    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    public VncVal READ(String script, String filename) {
        long nanos = System.nanoTime();
        VncVal val = Reader.read_str(script, filename);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal EVAL(VncVal ast, Env env) {
        long nanos = System.nanoTime();
        VncVal val = this.evaluate(ast, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal MACROEXPAND(VncVal ast, Env env, boolean macroexpand) {
        VncFunction macroexpandFn;
        if (macroexpand && (macroexpandFn = (VncFunction)env.getGlobalOrNull(new VncSymbol("core/macroexpand-all"))) != null) {
            return macroexpandFn.apply(VncList.of(ast));
        }
        return ast;
    }

    public VncVal RE(String script, String name, Env env) {
        return this.EVAL(this.READ(script, name), env);
    }

    public VncVal RE(String script, String name, Env env, boolean macroexpand) {
        VncVal ast = this.READ(script, name);
        if (macroexpand) {
            ast = this.MACROEXPAND(ast, env, macroexpand);
        }
        return this.EVAL(ast, env);
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public Env createEnv(boolean macroexpandOnLoad, VncKeyword runMode) {
        return this.createEnv(null, macroexpandOnLoad, runMode);
    }

    public Env createEnv(List<String> preloadExtensionModules, boolean macroexpandOnLoad, VncKeyword runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = new VncMutableSet(ModuleLoader.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        }
        env.setGlobal(VERSION_VAR);
        env.setGlobal(NEWLINE_VAR);
        env.setGlobal(new Var(LOAD_PATH_SYMBOL, LoadPath.toVncList(this.loadPaths), false));
        env.setGlobal(new Var(RUN_MODE_SYMBOL, runMode == null ? Constants.Nil : runMode, false));
        env.setGlobal(DISABLED_MACRO_EXPAND_ON_LOAD_SYMBOL_VAR);
        env.setGlobal(new Var(LOADED_MODULES_SYMBOL, loadedModules, true));
        env.setGlobal(new Var(LOADED_FILES_SYMBOL, new VncMutableSet(), true));
        this.initNS();
        this.loadModule("core", env, loadedModules);
        if (macroexpandOnLoad) {
            env.setGlobal(new Var(MACRO_EXPAND_ON_LOAD_SYMBOL, Constants.True, true));
        }
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(ModuleLoader.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        long nanos = System.nanoTime();
        this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
        }
        loadedModules.add(new VncKeyword(module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal evaluate(VncVal orig_ast, Env env) {
        RecursionPoint recursionPoint = null;
        while (Types.isVncList(orig_ast)) {
            String a0sym;
            VncVal expanded = this.macroexpand(orig_ast, env);
            if (!Types.isVncList(expanded)) {
                return this.eval_ast(expanded, env);
            }
            VncList ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            VncVal a0 = ast.first();
            switch (a0sym = Types.isVncSymbol(a0) ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                case "do": {
                    VncList expressions = ast.rest();
                    this.eval_ast(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case "def": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, env).withMeta(((VncVal)name).getMeta());
                    env.setGlobal(new Var((VncSymbol)name, res2, true));
                    return name;
                }
                case "defonce": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, env).withMeta(((VncVal)name).getMeta());
                    env.setGlobal(new Var((VncSymbol)name, res2, false));
                    return name;
                }
                case "def-dynamic": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    Serializable val = ast.third();
                    VncVal res2 = this.evaluate((VncVal)val, env).withMeta(((VncVal)name).getMeta());
                    env.setGlobalDynamic((VncSymbol)name, res2);
                    return name;
                }
                case "defmacro": {
                    VncVal res2;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("defmacro", ast));
                    Serializable val = null;
                    try {
                        res2 = this.defmacro_(ast, env);
                        return res2;
                    }
                    catch (Throwable res2) {
                        val = res2;
                        throw res2;
                    }
                    finally {
                        if (cs3 != null) {
                            if (val != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)val).addSuppressed(throwable);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "set!": {
                    Serializable val;
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    Var globVar = env.getGlobalVarOrNull((VncSymbol)name);
                    if (globVar != null) {
                        VncVal expr = ast.third();
                        val = this.evaluate(expr, env).withMeta(((VncVal)name).getMeta());
                        if (globVar instanceof DynamicVar) {
                            env.popGlobalDynamic(globVar.getName());
                            env.pushGlobalDynamic(globVar.getName(), (VncVal)val);
                        } else {
                            env.setGlobal(new Var(globVar.getName(), (VncVal)val, globVar.isOverwritable()));
                        }
                        return val;
                    }
                    Object cs = new WithCallStack(CallFrame.fromVal((VncVal)name));
                    val = null;
                    try {
                        try {
                            throw new VncException(String.format("The global var or thread-local '%s' does not exist!", ((VncSymbol)name).getName()));
                        }
                        catch (Throwable throwable) {
                            val = throwable;
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable throwable2) {
                                    ((Throwable)val).addSuppressed(throwable2);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                        throw throwable;
                    }
                }
                case "defmulti": {
                    Object name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    VncVal dispatchFn = Types.isVncKeyword(ast.third()) ? (VncKeyword)ast.third() : (Types.isVncSymbol(ast.third()) ? Coerce.toVncFunction(env.get((VncSymbol)ast.third())) : this.fn_(Coerce.toVncList(ast.third()), env));
                    VncVal multiFn2 = new VncMultiFunction(((VncSymbol)name).getName(), (IVncFunction)((Object)dispatchFn));
                    env.setGlobal(new Var((VncSymbol)name, multiFn2, false));
                    return multiFn2;
                }
                case "defmethod": {
                    Object cs;
                    Serializable val;
                    VncSymbol multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(ast.second()));
                    VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
                    if (multiFnVal == null) {
                        cs = new WithCallStack(CallFrame.fromVal(ast));
                        val = null;
                        try {
                            try {
                                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
                            }
                            catch (Throwable throwable) {
                                val = throwable;
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (cs != null) {
                                if (val != null) {
                                    try {
                                        ((WithCallStack)cs).close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)val).addSuppressed(throwable3);
                                    }
                                } else {
                                    ((WithCallStack)cs).close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    VncVal multiFn2 = Coerce.toVncMultiFunction(multiFnVal);
                    Serializable dispatchVal = ast.third();
                    VncVector params = Coerce.toVncVector(ast.fourth());
                    if (params.size() != ((VncMultiFunction)multiFn2).getParams().size()) {
                        WithCallStack cs2 = new WithCallStack(CallFrame.fromVal(ast));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), ((VncMultiFunction)multiFn2).getParams().size()));
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (cs2 != null) {
                                if (throwable != null) {
                                    try {
                                        cs2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    cs2.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    VncVector preConditions = this.getFnPreconditions(ast.nth(4));
                    VncList body = ast.slice(preConditions == null ? 4 : 5);
                    VncFunction fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, env);
                    return ((VncMultiFunction)multiFn2).addFn((VncVal)dispatchVal, fn);
                }
                case "ns": {
                    VncSymbol ns = Coerce.toVncSymbol(ast.second());
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Namespace '" + ns.getName() + "' cannot be reopened!");
                    }
                    Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns));
                    return ns;
                }
                case "ns-remove": {
                    VncSymbol ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
                    }
                    env.removeGlobalSymbolsByNS(ns);
                    this.nsRegistry.remove(ns);
                    return Constants.Nil;
                }
                case "ns-unmap": {
                    VncSymbol ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
                    }
                    Serializable sym = Namespaces.qualifySymbol(ns, Coerce.toVncSymbol(ast.third()));
                    env.removeGlobalSymbol((VncSymbol)sym);
                    return Constants.Nil;
                }
                case "import": {
                    VncVal multiFn2;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("import", ast));
                    Serializable sym = null;
                    try {
                        ast.rest().forEach(i -> Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue()));
                        multiFn2 = Constants.Nil;
                        return multiFn2;
                    }
                    catch (Throwable multiFn2) {
                        sym = multiFn2;
                        throw multiFn2;
                    }
                    finally {
                        if (cs3 != null) {
                            if (sym != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)sym).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "imports": {
                    if (ast.size() == 1) {
                        return Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                    }
                    VncSymbol ns = Coerce.toVncSymbol(ast.second());
                    Object namespace = this.nsRegistry.get(ns);
                    if (namespace != null) {
                        return ((Namespace)namespace).getJavaImportsAsVncList();
                    }
                    Object cs = new WithCallStack(CallFrame.fromVal("imports", ast));
                    Serializable dispatchVal = null;
                    try {
                        try {
                            throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
                        }
                        catch (Throwable params) {
                            dispatchVal = params;
                            throw params;
                        }
                    }
                    catch (Throwable throwable) {
                        if (cs != null) {
                            if (dispatchVal != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable throwable7) {
                                    ((Throwable)dispatchVal).addSuppressed(throwable7);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                        throw throwable;
                    }
                }
                case "resolve": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case "var-get": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case "inspect": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return Inspector.inspect(env.get(sym));
                }
                case "macroexpand": {
                    Object cs;
                    WithCallStack cs3 = new WithCallStack(CallFrame.fromVal("macroexpand", ast));
                    Object namespace = null;
                    try {
                        cs = this.macroexpand(this.evaluate(ast.second(), env), env);
                        return cs;
                    }
                    catch (Throwable cs4) {
                        namespace = cs4;
                        throw cs4;
                    }
                    finally {
                        if (cs3 != null) {
                            if (namespace != null) {
                                try {
                                    cs3.close();
                                }
                                catch (Throwable dispatchVal) {
                                    ((Throwable)namespace).addSuppressed(dispatchVal);
                                }
                            } else {
                                cs3.close();
                            }
                        }
                    }
                }
                case "quote": {
                    return ast.second();
                }
                case "quasiquote": {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    break;
                }
                case "doc": {
                    Object name = ((VncString)CoreFunctions.name.apply(ast.rest())).getValue();
                    VncVal docVal = SpecialForms.ns.get(new VncSymbol((String)name));
                    if (docVal == null) {
                        docVal = env.get(new VncSymbol((String)name));
                    }
                    orig_ast = VncTinyList.of(new VncSymbol("println"), Doc.getDoc(docVal));
                    break;
                }
                case "eval": {
                    Serializable dispatchVal;
                    Namespace ns = Namespaces.getCurrentNamespace();
                    try {
                        dispatchVal = this.evaluate(Coerce.toVncSequence(this.eval_ast(ast.rest(), env)).last(), env);
                        return dispatchVal;
                    }
                    finally {
                        Namespaces.setCurrentNamespace(ns);
                    }
                }
                case "let": {
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    Serializable expressions = ast.slice(2);
                    for (int i2 = 0; i2 < bindings.size(); i2 += 2) {
                        VncVal sym = bindings.nth(i2);
                        VncVal val = this.evaluate(bindings.nth(i2 + 1), env);
                        env.addLocalBindings(Destructuring.destructure(sym, val));
                    }
                    if (((VncList)expressions).isEmpty()) {
                        orig_ast = Constants.Nil;
                        break;
                    }
                    this.eval_ast(((VncList)expressions).butlast(), env);
                    orig_ast = ((VncList)expressions).last();
                    break;
                }
                case "binding": {
                    return this.binding_(ast, new Env(env));
                }
                case "bound?": {
                    VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.isBound(sym) ? Constants.True : Constants.False;
                }
                case "global-vars-count": {
                    return new VncLong(env.globalsCount());
                }
                case "loop": {
                    recursionPoint = null;
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    Serializable expressions = ast.slice(2);
                    ArrayList<VncSymbol> bindingNames = new ArrayList<VncSymbol>();
                    for (int i3 = 0; i3 < bindings.size(); i3 += 2) {
                        VncVal sym = bindings.nth(i3);
                        VncVal val = this.evaluate(bindings.nth(i3 + 1), env);
                        env.setLocal((VncSymbol)sym, val);
                        bindingNames.add((VncSymbol)sym);
                    }
                    recursionPoint = new RecursionPoint(new VncList(bindingNames), (VncList)expressions, env);
                    if (((VncList)expressions).size() == 1) {
                        orig_ast = ((VncList)expressions).first();
                        break;
                    }
                    this.eval_ast(((VncList)expressions).butlast(), env);
                    orig_ast = ((VncList)expressions).last();
                    break;
                }
                case "recur": {
                    Serializable expressions;
                    Object cs;
                    if (recursionPoint == null) {
                        cs = new WithCallStack(CallFrame.fromVal("recur", ast));
                        expressions = null;
                        try {
                            try {
                                throw new VncException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable throwable) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        ((WithCallStack)cs).close();
                                    }
                                    catch (Throwable throwable8) {
                                        ((Throwable)expressions).addSuppressed(throwable8);
                                    }
                                } else {
                                    ((WithCallStack)cs).close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    Env recur_env = recursionPoint.getLoopEnv();
                    switch (ast.size()) {
                        case 2: {
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), this.evaluate(ast.second(), env));
                            break;
                        }
                        case 3: {
                            VncVal v1 = this.evaluate(ast.second(), env);
                            VncVal v2 = this.evaluate(ast.third(), env);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), v1);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(1), v2);
                            break;
                        }
                        case 4: {
                            VncVal v1_ = this.evaluate(ast.second(), env);
                            VncVal v2_ = this.evaluate(ast.third(), env);
                            VncVal v3_ = this.evaluate(ast.fourth(), env);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), v1_);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(1), v2_);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(2), v3_);
                            break;
                        }
                        default: {
                            VncList values = ast.rest();
                            VncVal[] newValues = new VncVal[values.size()];
                            for (int kk = 0; kk < values.size(); ++kk) {
                                newValues[kk++] = this.evaluate(values.nth(kk), env);
                            }
                            for (int ii = 0; ii < recursionPoint.getLoopBindingNamesCount(); ++ii) {
                                recur_env.setLocal(recursionPoint.getLoopBindingName(ii), newValues[ii]);
                            }
                        }
                    }
                    expressions = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    if (((VncList)expressions).size() > 1) {
                        this.eval_ast(((VncList)expressions).butlast(), env);
                    }
                    orig_ast = ((VncList)expressions).last();
                    break;
                }
                case "try": {
                    Object cs = new WithCallStack(CallFrame.fromVal("try", ast));
                    Serializable expressions = null;
                    try {
                        VncVal v2 = this.try_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable v1_) {
                                    ((Throwable)expressions).addSuppressed(v1_);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                    }
                }
                case "try-with": {
                    Object cs = new WithCallStack(CallFrame.fromVal("try-with", ast));
                    Serializable expressions = null;
                    try {
                        VncVal v2 = this.try_with_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    ((WithCallStack)cs).close();
                                }
                                catch (Throwable v1_) {
                                    ((Throwable)expressions).addSuppressed(v1_);
                                }
                            } else {
                                ((WithCallStack)cs).close();
                            }
                        }
                    }
                }
                case "dorun": {
                    return this.dorun_(ast, env);
                }
                case "dobench": {
                    return this.dobench_(ast, env);
                }
                case "if": {
                    VncVal cond = this.evaluate(ast.second(), env);
                    if (cond == Constants.False || cond == Constants.Nil) {
                        if (ast.size() > 3) {
                            orig_ast = ast.nth(3);
                            break;
                        }
                        return Constants.Nil;
                    }
                    orig_ast = ast.nth(2);
                    break;
                }
                case "fn": {
                    return this.fn_(ast, env);
                }
                case "prof": {
                    return this.prof_(ast, env);
                }
                case "locking": {
                    return this.locking_(ast, env);
                }
                default: {
                    VncList el = (VncList)this.eval_ast(ast, env);
                    VncVal elFirst = el.first();
                    VncList elArgs = el.rest();
                    if (Types.isVncFunction(elFirst)) {
                        VncFunction fn = (VncFunction)elFirst;
                        String fnName = fn.getQualifiedName();
                        long nanos = System.nanoTime();
                        this.interceptor.validateVeniceFunction(fnName);
                        this.checkInterrupted(fnName);
                        if (this.sandboxMaxExecutionTimeChecker.enabled) {
                            this.sandboxMaxExecutionTimeChecker.check();
                        }
                        CallStack callStack = ThreadLocalMap.getCallStack();
                        CallFrame callFrame = CallFrame.fromFunction(fn, a0);
                        try {
                            callStack.push(callFrame);
                            VncVal vncVal = fn.apply(elArgs);
                            return vncVal;
                        }
                        finally {
                            callStack.pop();
                            this.checkInterrupted(fnName);
                            if (this.sandboxMaxExecutionTimeChecker.enabled) {
                                this.sandboxMaxExecutionTimeChecker.check();
                            }
                            if (this.meterRegistry.enabled) {
                                this.meterRegistry.record(fn.getQualifiedName(), System.nanoTime() - nanos);
                            }
                        }
                    }
                    if (Types.isIVncFunction(elFirst)) {
                        return ((IVncFunction)((Object)elFirst)).apply(elArgs);
                    }
                    WithCallStack cs = new WithCallStack(CallFrame.fromVal(ast));
                    Throwable throwable = null;
                    try {
                        try {
                            throw new VncException(String.format("Not a function or keyword/map used as function: '%s'", this.PRINT(elFirst)));
                        }
                        catch (Throwable throwable9) {
                            throwable = throwable9;
                            throw throwable9;
                        }
                    }
                    catch (Throwable throwable10) {
                        if (cs != null) {
                            if (throwable != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable.addSuppressed(throwable11);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable10;
                    }
                }
            }
        }
        return this.eval_ast(orig_ast, env);
    }

    private VncVal eval_ast(VncVal ast, Env env) {
        if (Types.isVncSymbol(ast)) {
            return env.get((VncSymbol)ast);
        }
        if (ast.isVncCollection()) {
            if (Types.isVncSequence(ast)) {
                VncSequence seq = (VncSequence)ast;
                switch (seq.size()) {
                    case 0: {
                        return seq;
                    }
                    case 1: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env));
                    }
                    case 2: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
                    }
                    case 3: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env));
                    }
                    case 4: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env), this.evaluate(seq.fourth(), env));
                    }
                }
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : seq.getList()) {
                    vals.add(this.evaluate(v, env));
                }
                return seq.withValues(vals);
            }
            if (Types.isVncMap(ast)) {
                VncMap map = (VncMap)ast;
                HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>();
                for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                    vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
                }
                return map.withValues(vals);
            }
            if (Types.isVncSet(ast)) {
                VncSet set = (VncSet)ast;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : set.getList()) {
                    vals.add(this.evaluate(v, env));
                }
                return set.withValues(vals);
            }
            return ast;
        }
        return ast;
    }

    private VncVal macroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = System.nanoTime();
        VncVal ast_ = ast;
        boolean expanded = false;
        while (Types.isVncSymbol(a0 = ((VncList)ast_).first()) && Types.isVncMacro(fn = env.getGlobalOrNull((VncSymbol)a0))) {
            VncFunction macro = (VncFunction)fn;
            this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            expanded = true;
            if (Types.isVncList(ast_ = macro.apply(((VncList)ast_).rest()))) continue;
        }
        if (expanded && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private static boolean is_pair(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return VncTinyList.of(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncSequence(ast).first();
        if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
            return ((VncSequence)ast).second();
        }
        if (VeniceInterpreter.is_pair(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return VncTinyList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncTinyList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        int argPos = 1;
        VncSymbol macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.nth(argPos++), env));
        VncVal meta = macroName.getMeta();
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String name = macroName.getName();
        String ns = Namespaces.getNamespace(macroName.getName());
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, Constants.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            int n = ++argPos;
            ++argPos;
            VncVal body = ast.nth(n);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, VncTinyList.of(body), null, env);
            macroFn.setMacro();
            macroFn.setNamespace(ns);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, env));
        });
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns).withMeta(meta);
        macroFn.setMacro();
        macroFn.setNamespace(ns);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dorun", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dorun requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        long count = Coerce.toVncLong(ast.second()).getValue();
        if (count <= 0L) {
            return Constants.Nil;
        }
        VncVal expr = ast.third();
        try {
            VncVal first = this.evaluate(expr, env);
            int ii = 1;
            while ((long)ii < count) {
                VncVal result = this.evaluate(expr, env);
                this.checkInterrupted("dorun");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncVal vncVal = first;
            return vncVal;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dobench", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dobench requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        try {
            long count = Coerce.toVncLong(ast.second()).getValue();
            VncVal expr = ast.third();
            ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
            int ii = 0;
            while ((long)ii < count) {
                long start = System.nanoTime();
                VncVal result = this.evaluate(expr, env);
                long end = System.nanoTime();
                elapsed.add(new VncLong(end - start));
                this.checkInterrupted("dobench");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncList vncList = new VncList(elapsed);
            return vncList;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(VncList ast, Env env) {
        VncVal mutex;
        if (ast.size() < 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("locking", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("locking requires a lockee and one or more expressions to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        VncVal vncVal = mutex = this.evaluate(ast.second(), env);
        synchronized (vncVal) {
            return this.evaluateBody(ast.slice(2), env);
        }
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSymbol name;
        int argPos;
        if (Types.isVncSymbol(ast.second())) {
            argPos = 2;
            name = (VncSymbol)ast.second();
        } else {
            argPos = 1;
            name = new VncSymbol(VncFunction.createAnonymousFuncName());
        }
        VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
        ReservedSymbols.validateNotReservedSymbol(fnName);
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        if (Types.isVncVector(paramsOrSig)) {
            VncVector preConditions;
            VncVector params = (VncVector)paramsOrSig;
            if ((preConditions = this.getFnPreconditions(ast.nth(++argPos))) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(fnName.getName(), params, body, preConditions, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preConditions = this.getFnPreconditions(sig.nth(pos));
            if (preConditions != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(fnName.getName(), params, body, preConditions, env));
        });
        return new VncMultiArityFunction(fnName.getName(), fns);
    }

    private VncVal prof_(VncList ast, Env env) {
        if (Types.isVncKeyword(ast.second())) {
            VncKeyword cmd = (VncKeyword)ast.second();
            switch (cmd.getValue()) {
                case "on": 
                case "enable": {
                    this.meterRegistry.enable();
                    return new VncKeyword("on");
                }
                case "off": 
                case "disable": {
                    this.meterRegistry.disable();
                    return new VncKeyword("off");
                }
                case "status": {
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear": {
                    this.meterRegistry.reset();
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear-all-but": {
                    this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "data": {
                    return this.meterRegistry.getVncTimerData();
                }
                case "data-formatted": {
                    String title = ast.size() == 3 ? Coerce.toVncString(ast.third()).getValue() : "Metrics";
                    return new VncString(this.meterRegistry.getTimerDataFormatted(title));
                }
            }
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal("prof", ast));
        Object object = null;
        try {
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (cs != null) {
                if (object != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            for (Binding b : Destructuring.destructure(sym, val)) {
                vars.add(new Var(b.sym, b.val));
            }
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            this.eval_ast(expressions.butlast(), env);
            VncVal vncVal = this.evaluate(expressions.last(), env);
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.evaluateBody(this.getTryBody(ast), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
            if (catchBlock == null) {
                throw th;
            }
            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), env);
            return vncVal;
        }
        finally {
            VncList finallyBlock = this.findFirstFinallyBlock(ast);
            if (finallyBlock != null) {
                this.eval_ast(finallyBlock.rest(), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block12: {
            VncSequence bindings = Coerce.toVncSequence(ast.second());
            ArrayList<Binding> boundResources = new ArrayList<Binding>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                env.setLocal((VncSymbol)sym, val);
                boundResources.add(new Binding((VncSymbol)sym, val));
            }
            result = Constants.Nil;
            try {
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block12;
                    this.eval_ast(finallyBlock.rest(), env);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block13: {
                        try {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env);
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock == null) break block13;
                            this.eval_ast(finallyBlock.rest(), env);
                        }
                        catch (Throwable throwable) {
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock != null) {
                                this.eval_ast(finallyBlock.rest(), env);
                            }
                            throw throwable;
                        }
                    }
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        VncVal resource = b.val;
                        if (Types.isVncJavaObject(resource)) {
                            Object r = ((VncJavaObject)resource).getDelegate();
                            if (r instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                            if (r instanceof Closeable) {
                                try {
                                    ((Closeable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                        }
                    });
                    return vncVal;
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.val;
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = ast.rest().getList().iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return new VncList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        return new VncFunction(name, params){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(env);
                Namespace curr_ns = Namespaces.getCurrentNamespace();
                try {
                    if (!name.equals("macroexpand-all")) {
                        Namespaces.setCurrentNamespace(ns);
                    }
                    localEnv.addLocalBindings(Destructuring.destructure(params, args));
                    VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                    VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv);
                    return vncVal;
                }
                finally {
                    Namespaces.setCurrentNamespace(curr_ns);
                }
            }

            @Override
            public VncVal getBody() {
                return body;
            }
        };
    }

    private VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? ((VncSequence)result).first() == Constants.True : result == Constants.True;
    }

    private void validateFnPreconditions(String fnName, VncVector preConditions, Env env) {
        if (preConditions != null && !preConditions.isEmpty()) {
            Env local = new Env(env);
            for (VncVal v : preConditions.getList()) {
                if (this.isFnConditionTrue(this.evaluate(v, local))) continue;
                WithCallStack cs = new WithCallStack(CallFrame.fromVal(fnName, v));
                Throwable throwable = null;
                try {
                    try {
                        throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncTinyList.of(v))).getValue()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private VncVal evaluateBody(VncList body, Env env) {
        if (body.isEmpty()) {
            return Constants.Nil;
        }
        if (body.size() == 1) {
            return this.evaluate(body.first(), env);
        }
        if (body.size() == 2) {
            this.evaluate(body.first(), env);
            return this.evaluate(body.last(), env);
        }
        this.eval_ast(body.butlast(), env);
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String fnName) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while processing function " + fnName);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (Namespaces.isQualified(sym)) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), Namespaces.getNamespace(sym.getName())));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        return new VncSymbol(Namespaces.isCoreNS(ns) ? sym.getName() : ns.getName() + "/" + sym.getName(), MetaUtil.setNamespace(sym.getMeta(), ns.getName()));
    }
}

