/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Consumer;
import org.repackage.org.jline.reader.EndOfFileException;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;
import org.repackage.org.jline.utils.OSUtils;

public class CustomREPL {
    private static final String DEFAULT_PROMPT_PRIMARY = "venice> ";
    private static final String DEFAULT_PROMPT_SECONDARY = "      | ";
    private final List<String> loadPaths;
    private final File app;
    private String prompt = "venice> ";
    private String secondaryPrompt = "      | ";
    private Consumer<String> cmdHandler;
    private ReplConfig config;
    private IInterceptor interceptor;
    private boolean macroexpand = false;

    public CustomREPL(IInterceptor interceptor, List<String> loadPaths, File app) {
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
        this.app = app;
    }

    public void run(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        try {
            System.out.println("Venice custom REPL: V" + Venice.getVersion());
            this.config = ReplConfig.load(cli);
            this.repl(cli);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setHandler(Consumer<String> handler) {
        this.cmdHandler = handler;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.secondaryPrompt = "";
    }

    public void setPrompt(String prompt, String secondaryPrompt) {
        this.prompt = prompt;
        this.secondaryPrompt = secondaryPrompt;
    }

    private void repl(CommandLineArgs cli) throws Exception {
        if (OSUtils.IS_WINDOWS) {
            try {
                Class.forName("org.fusesource.jansi.Ansi.class", false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                System.out.print("--------------------------------------------------------------------\nThe Venice REPL requires the jansi library on Windows.              \nPlease download the jar artifact 'org.fusesource.jansi:jansi:1.18'  \nfrom a Maven repo and put it on the classpath.                      \n--------------------------------------------------------------------\n");
            }
        }
        this.setPrompt(this.config.getPrompt(), this.config.getSecondaryPrompt());
        Thread mainThread = Thread.currentThread();
        Terminal terminal = OSUtils.IS_WINDOWS ? TerminalBuilder.builder().streams(System.in, System.out).system(true).jansi(true).build() : TerminalBuilder.builder().streams(System.in, System.out).system(true).encoding("UTF-8").build();
        terminal.handle(Terminal.Signal.INT, signal -> mainThread.interrupt());
        PrintStream ps_out = this.createPrintStream("stdout", terminal);
        PrintStream ps_err = this.createPrintStream("stderr", terminal);
        TerminalPrinter printer = new TerminalPrinter(this.config, terminal, false);
        VeniceInterpreter venice = new VeniceInterpreter(this.interceptor, this.loadPaths);
        Env env = this.loadEnv(venice, cli, ps_out, ps_err);
        try {
            printer.println("stdout", "loading file \"" + this.app.getPath() + "\"");
            venice.RE("(load-file \"" + this.app.getPath() + "\")", "user", env);
        }
        catch (Exception ex) {
            printer.printex("error", ex);
        }
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Venice").terminal(terminal).history(history).variable("secondary-prompt-pattern", this.secondaryPrompt).build();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        while (true) {
            resultHistory.mergeToEnv(env);
            try {
                Thread.interrupted();
                String line = reader.readLine(this.prompt, null, (MaskingCallback)null, null);
                if (line == null) continue;
                this.cmdHandler.accept(line);
                continue;
            }
            catch (UserInterruptException ex) {
                Thread.interrupted();
                printer.println("interrupt", " ! interrupted ! ");
                Thread.sleep(1000L);
            }
            catch (EofException | EndOfFileException ex) {
            }
            catch (Exception ex) {
                printer.printex("error", ex);
                continue;
            }
            break;
        }
    }

    private Env loadEnv(VeniceInterpreter venice, CommandLineArgs cli, PrintStream ps_out, PrintStream ps_err) {
        return venice.createEnv(this.macroexpand, new VncKeyword("repl")).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false)).setGlobal(new Var(new VncSymbol("*REPL*"), new VncJavaObject(this), false)).setStdoutPrintStream(ps_out).setStderrPrintStream(ps_err);
    }

    private PrintStream createPrintStream(String context, Terminal terminal) {
        return new ReplPrintStream(terminal, this.config.getColor(context));
    }
}

