/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.nanojson.JsonObject;
import com.github.jlangch.venice.nanojson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplConfig {
    public static final String ANSI_RESET = "\u001b[0m";
    private static final String DEFAULT_PROMPT = "venice> ";
    private static final String DEFAULT_SECONDARY_PROMPT = "| ";
    private static final String DEFAULT_RESULT_PREFIX = "=> ";
    private static final List<String> COLOR_NAMES = Arrays.asList("result", "stdout", "stderr", "error", "system", "interrupt", "prompt");
    private final Map<String, String> config;

    private ReplConfig(Map<String, String> config) {
        this.config = config;
    }

    public static ReplConfig load(CommandLineArgs cli) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("colors.mode", ReplConfig.getColorMode(cli));
        String file = cli.switchValue("-load-file");
        if (file != null) {
            config.put("load.file", file);
        }
        try {
            JsonObject jsonObj = ReplConfig.loadJsonConfig();
            config.put("prompt", (String)jsonObj.get("prompt"));
            config.put("secondary-prompt", (String)jsonObj.get("secondary-prompt"));
            config.put("result-prefix", (String)jsonObj.get("result-prefix"));
            JsonObject colObj = (JsonObject)jsonObj.get("colors");
            if (colObj != null) {
                for (String cname : COLOR_NAMES) {
                    config.put("colors." + cname, StringUtil.emptyToNull((String)colObj.get(cname)));
                }
            }
            if ((colObj = (JsonObject)jsonObj.get("colors-darkmode")) != null) {
                for (String cname : COLOR_NAMES) {
                    config.put("colors-darkmode." + cname, StringUtil.emptyToNull((String)colObj.get(cname)));
                }
            }
            return new ReplConfig(config);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse REPL json config file", ex);
        }
    }

    public String getColor(String key) {
        switch (this.config.get("colors.mode")) {
            case "light": {
                return this.get("colors." + key);
            }
            case "dark": {
                return this.get("colors-darkmode." + key);
            }
        }
        return null;
    }

    public String get(String key) {
        return StringUtil.emptyToNull(this.config.get(key));
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        return val == null ? defaultValue : val;
    }

    public String getLoadFile() {
        return this.config.get("load.file");
    }

    public String getPrompt() {
        String prompt = this.getOrDefault("prompt", DEFAULT_PROMPT);
        return this.getColor("prompt") == null ? prompt : this.getColor("prompt") + prompt + ANSI_RESET;
    }

    public String getSecondaryPrompt() {
        String prompt = this.getOrDefault("secondary-prompt", DEFAULT_SECONDARY_PROMPT);
        return this.getColor("secondary-prompt") == null ? prompt : this.getColor("secondary-prompt") + prompt + ANSI_RESET;
    }

    public String getResultPrefix() {
        return this.getOrDefault("result-prefix", DEFAULT_RESULT_PREFIX);
    }

    public static String getRawClasspathConfig() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "repl.json").getResourceAsString("UTF-8");
    }

    public static String getRawClasspathLauncherName() {
        return System.getProperty("os.name").startsWith("Windows") ? "repl.bat" : "repl.sh";
    }

    public static String getRawClasspathLauncher() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + ReplConfig.getRawClasspathLauncherName()).getResourceAsString("UTF-8");
    }

    private static JsonObject loadJsonConfig() throws Exception {
        File fileJson = new File("repl.json");
        if (fileJson.isFile()) {
            System.out.println("Loading REPL config from " + fileJson + "...");
            try (FileReader reader = new FileReader(fileJson);){
                JsonObject jsonObject = JsonParser.object().from(reader);
                return jsonObject;
            }
        }
        return JsonParser.object().from(ReplConfig.getRawClasspathConfig());
    }

    private static String getColorMode(CommandLineArgs cli) {
        if (cli.switchPresent("-colors")) {
            return "light";
        }
        if (cli.switchPresent("-colors-lightmode")) {
            return "light";
        }
        if (cli.switchPresent("-colors-darkmode")) {
            return "dark";
        }
        return "none";
    }
}

