/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.util;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableList;
import com.github.jlangch.venice.impl.types.collections.VncMutableMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncQueue;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncSortedSet;
import com.github.jlangch.venice.impl.types.collections.VncStack;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;

public class Coerce {
    public static IDeref toIDeref(Object val) {
        if (val == null || Types.isIDeref(val)) {
            return (IDeref)val;
        }
        if (Types.isVncVal(val)) {
            throw new VncException(String.format("Cannot coerce value of type %s to IDeref. %s", Types.getType((VncVal)val), ErrorMessage.buildErrLocation((VncVal)val)));
        }
        throw new VncException(String.format("Cannot coerce value of type %s to IDeref. %s", val.getClass()));
    }

    public static VncAtom toVncAtom(VncVal val) {
        if (val == null || Types.isVncAtom(val)) {
            return (VncAtom)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to atom. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncVolatile toVncVolatile(VncVal val) {
        if (val == null || Types.isVncVolatile(val)) {
            return (VncVolatile)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to volatile. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncThreadLocal toVncThreadLocal(VncVal val) {
        if (val == null || Types.isVncThreadLocal(val)) {
            return (VncThreadLocal)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to thread-local. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncKeyword toVncKeyword(VncVal val) {
        if (val == null || Types.isVncKeyword(val)) {
            return (VncKeyword)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to keyword. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncSymbol toVncSymbol(VncVal val) {
        if (val == null || Types.isVncSymbol(val)) {
            return (VncSymbol)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to symbol. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static IVncFunction toIVncFunction(VncVal val) {
        if (val == null || Types.isIVncFunction(val)) {
            return (IVncFunction)((Object)val);
        }
        throw new VncException(String.format("Cannot coerce value of type %s to function. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncFunction toVncFunction(VncVal val) {
        if (val == null || Types.isVncFunction(val)) {
            return (VncFunction)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to function. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncMultiFunction toVncMultiFunction(VncVal val) {
        if (val == null || Types.isVncMultiFunction(val)) {
            return (VncMultiFunction)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to multi function. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncString toVncString(VncVal val) {
        if (val == null || Types.isVncString(val)) {
            return (VncString)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to string. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncChar toVncChar(VncVal val) {
        if (val == null || Types.isVncChar(val)) {
            return (VncChar)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to char. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncConstant toVncBoolean(VncVal val) {
        if (val == null || Types.isVncBoolean(val)) {
            return (VncConstant)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to boolean. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncInteger toVncInteger(VncVal val) {
        if (val == null || Types.isVncInteger(val)) {
            return (VncInteger)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to int. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncLong toVncLong(VncVal val) {
        if (val == null || Types.isVncLong(val)) {
            return (VncLong)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to long. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncDouble toVncDouble(VncVal val) {
        if (val == null || Types.isVncDouble(val)) {
            return (VncDouble)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to double. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncBigDecimal toVncBigDecimal(VncVal val) {
        if (val == null || Types.isVncBigDecimal(val)) {
            return (VncBigDecimal)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to big-decimal. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncByteBuffer toVncByteBuffer(VncVal val) {
        if (val == null || Types.isVncByteBuffer(val)) {
            return (VncByteBuffer)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to bytebuf. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncCollection toVncCollection(VncVal val) {
        if (val == null || Types.isVncCollection(val)) {
            return (VncCollection)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to collection. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncSequence toVncSequence(VncVal val) {
        if (val == null || Types.isVncSequence(val)) {
            return (VncSequence)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to a sequential collection. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncList toVncList(VncVal val) {
        if (val == null || Types.isVncList(val)) {
            return (VncList)val;
        }
        if (Types.isVncSequence(val)) {
            return ((VncSequence)val).toVncList();
        }
        throw new VncException(String.format("Cannot coerce value of type %s to list. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncVector toVncVector(VncVal val) {
        if (val == null || Types.isVncVector(val)) {
            return (VncVector)val;
        }
        if (Types.isVncSequence(val)) {
            return ((VncSequence)val).toVncVector();
        }
        throw new VncException(String.format("Cannot coerce value of type %s to vector. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncMutableList toVncMutableList(VncVal val) {
        if (val == null || val instanceof VncMutableList) {
            return (VncMutableList)val;
        }
        if (Types.isVncSequence(val)) {
            return new VncMutableList(((VncSequence)val).getList());
        }
        throw new VncException(String.format("Cannot coerce value of type %s to mutable-set. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncMap toVncMap(VncVal val) {
        if (val == null || Types.isVncMap(val)) {
            return (VncMap)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to map. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncHashMap toVncHashMap(VncVal val) {
        if (val == null || val instanceof VncHashMap) {
            return (VncHashMap)val;
        }
        if (Types.isVncMap(val)) {
            return new VncHashMap(((VncMap)val).getMap());
        }
        throw new VncException(String.format("Cannot coerce value of type %s to hash-map. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncMutableMap toVncMutableMap(VncVal val) {
        if (val == null || val instanceof VncMutableMap) {
            return (VncMutableMap)val;
        }
        if (Types.isVncMap(val)) {
            return new VncMutableMap(((VncMap)val).getMap());
        }
        throw new VncException(String.format("Cannot coerce value of type %s to mutable-map. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncSet toVncSet(VncVal val) {
        if (val == null || Types.isVncSet(val)) {
            return (VncSet)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to set. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncHashSet toVncHashSet(VncVal val) {
        if (val == null || Types.isVncHashSet(val)) {
            return (VncHashSet)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to set. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncSortedSet toVncSortedSet(VncVal val) {
        if (val == null || Types.isVncSortedSet(val)) {
            return (VncSortedSet)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to sorted set. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncMutableSet toVncMutableSet(VncVal val) {
        if (val == null || val instanceof VncMutableSet) {
            return (VncMutableSet)val;
        }
        if (Types.isVncSet(val)) {
            return new VncMutableSet(((VncSet)val).getSet());
        }
        throw new VncException(String.format("Cannot coerce value of type %s to mutable-set. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncStack toVncStack(VncVal val) {
        if (val == null || val instanceof VncStack) {
            return (VncStack)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to stack. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncQueue toVncQueue(VncVal val) {
        if (val == null || val instanceof VncQueue) {
            return (VncQueue)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to queue. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static VncJavaObject toVncJavaObject(VncVal val) {
        if (val == null || Types.isVncJavaObject(val)) {
            return (VncJavaObject)val;
        }
        throw new VncException(String.format("Cannot coerce value of type %s to java-object. %s", Types.getType(val), ErrorMessage.buildErrLocation(val)));
    }

    public static <T> T toVncJavaObject(VncVal val, Class<T> type) {
        if (val == null) {
            return null;
        }
        if (Types.isVncJavaObject(val, type)) {
            return (T)((VncJavaObject)val).getDelegate();
        }
        throw new VncException(String.format("Cannot coerce value of type %s to java-object of type %s. %s", Types.getType(val), type.getName(), ErrorMessage.buildErrLocation(val)));
    }
}

