/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.Map;

public class SpecialForms {
    public static VncFunction doc = new SpecialFormsDocFunction("doc", VncFunction.meta().arglists("(doc name)").doc("Prints documentation for a var or special form given its name").examples("(doc +)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction list = new SpecialFormsDocFunction("()", VncFunction.meta().doc("Creates a list.").examples("'(10 20 30)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction vector = new SpecialFormsDocFunction("[]", VncFunction.meta().doc("Creates a vector.").examples("[10 20 30]").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction set = new SpecialFormsDocFunction("#{}", VncFunction.meta().doc("Creates a set.").examples("#{10 20 30}").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction map = new SpecialFormsDocFunction("{}", VncFunction.meta().doc("Creates a hash map.").examples("{:a 10 :b 20}").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction resolve = new SpecialFormsDocFunction("resolve", VncFunction.meta().arglists("(resolve symbol)").doc("Resolves a symbol.").examples("(resolve '+)", "(resolve 'y)", "(resolve (symbol \"+\"))", "((-> \"first\" symbol resolve) [1 2 3])").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_get = new SpecialFormsDocFunction("var-get", VncFunction.meta().arglists("(var-get sym)").doc("Returns the var associated with the symbol").examples("(var-get '+)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction fn = new SpecialFormsDocFunction("fn", VncFunction.meta().arglists("(fn name? [params*] condition-map? expr*)").doc("Defines an anonymous function.").examples("(do (def sum (fn [x y] (+ x y))) (sum 2 3))", "(map (fn double [x] (* 2 x)) (range 1 5))", "(map #(* 2 %) (range 1 5))", "(map #(* 2 %1) (range 1 5))", ";; anonymous function with two params, the second is destructured\n(reduce (fn [m [k v]] (assoc m v k)) {} {:b 2 :a 1 :c 3})", ";; defining a pre-condition                 \n(do                                         \n   (def square-root                         \n        (fn [x]                             \n            { :pre [(>= x 0)] }             \n            (. :java.lang.Math :sqrt x)))   \n   (square-root 4))                           ", ";; higher-order function                                           \n(do                                                                \n   (def discount                                                   \n        (fn [percentage]                                           \n            { :pre [(and (>= percentage 0) (<= percentage 100))] } \n            (fn [price] (- price (* price percentage 0.01)))))     \n   ((discount 50) 300))                                              ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction eval = new SpecialFormsDocFunction("eval", VncFunction.meta().arglists("(eval form)").doc("Evaluates the form data structure (not text!) and returns the result.").examples("(eval '(let [a 10] (+ 3 4 a)))", "(eval (list + 1 2 3))", "(let [s \"(+ 2 x)\" x 10]     \n   (eval (read-string s))))     ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction def = new SpecialFormsDocFunction("def", VncFunction.meta().arglists("(def name expr)").doc("Creates a global variable.").examples("(def x 5)", "(def sum (fn [x y] (+ x y)))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction defonce = new SpecialFormsDocFunction("defonce", VncFunction.meta().arglists("(defonce name expr)").doc("Creates a global variable that can not be overwritten").examples("(defonce x 5)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction set_BANG = new SpecialFormsDocFunction("set!", VncFunction.meta().arglists("(set! var-symbol expr)").doc("Sets a global or thread-local variable to the value of the expression.").examples("(do                             \n  (def x 10)                    \n  (set! x 20)                   \n  x)                              ", "(do                             \n   (def-dynamic x 100)          \n   (set! x 200)                 \n   x)                             ", "(do                             \n   (def-dynamic x 100)          \n   (with-out-str                \n      (print x)                 \n      (binding [x 200]          \n        (print (str \"-\" x))   \n        (set! x (inc x))        \n        (print (str \"-\" x)))  \n      (print (str \"-\" x))))     ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction defmulti = new SpecialFormsDocFunction("defmulti", VncFunction.meta().arglists("(defmulti name dispatch-fn)").doc("Creates a new multimethod with the associated dispatch function.").examples("(do                                                                       \n   ;;defmulti with dispatch function                                      \n   (defmulti salary (fn[amount] (amount :t)))                             \n                                                                          \n   ;;defmethod provides a function implementation for a particular value  \n   (defmethod salary \"com\" [amount] (+ (:b amount) (/ (:b amount) 2)))  \n   (defmethod salary \"bon\" [amount] (+ (:b amount) 99))                 \n   (defmethod salary :default  [amount] (:b amount))                      \n                                                                          \n   [(salary {:t \"com\" :b 1000})                                         \n    (salary {:t \"bon\" :b 1000})                                         \n    (salary {:t \"xxx\" :b 1000})]                                        \n)                                                                           ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction defmethod = new SpecialFormsDocFunction("defmethod", VncFunction.meta().arglists("(defmethod multifn-name dispatch-val & fn-tail)").doc("Creates a new method for a multimethod associated with a dispatch-value.").examples("(do                                                                       \n   ;;defmulti with dispatch function                                      \n   (defmulti salary (fn[amount] (amount :t)))                             \n                                                                          \n   ;;defmethod provides a function implementation for a particular value  \n   (defmethod salary \"com\" [amount] (+ (:b amount) (/ (:b amount) 2)))  \n   (defmethod salary \"bon\" [amount] (+ (:b amount) 99))                 \n   (defmethod salary :default  [amount] (:b amount))                      \n                                                                          \n   [(salary {:t \"com\" :b 1000})                                         \n    (salary {:t \"bon\" :b 1000})                                         \n    (salary {:t \"xxx\" :b 1000})]                                        \n)                                                                           ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction def_dynamic = new SpecialFormsDocFunction("def-dynamic", VncFunction.meta().arglists("(def-dynamic name expr)").doc("Creates a dynamic variable that starts off as a global variable and can be bound with 'binding' to a new value on the local thread.").examples("(do                      \n   (def-dynamic x 100)   \n   (println x)           \n   (binding [x 200]      \n      (println x))       \n   (println x)))           ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction binding = new SpecialFormsDocFunction("binding", VncFunction.meta().arglists("(binding [bindings*] exprs*)").doc("Evaluates the expressions and binds the values to dynamic (thread-local) symbols").examples("(do                      \n   (binding [x 100]      \n      (println x)        \n      (binding [x 200]   \n         (println x))    \n      (println x)))        ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction bound_Q = new SpecialFormsDocFunction("bound?", VncFunction.meta().arglists("(bound? s)").doc("Returns true if the symbol is bound to a value else false").examples("(bound? 'test)", "(let [test 100] (bound? 'test))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction do_ = new SpecialFormsDocFunction("do", VncFunction.meta().arglists("(do exprs)").doc("Evaluates the expressions in order and returns the value of the last.").examples("(do (println \"Test...\") (+ 1 1))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction dorun = new SpecialFormsDocFunction("dorun", VncFunction.meta().arglists("(dorun count expr)").doc("Runs the expr count times in the most effective way. It's main purpose is supporting benchmark test. Returns the expression result of the first invocation.").examples("(dorun 10 (+ 1 1))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction dobench = new SpecialFormsDocFunction("dobench", VncFunction.meta().arglists("(dobench count expr)").doc("Runs the expr count times in the most effective way and returns a list of elapsed nanoseconds for each invocation. It's main purpose is supporting benchmark test.").examples("(dobench 10 (+ 1 1))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction prof = new SpecialFormsDocFunction("prof", VncFunction.meta().arglists("(prof opts)").doc("Controls the code profiling. See the companion functions/macros 'dorun' and 'perf'. The perf macro is built on prof and dorun and provides all to do simple Venice profiling.").examples("(do  \n  (prof :on)   ; turn profiler on  \n  (prof :off)   ; turn profiler off  \n  (prof :status)   ; returns the profiler on/off staus  \n  (prof :clear)   ; clear profiler data captured so far  \n  (prof :data)   ; returns the profiler data as map  \n  (prof :data-formatted)   ; returns the profiler data as formatted text  \n  (prof :data-formatted \"Metrics test\")   ; returns the profiler data as formatted text with a title  \n  nil)  ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction if_ = new SpecialFormsDocFunction("if", VncFunction.meta().arglists("(if test true-expr false-expr)").doc("Evaluates test.").examples("(if (< 10 20) \"yes\" \"no\")").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction let = new SpecialFormsDocFunction("let", VncFunction.meta().arglists("(let [bindings*] exprs*)").doc("Evaluates the expressions and binds the values to symbols in the new local context.").examples("(let [x 1] x))", ";; destructured map                     \n(let [{:keys [width height title ]      \n       :or {width 640 height 500}       \n       :as styles}                      \n      {:width 1000 :title \"Title\"}]   \n     (println \"width: \" width)        \n     (println \"height: \" height)      \n     (println \"title: \" title)        \n     (println \"styles: \" styles))       ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction loop = new SpecialFormsDocFunction("loop", VncFunction.meta().arglists("(loop [bindings*] exprs*)").doc("Evaluates the exprs and binds the bindings. Creates a recursion point with the bindings.").examples(";; tail recursion                                   \n(loop [x 10]                                        \n   (when (> x 1)                                    \n      (println x)                                   \n      (recur (- x 2))))                               ", ";; tail recursion                                   \n(do                                                 \n   (defn sum [n]                                    \n         (loop [cnt n acc 0]                        \n            (if (zero? cnt)                         \n                acc                                 \n                (recur (dec cnt) (+ acc cnt)))))    \n   (sum 10000))                                       ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction recur = new SpecialFormsDocFunction("recur", VncFunction.meta().arglists("(recur expr*)").doc("Evaluates the exprs and rebinds the bindings of the recursion point to the values of the exprs. The recur expression must be at the tail position. The tail position is a postion which an expression would return a value from.").examples(";; tail recursion                                   \n(loop [x 10]                                        \n   (when (> x 1)                                    \n      (println x)                                   \n      (recur (- x 2))))                               ", ";; tail recursion                                   \n(do                                                 \n   (defn sum [n]                                    \n         (loop [cnt n acc 0]                        \n            (if (zero? cnt)                         \n                acc                                 \n                (recur (dec cnt) (+ acc cnt)))))    \n   (sum 10000))                                       ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction try_ = new SpecialFormsDocFunction("try", VncFunction.meta().arglists("(try expr)", "(try expr (catch exClass exSym expr))", "(try expr (catch exClass exSym expr) (finally expr))").doc("Exception handling: try - catch -finally ").examples("(try (throw))", "(try                                      \n   (throw \"test message\"))                ", "(try                                       \n   (throw 100)                             \n   (catch :java.lang.Exception ex -100))    ", "(try                                       \n   (throw 100)                             \n   (finally (println \"...finally\")))       ", "(try                                       \n   (throw 100)                             \n   (catch :java.lang.Exception ex -100)    \n   (finally (println \"...finally\")))       ", "(do                                                  \n   (import :java.lang.RuntimeException)              \n   (try                                              \n      (throw (. :RuntimeException :new \"message\")) \n      (catch :RuntimeException ex (:message ex))))   \n", "(do                                                   \n   (try                                               \n      (throw [1 2 3])                                 \n      (catch :ValueException ex (str (:value ex)))    \n      (catch :RuntimeException ex \"runtime ex\")     \n      (finally (println \"...finally\"))))             ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction try_with = new SpecialFormsDocFunction("try-with", VncFunction.meta().arglists("(try-with [bindings*] expr)", "(try-with [bindings*] expr (catch :java.lang.Exception ex expr))", "(try-with [bindings*] expr (catch :java.lang.Exception ex expr) (finally expr))").doc("try-with resources allows the declaration of resources to be used in a try block with the assurance that the resources will be closed after execution of that block. The resources declared must implement the Closeable or ").examples("(do                                                   \n   (import :java.io.FileInputStream)                  \n   (let [file (io/temp-file \"test-\", \".txt\")]     \n        (io/spit file \"123456789\" :append true)     \n        (try-with [is (. :FileInputStream :new file)] \n           (io/slurp-stream is :binary false))))        ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction locking = new SpecialFormsDocFunction("locking", VncFunction.meta().arglists("(locking x & exprs)").doc("Executes exprs in an implicit do, while holding the monitor of x. \nWill release the monitor of x in all circumstances. \nLocking operates like the synchronized keyword in Java.").examples("(do                        \n   (def x 1)               \n   (locking x              \n      (println 100)        \n      (println 200)))        ", ";; Locks are reentrant     \n(do                        \n   (def x 1)               \n   (locking x              \n      (locking x           \n         (println \"in\")) \n      (println \"out\")))    ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction defmacro = new SpecialFormsDocFunction("defmacro", VncFunction.meta().arglists("(defmacro name [params*] body)").doc("Macro definition").examples("(defmacro unless [pred a b]   \n  `(if (not ~pred) ~a ~b))      ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction macroexpand = new SpecialFormsDocFunction("macroexpand", VncFunction.meta().arglists("(macroexpand form)").doc("If form represents a macro form, returns its expansion, else returns form.\n\nTo recursively expand all macros in a form use (macroexpand-all form).").examples("(macroexpand '(-> c (+ 3) (* 2)))").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction import_ = new SpecialFormsDocFunction("import", VncFunction.meta().arglists("(import class)").doc("Imports a Java class. Imports bound to the current namespace.\n\nDefault imports: \n  java.lang.Throwable \n  java.lang.Exception \n  java.lang.RuntimeException \n  java.lang.NullPointerException \n  java.lang.IllegalArgumentException \n  com.github.jlangch.venice.VncException").examples("(do                        \n  (import :java.lang.Math) \n  (. :Math :max 2 10))      ", "(do                                                                \n  (ns alpha)                                                       \n  (import :java.lang.Math)                                         \n  (println \"alpha:\" (any? #(== % :java.lang.Math) (imports)))    \n                                                                   \n  (ns beta)                                                        \n  (println \"beta:\" (any? #(== % :java.lang.Math) (imports)))     \n                                                                   \n  (ns alpha)                                                       \n  (println \"alpha:\" (any? #(== % :java.lang.Math) (imports)))    \n)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction imports_ = new SpecialFormsDocFunction("imports", VncFunction.meta().arglists("(imports)").doc("List the registered imports for the current namespace.").examples("(do                        \n  (import :java.lang.Math) \n  (imports))                 ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction ns_unmap = new SpecialFormsDocFunction("ns-unmap", VncFunction.meta().arglists("(ns-unmap ns sym)").doc("Removes the mappings for the symbol from the namespace.").examples("(do                    \n  (ns xxx)             \n  (def foo 1)          \n  (ns-unmap xxx foo)   \n  (ns-unmap *ns* foo))   ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction ns_remove = new SpecialFormsDocFunction("ns-remove", VncFunction.meta().arglists("(ns-remove ns)").doc("Removes the mappings for all symbols from the namespace.").examples("(do                     \n  (ns xxx)              \n  (def foo 1)           \n  (def goo 1)           \n  (ns-remove xxx foo)   \n  (ns-remove *ns* foo))   ").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_version = new SpecialFormsDocFunction("*version*", VncFunction.meta().doc("The Venice version").examples("*version*").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_newline = new SpecialFormsDocFunction("*newline*", VncFunction.meta().doc("The system newline").examples("*newline*").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_loaded_modules = new SpecialFormsDocFunction("*loaded-modules*", VncFunction.meta().doc("The loaded modules").examples("*loaded-modules*").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_loaded_files = new SpecialFormsDocFunction("*loaded-files*", VncFunction.meta().doc("The loaded files").examples("*loaded-files*").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_ns = new SpecialFormsDocFunction("*ns*", VncFunction.meta().doc("The current namespace").examples("*ns*", "(do\n  (ns test)\n  *ns*)").build()){
        private static final long serialVersionUID = -1L;
    };
    public static VncFunction var_run_mode = new SpecialFormsDocFunction("*run-mode*", VncFunction.meta().doc("The current run-mode one of (:repl, :script, :app)").examples("*run-mode*").build()){
        private static final long serialVersionUID = -1L;
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().put("doc", (VncVal)doc).put("()", (VncVal)list).put("[]", (VncVal)vector).put("#{}", (VncVal)set).put("{}", (VncVal)map).put("fn", (VncVal)fn).put("eval", (VncVal)eval).put("resolve", (VncVal)resolve).put("var-get", (VncVal)var_get).put("def", (VncVal)def).put("defonce", (VncVal)defonce).put("defmulti", (VncVal)defmulti).put("defmethod", (VncVal)defmethod).put("def-dynamic", (VncVal)def_dynamic).put("binding", (VncVal)binding).put("bound?", (VncVal)bound_Q).put("set!", (VncVal)set_BANG).put("do", (VncVal)do_).put("if", (VncVal)if_).put("let", (VncVal)let).put("loop", (VncVal)loop).put("recur", (VncVal)recur).put("try", (VncVal)try_).put("try-with", (VncVal)try_with).put("locking", (VncVal)locking).put("defmacro", (VncVal)defmacro).put("macroexpand", (VncVal)macroexpand).put("ns-unmap", (VncVal)ns_unmap).put("ns-remove", (VncVal)ns_remove).put("import", (VncVal)import_).put("imports", (VncVal)imports_).put("dobench", (VncVal)dobench).put("dorun", (VncVal)dorun).put("prof", (VncVal)prof).put("*version*", (VncVal)var_version).put("*newline*", (VncVal)var_newline).put("*loaded-modules*", (VncVal)var_loaded_modules).put("*loaded-files*", (VncVal)var_loaded_files).put("*ns*", (VncVal)var_ns).put("*run-mode*", (VncVal)var_run_mode).toMap();

    private static class SpecialFormsDocFunction
    extends VncFunction {
        private static final long serialVersionUID = -1L;

        public SpecialFormsDocFunction(String name, VncVal meta) {
            super(name, meta);
        }

        @Override
        public VncVal apply(VncList args) {
            return Constants.Nil;
        }
    }
}

