/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.javainterop.Invoker;
import com.github.jlangch.venice.impl.javainterop.JavaImports;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.Agent;
import com.github.jlangch.venice.impl.types.concurrent.Delay;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import com.github.jlangch.venice.impl.util.reflect.ReturnValue;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaInteropUtil {
    public static VncVal applyJavaAccess(VncList args, JavaImports javaImports) {
        try {
            Object[] methodArgs;
            VncVal arg0 = args.first();
            VncString method = (VncString)args.second();
            VncList params = args.slice(2);
            String methodName = method.getValue();
            if ("new".equals(methodName)) {
                Class<?> targetClass = JavaInteropUtil.toClass(arg0, javaImports);
                String className = targetClass.getName();
                Object[] methodArgs2 = JavaInteropUtil.isDelayOrAgentClass(className) ? JavaInteropUtil.copyToJavaMethodArgs(params) : JavaInteropUtil.convertToJavaMethodArgs(params);
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeConstructor(new Invoker(), targetClass, methodArgs2));
            }
            if ("class".equals(methodName)) {
                if (Types.isVncString(arg0)) {
                    try {
                        return new VncJavaObject(JavaInteropUtil.toClass(arg0, javaImports));
                    }
                    catch (Exception ex) {
                        return Constants.Nil;
                    }
                }
                if (Types.isVncJavaObject(arg0, Class.class)) {
                    return new VncJavaObject((Class)((VncJavaObject)arg0).getDelegate());
                }
                if (Types.isVncJavaObject(arg0)) {
                    return new VncJavaObject(((VncJavaObject)arg0).getDelegate().getClass());
                }
                return new VncJavaObject(arg0.getClass());
            }
            if (Types.isVncKeyword(arg0) || Types.isVncJavaObject(arg0, Class.class)) {
                Object[] methodArgs3;
                Class<?> targetClass = JavaInteropUtil.toClass(arg0, javaImports);
                String className = targetClass.getName();
                Object[] objectArray = methodArgs3 = JavaInteropUtil.isDelayOrAgentClass(className) ? JavaInteropUtil.copyToJavaMethodArgs(params) : JavaInteropUtil.convertToJavaMethodArgs(params);
                if (methodArgs3.length > 0 || ReflectionAccessor.isStaticMethod(targetClass, methodName, methodArgs3)) {
                    return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeStaticMethod(new Invoker(), targetClass, methodName, methodArgs3));
                }
                if (ReflectionAccessor.isStaticField(targetClass, methodName)) {
                    return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onGetStaticField(new Invoker(), targetClass, methodName));
                }
                throw new JavaMethodInvocationException(String.format("No matching public static method or field found: '%s' for target '%s'", methodName, targetClass));
            }
            Object target = null;
            Class<?> targetFormalType = null;
            if (arg0 instanceof IVncJavaObject) {
                target = ((IVncJavaObject)((Object)arg0)).getDelegate();
                targetFormalType = ((IVncJavaObject)((Object)arg0)).getDelegateFormalType();
            } else {
                target = arg0.convertToJavaObject();
            }
            Object[] objectArray = methodArgs = JavaInteropUtil.isDelayOrAgentClass(target) ? JavaInteropUtil.copyToJavaMethodArgs(params) : JavaInteropUtil.convertToJavaMethodArgs(params);
            if (methodArgs.length > 0 || ReflectionAccessor.isInstanceMethod(target, methodName, methodArgs)) {
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onInvokeInstanceMethod(new Invoker(), target, targetFormalType, methodName, methodArgs));
            }
            if (ReflectionAccessor.isInstanceField(target, methodName)) {
                return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onGetInstanceField(new Invoker(), target, targetFormalType, methodName));
            }
            throw new JavaMethodInvocationException(String.format("No matching public instance method or field found: '%s' for target '%s'", methodName, target.getClass()));
        }
        catch (JavaMethodInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof SecurityException) {
                throw new SecurityException(String.format("%s. %s", cause.getMessage(), ErrorMessage.buildErrLocation(args)));
            }
            if (cause != null && cause instanceof InvocationTargetException && (cause = cause.getCause()) != null && cause instanceof SecurityException) {
                throw new SecurityException(String.format("%s. %s", cause.getMessage(), ErrorMessage.buildErrLocation(args)));
            }
            throw new JavaMethodInvocationException(String.format("%s. %s", ex.getMessage(), ErrorMessage.buildErrLocation(args)), ex);
        }
        catch (SecurityException ex) {
            throw new SecurityException(String.format("%s. %s", ex.getMessage(), ErrorMessage.buildErrLocation(args)));
        }
        catch (RuntimeException ex) {
            throw new JavaMethodInvocationException(String.format("JavaInterop failure. %s", ErrorMessage.buildErrLocation(args)), ex);
        }
    }

    public static Class<?> toClass(VncVal val, JavaImports javaImports) {
        if (Types.isVncJavaObject(val, Class.class)) {
            return (Class)((VncJavaObject)val).getDelegate();
        }
        if (Types.isVncJavaObject(val)) {
            return ((VncJavaObject)val).getDelegate().getClass();
        }
        String className = Types.isVncKeyword(val) ? Coerce.toVncKeyword(val).getValue() : Coerce.toVncString(val).getValue();
        return ReflectionUtil.classForName(javaImports.resolveClassName(className));
    }

    public static VncKeyword toVncKeyword(Class<?> clazz) {
        return new VncKeyword(clazz.getName());
    }

    public static List<VncKeyword> toVncKeywords(List<Class<?>> classes) {
        return classes.stream().map(c -> JavaInteropUtil.toVncKeyword(c)).collect(Collectors.toList());
    }

    private static Object[] convertToJavaMethodArgs(VncList params) {
        Object[] methodArgs = new Object[params.size()];
        for (int ii = 0; ii < params.size(); ++ii) {
            methodArgs[ii] = params.nth(ii).convertToJavaObject();
        }
        return methodArgs;
    }

    private static Object[] copyToJavaMethodArgs(VncList params) {
        Object[] methodArgs = new Object[params.size()];
        for (int ii = 0; ii < params.size(); ++ii) {
            methodArgs[ii] = params.nth(ii);
        }
        return methodArgs;
    }

    public static VncVal convertToVncVal(Object value) {
        return JavaInteropUtil.convertToVncVal(value, null, false);
    }

    private static VncVal convertToVncVal(Object value, Class<?> formalType, boolean recursive) {
        if (value == null) {
            return Constants.Nil;
        }
        if (value instanceof ReturnValue) {
            return JavaInteropUtil.convertToVncVal(((ReturnValue)value).getValue(), ((ReturnValue)value).getFormalType(), recursive);
        }
        if (value instanceof VncVal) {
            return (VncVal)value;
        }
        if (value instanceof String) {
            return new VncString((String)value);
        }
        if (value instanceof Character) {
            return new VncChar((Character)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new VncInteger((Integer)value);
            }
            if (value instanceof Long) {
                return new VncLong((Long)value);
            }
            if (value instanceof Float) {
                return new VncDouble((Float)value);
            }
            if (value instanceof Double) {
                return new VncDouble((Double)value);
            }
            if (value instanceof BigDecimal) {
                return new VncBigDecimal((BigDecimal)value);
            }
            if (value instanceof Byte) {
                return new VncLong((Byte)value & 0xFF);
            }
            if (value instanceof Short) {
                return new VncLong(((Short)value).longValue());
            }
            return new VncJavaObject(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Constants.True : Constants.False;
        }
        if (ReflectionTypes.isEnumType(value.getClass())) {
            return new VncString(value.toString());
        }
        if (value instanceof List) {
            if (recursive) {
                ArrayList<VncVal> list = new ArrayList<VncVal>();
                for (Object o : (List)value) {
                    list.add(JavaInteropUtil.convertToVncVal(o, null, recursive));
                }
                return new VncList(list);
            }
            return new VncJavaList((List)value);
        }
        if (value instanceof Set) {
            if (recursive) {
                HashSet<VncVal> set = new HashSet<VncVal>();
                for (Object o : (Set)value) {
                    set.add(JavaInteropUtil.convertToVncVal(o, null, recursive));
                }
                return VncHashSet.ofAll(set);
            }
            return new VncJavaSet((Set)value);
        }
        if (value instanceof Map) {
            if (recursive) {
                HashMap<VncVal, VncVal> map = new HashMap<VncVal, VncVal>();
                for (Map.Entry o : ((Map)value).entrySet()) {
                    map.put(JavaInteropUtil.convertToVncVal(o.getKey(), null, recursive), JavaInteropUtil.convertToVncVal(o.getValue(), null, recursive));
                }
                return new VncHashMap(map);
            }
            return new VncJavaMap((Map)value);
        }
        if (value instanceof ByteBuffer) {
            return new VncByteBuffer((ByteBuffer)value);
        }
        if (ReflectionTypes.isArrayType(value.getClass())) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType == Byte.TYPE) {
                return new VncByteBuffer(ByteBuffer.wrap((byte[])value));
            }
            ArrayList<VncVal> vec = new ArrayList<VncVal>();
            for (int ii = 0; ii < Array.getLength(value); ++ii) {
                vec.add(JavaInteropUtil.convertToVncVal(Array.get(value, ii)));
            }
            return new VncVector(vec);
        }
        if (value instanceof Class) {
            return new VncString(((Class)value).getName());
        }
        return formalType == null ? new VncJavaObject(value) : VncJavaObject.from(value, formalType);
    }

    private static boolean isDelayOrAgentClass(String className) {
        return className.equals(Delay.class.getName()) || className.equals(Agent.class.getName());
    }

    private static boolean isDelayOrAgentClass(Object target) {
        return target instanceof Delay || target instanceof Agent;
    }
}

