/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.nanojson.JsonObject;
import com.github.jlangch.venice.nanojson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ReplConfig {
    public static final String ANSI_RESET = "\u001b[0m";
    private static final String DEFAULT_PROMPT = "venice> ";
    private static final String DEFAULT_SECONDARY_PROMPT = "| ";
    private static final String DEFAULT_RESULT_PREFIX = "=> ";
    private static final List<String> COLOR_NAMES = Arrays.asList("result", "stdout", "stderr", "error", "system", "interrupt", "prompt");
    private final ColorMode colorMode;
    private final String loadFile;
    private final String prompt;
    private final String secondaryPrompt;
    private final String resultPrefix;
    private final Level jlineLoglevel;
    private final boolean jlineDumbTerminal;
    private final Map<String, String> colors = new HashMap<String, String>();

    private ReplConfig(ColorMode colorMode, String loadFile, String prompt, String secondaryPrompt, String resultPrefix, Level jlineLoglevel, boolean jlineDumbTerminal, Map<String, String> colors) {
        this.colorMode = colorMode;
        this.loadFile = loadFile;
        this.prompt = ReplConfig.orDefault(prompt, DEFAULT_PROMPT);
        this.secondaryPrompt = ReplConfig.orDefault(secondaryPrompt, DEFAULT_SECONDARY_PROMPT);
        this.resultPrefix = ReplConfig.orDefault(resultPrefix, DEFAULT_RESULT_PREFIX);
        this.jlineLoglevel = jlineLoglevel;
        this.jlineDumbTerminal = jlineDumbTerminal;
        this.colors.putAll(colors);
    }

    public static ReplConfig load(CommandLineArgs cli) {
        HashMap<String, String> colors = new HashMap<String, String>();
        String loadFile = cli.switchValue("-load-file");
        try {
            JsonObject jsonObj = ReplConfig.loadJsonConfig();
            String prompt = jsonObj.getString("prompt");
            String secondaryPrompt = jsonObj.getString("secondary-prompt");
            String resultPrefix = jsonObj.getString("result-prefix");
            JsonObject obj = (JsonObject)jsonObj.get("colors");
            if (obj != null) {
                for (String cname : COLOR_NAMES) {
                    colors.put("light." + cname, StringUtil.emptyToNull(obj.getString(cname)));
                }
            }
            if ((obj = (JsonObject)jsonObj.get("colors-darkmode")) != null) {
                for (String cname : COLOR_NAMES) {
                    colors.put("dark." + cname, StringUtil.emptyToNull(obj.getString(cname)));
                }
            }
            Level jlineLoglevel = null;
            boolean jlineDumbTerminal = false;
            obj = (JsonObject)jsonObj.get("jline");
            if (obj != null) {
                try {
                    jlineLoglevel = Level.parse(obj.getString("loglevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jlineDumbTerminal = obj.getBoolean("dumb-terminal", Boolean.FALSE);
                }
                catch (Exception ex) {
                    jlineDumbTerminal = true;
                }
            }
            return new ReplConfig(ReplConfig.getColorMode(cli), loadFile, prompt, secondaryPrompt, resultPrefix, jlineLoglevel, jlineDumbTerminal, colors);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse REPL json config file", ex);
        }
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public String getColor(String key) {
        switch (this.colorMode) {
            case Light: {
                return this.lookupColor("light." + key);
            }
            case Dark: {
                return this.lookupColor("dark." + key);
            }
        }
        return null;
    }

    public String getLoadFile() {
        return this.loadFile;
    }

    public String getPrompt() {
        return this.getColor("prompt") == null ? this.prompt : this.getColor("prompt") + this.prompt + ANSI_RESET;
    }

    public String getSecondaryPrompt() {
        return this.getColor("secondary-prompt") == null ? this.secondaryPrompt : this.getColor("secondary-prompt") + this.secondaryPrompt + ANSI_RESET;
    }

    public String getResultPrefix() {
        return this.resultPrefix;
    }

    public Level getJLineLogLevel() {
        return this.jlineLoglevel;
    }

    public boolean isJLineDumbTerminal() {
        return this.jlineDumbTerminal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJansiVersion() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/fusesource/jansi/jansi.properties");){
            if (is == null) return null;
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getRawClasspathConfig() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "repl.json").getResourceAsString("UTF-8");
    }

    public static String getRawClasspathLauncherName() {
        return System.getProperty("os.name").startsWith("Windows") ? "repl.bat" : "repl.sh";
    }

    public static String getRawClasspathLauncher() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + ReplConfig.getRawClasspathLauncherName()).getResourceAsString("UTF-8");
    }

    private String lookupColor(String key) {
        return StringUtil.emptyToNull(this.colors.get(key));
    }

    private static JsonObject loadJsonConfig() throws Exception {
        File fileJson = new File("repl.json");
        if (fileJson.isFile()) {
            System.out.println("Loading REPL config from " + fileJson + "...");
            try (FileReader reader = new FileReader(fileJson);){
                JsonObject jsonObject = JsonParser.object().from(reader);
                return jsonObject;
            }
        }
        String config = ReplConfig.getRawClasspathConfig();
        System.out.println("Loading REPL default config...");
        return JsonParser.object().from(config);
    }

    private static ColorMode getColorMode(CommandLineArgs cli) {
        if (cli.switchPresent("-colors")) {
            return ColorMode.Light;
        }
        if (cli.switchPresent("-colors-lightmode")) {
            return ColorMode.Light;
        }
        if (cli.switchPresent("-colors-darkmode")) {
            return ColorMode.Dark;
        }
        return ColorMode.None;
    }

    private static String orDefault(String s, String sDefault) {
        return s == null ? sDefault : s;
    }

    public static enum ColorMode {
        Light,
        Dark,
        None;

    }
}

