/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncConstant
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final String value;

    public VncConstant(String name) {
        super(Constants.Nil);
        this.value = name;
    }

    @Override
    public VncConstant withMeta(VncVal meta) {
        return this;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.CONSTANT;
    }

    @Override
    public Object convertToJavaObject() {
        if (this == Constants.Nil) {
            return null;
        }
        if (this == Constants.True) {
            return Boolean.TRUE;
        }
        if (this == Constants.False) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public int compareTo(VncVal o) {
        if (this == Constants.Nil) {
            return o == Constants.Nil ? 0 : -1;
        }
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncBoolean(this) && Types.isVncBoolean(o)) {
            return Long.valueOf(this == Constants.False ? 0L : 1L).compareTo(o == Constants.False ? 0L : 1L);
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncConstant other = (VncConstant)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }
}

