/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.Map;
import org.repackage.io.vavr.collection.SortedMap;

public class VncSortedMap
extends VncMap {
    private static final long serialVersionUID = -1848883965231344442L;
    private final org.repackage.io.vavr.collection.TreeMap<VncVal, VncVal> value;

    public VncSortedMap() {
        this((Map<VncVal, VncVal>)null, null);
    }

    public VncSortedMap(VncVal meta) {
        this((Map<VncVal, VncVal>)null, meta);
    }

    public VncSortedMap(Map<VncVal, VncVal> val) {
        this(val, null);
    }

    public VncSortedMap(java.util.Map<VncVal, VncVal> vals) {
        this(vals, null);
    }

    public VncSortedMap(java.util.Map<VncVal, VncVal> vals, VncVal meta) {
        this(vals == null ? null : org.repackage.io.vavr.collection.TreeMap.ofAll(vals), meta);
    }

    public VncSortedMap(Map<VncVal, VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? org.repackage.io.vavr.collection.TreeMap.empty() : (val instanceof org.repackage.io.vavr.collection.TreeMap ? (org.repackage.io.vavr.collection.TreeMap)val : org.repackage.io.vavr.collection.TreeMap.ofEntries(val));
    }

    public static VncSortedMap ofAll(VncSequence lst) {
        if (lst != null && lst.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of list items. %s", ErrorMessage.buildErrLocation(lst)));
        }
        return new VncSortedMap().assoc(lst);
    }

    public static VncSortedMap ofAll(VncVector vec) {
        if (vec != null && vec.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of vector items. %s", ErrorMessage.buildErrLocation(vec)));
        }
        return new VncSortedMap().assoc(vec);
    }

    public static VncSortedMap of(VncVal ... mvs) {
        if (mvs != null && mvs.length % 2 != 0) {
            throw new VncException(String.format("sorted-map: create requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs[0])));
        }
        return new VncSortedMap().assoc(mvs);
    }

    @Override
    public VncSortedMap emptyWithMeta() {
        return new VncSortedMap(this.getMeta());
    }

    @Override
    public VncSortedMap withValues(java.util.Map<VncVal, VncVal> replaceVals) {
        return new VncSortedMap(replaceVals, this.getMeta());
    }

    @Override
    public VncSortedMap withValues(java.util.Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncSortedMap(replaceVals, meta);
    }

    @Override
    public VncSortedMap withMeta(VncVal meta) {
        return new VncSortedMap(this.value, meta);
    }

    @Override
    public java.util.Map<VncVal, VncVal> getMap() {
        return Collections.unmodifiableMap(this.value.toJavaMap());
    }

    @Override
    public VncVal get(VncVal key) {
        return this.value.get(key).getOrElse(Constants.Nil);
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return this.value.containsKey(key) ? Constants.True : Constants.False;
    }

    @Override
    public VncList keys() {
        return new VncList(new ArrayList(this.value.keySet().toJavaList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.value.map(e -> new VncMapEntry((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()));
    }

    @Override
    public VncSortedMap putAll(VncMap map) {
        return new VncSortedMap(this.value.merge(org.repackage.io.vavr.collection.TreeMap.ofAll(map.getMap())), this.getMeta());
    }

    @Override
    public VncSortedMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("sorted-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs[0])));
        }
        SortedMap<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.length; i += 2) {
            tmp = tmp.put((Object)mvs[i], (Object)mvs[i + 1]);
        }
        return new VncSortedMap(tmp, this.getMeta());
    }

    @Override
    public VncSortedMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("sorted-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs)));
        }
        SortedMap<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.getList().size(); i += 2) {
            tmp = tmp.put((Object)mvs.nth(i), (Object)mvs.nth(i + 1));
        }
        return new VncSortedMap(tmp, this.getMeta());
    }

    @Override
    public VncSortedMap dissoc(VncVal ... keys) {
        return new VncSortedMap(this.value.removeAll(Arrays.asList(keys)), this.getMeta());
    }

    @Override
    public VncSortedMap dissoc(VncSequence keys) {
        return new VncSortedMap(this.value.removeAll(keys.getList()), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SORTEDMAP;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSortedMap(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncSortedMap)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSortedMap other = (VncSortedMap)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        List<VncVal> list = this.value.map(e -> VncList.of((VncVal)e._1, (VncVal)e._2).getList()).collect(Collectors.toList()).stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        return "{" + Printer.join(list, " ", print_readably) + "}";
    }

    public static class Builder {
        private TreeMap<VncVal, VncVal> map = new TreeMap();

        public Builder put(String key, VncVal val) {
            this.map.put(new VncSymbol(key), val);
            return this;
        }

        public Builder put(VncVal key, VncVal val) {
            this.map.put(key, val);
            return this;
        }

        public VncSortedMap build() {
            return new VncSortedMap(this.map);
        }

        public java.util.Map<VncVal, VncVal> toMap() {
            return this.map;
        }
    }
}

