/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.csv;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Types;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVWriter {
    private final String separator;
    private final String quote;
    private final String newline;

    public CSVWriter() {
        this(',', '\"', "\n");
    }

    public CSVWriter(char separator, char quote, String newline) {
        this.separator = String.valueOf(separator);
        this.quote = String.valueOf(quote);
        this.newline = newline == null ? "\n" : newline;
    }

    public void write(Writer writer, List<List<String>> data) {
        try {
            boolean first = true;
            for (List<String> record : data) {
                if (!first) {
                    writer.write(this.newline);
                }
                this.writeRecord(writer, record);
                first = false;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(Writer writer, VncSequence data) {
        try {
            boolean first = true;
            for (VncVal record : data.getList()) {
                if (!first) {
                    writer.write(this.newline);
                }
                if (!Types.isVncSequence(record)) {
                    throw new VncException("CSV data records must be of type VncSequence");
                }
                this.writeRecord(writer, (VncSequence)record);
                first = false;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeRecord(Writer writer, List<String> record) throws IOException {
        boolean first = true;
        for (String s : record) {
            if (!first) {
                writer.write(this.separator);
            }
            if (s != null) {
                writer.write(this.quote(s));
            }
            first = false;
        }
    }

    private void writeRecord(Writer writer, VncSequence record) throws IOException {
        boolean first = true;
        for (VncVal v : record.getList()) {
            if (!first) {
                writer.write(this.separator);
            }
            if (v != Constants.Nil) {
                writer.write(this.quote(v.toString()));
            }
            first = false;
        }
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        int pos = s.indexOf(this.quote);
        if (pos < 0) {
            return s;
        }
        int curr = 0;
        while (curr < s.length()) {
            if (pos < 0) {
                sb.append(s.substring(pos));
                break;
            }
            sb.append(s.substring(curr, pos + 1));
            sb.append(this.quote);
            curr = pos + 1;
            pos = s.indexOf(this.quote, curr);
        }
        return sb.toString();
    }

    private String quote(String s) {
        return this.needsQuote(s) ? this.quote + this.escape(s) + this.quote : s;
    }

    private boolean needsQuote(String s) {
        return s != null && (s.contains(" ") || s.contains(this.quote) || s.contains(this.separator));
    }
}

