/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.impl.sandbox.CompiledSandboxRules;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.reflect.ReturnValue;
import com.github.jlangch.venice.javainterop.IInvoker;
import com.github.jlangch.venice.javainterop.SandboxRules;
import com.github.jlangch.venice.javainterop.ValueFilterInterceptor;

public class SandboxInterceptor
extends ValueFilterInterceptor {
    private static final String PREFIX = "Venice Sandbox";
    private final SandboxRules sandboxRulesOrg;
    private final CompiledSandboxRules sandboxRules;

    public SandboxInterceptor(SandboxRules rules) {
        this.sandboxRulesOrg = rules;
        this.sandboxRules = CompiledSandboxRules.compile(rules);
    }

    public SandboxRules getRules() {
        return this.sandboxRulesOrg;
    }

    @Override
    public ReturnValue onInvokeInstanceMethod(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String method, Object ... args) throws SecurityException {
        this.validateClassAccessor(receiverFormalType, method);
        this.validateObjAccessor(receiver, method);
        return super.onInvokeInstanceMethod(invoker, receiver, receiverFormalType, method, args);
    }

    @Override
    public ReturnValue onInvokeStaticMethod(IInvoker invoker, Class<?> receiver, String method, Object ... args) throws SecurityException {
        this.validateClassAccessor(receiver, method);
        return super.onInvokeStaticMethod(invoker, receiver, method, args);
    }

    @Override
    public ReturnValue onInvokeConstructor(IInvoker invoker, Class<?> receiver, Object ... args) throws SecurityException {
        return super.onInvokeConstructor(invoker, receiver, args);
    }

    @Override
    public ReturnValue onGetBeanProperty(IInvoker invoker, Object receiver, String property) throws SecurityException {
        this.validateObjAccessor(receiver, property);
        return super.onGetBeanProperty(invoker, receiver, property);
    }

    @Override
    public void onSetBeanProperty(IInvoker invoker, Object receiver, String property, Object value) throws SecurityException {
        this.validateObjAccessor(receiver, property);
        super.onSetBeanProperty(invoker, receiver, property, value);
    }

    @Override
    public ReturnValue onGetStaticField(IInvoker invoker, Class<?> receiver, String fieldName) throws SecurityException {
        this.validateClassAccessor(receiver, fieldName);
        return super.onGetStaticField(invoker, receiver, fieldName);
    }

    @Override
    public ReturnValue onGetInstanceField(IInvoker invoker, Object receiver, Class<?> receiverFormalType, String fieldName) throws SecurityException {
        this.validateObjAccessor(receiver, fieldName);
        return super.onGetInstanceField(invoker, receiver, receiverFormalType, fieldName);
    }

    @Override
    public byte[] onLoadClassPathResource(String resourceName) throws SecurityException {
        this.validateClasspathResource(resourceName);
        return super.onLoadClassPathResource(resourceName);
    }

    @Override
    public String onReadSystemProperty(String propertyName) throws SecurityException {
        this.validateSystemProperty(propertyName);
        return super.onReadSystemProperty(propertyName);
    }

    @Override
    public String onReadSystemEnv(String name) throws SecurityException {
        this.validateSystemEnv(name);
        return super.onReadSystemEnv(name);
    }

    @Override
    public void validateVeniceFunction(String funcName) throws SecurityException {
        if (this.sandboxRules.isBlackListedVeniceFunction(funcName)) {
            throw new SecurityException(String.format("%s: Access denied to function %s", PREFIX, funcName));
        }
    }

    @Override
    public void validateLoadModule(String moduleName) throws SecurityException {
        if (!this.sandboxRules.isWhiteListedVeniceModule(moduleName)) {
            throw new SecurityException(String.format("%s: Access denied to module %s", PREFIX, moduleName));
        }
    }

    @Override
    public Integer getMaxExecutionTimeSeconds() {
        return this.sandboxRules.getMaxExecTimeSeconds();
    }

    @Override
    public Integer getMaxFutureThreadPoolSize() {
        return this.sandboxRules.getMaxFutureThreadPoolSize();
    }

    @Override
    protected ReturnValue filterReturnValue(ReturnValue returnValue) {
        this.validateClass(returnValue.getFormalType());
        this.validateObj(returnValue.getValue());
        return returnValue;
    }

    @Override
    protected Object filter(Object obj) {
        this.validateObj(obj);
        return obj;
    }

    @Override
    protected Object filterAccessor(Object o, String accessor) {
        this.validateObjAccessor(o, accessor);
        return o;
    }

    private void validateClass(Class<?> clazz) {
        if (clazz != null && !this.sandboxRules.isWhiteListed(clazz)) {
            throw new SecurityException(String.format("%s: Access denied to class %s", PREFIX, clazz.getName()));
        }
    }

    private void validateObj(Object obj) {
        if (obj != null) {
            this.validateClass(this.getClass(obj));
        }
    }

    private void validateClassAccessor(Class<?> clazz, String accessor) {
        if (clazz != null && !this.sandboxRules.isWhiteListed(clazz, accessor)) {
            throw new SecurityException(String.format("%s: Access denied to accessor %s::%s", PREFIX, clazz.getName(), accessor));
        }
    }

    private void validateObjAccessor(Object receiver, String accessor) {
        if (receiver != null) {
            this.validateClassAccessor(this.getClass(receiver), accessor);
        }
    }

    private void validateClasspathResource(String resourceName) {
        if (!StringUtil.isBlank(resourceName) && !this.sandboxRules.isWhiteListedClasspathResource(resourceName)) {
            throw new SecurityException(String.format("%s: Access denied to classpath resource '%s'", PREFIX, resourceName));
        }
    }

    private void validateSystemProperty(String propertyName) {
        if (!StringUtil.isBlank(propertyName) && !this.sandboxRules.isWhiteListedSystemProperty(propertyName)) {
            throw new SecurityException(String.format("%s: Access denied to system property '%s'", PREFIX, propertyName));
        }
    }

    private void validateSystemEnv(String name) {
        if (!StringUtil.isBlank(name) && !this.sandboxRules.isWhiteListedSystemEnv(name)) {
            throw new SecurityException(String.format("%s: Access denied to system environment variable '%s'", PREFIX, name));
        }
    }

    private Class<?> getClass(Object obj) {
        if (obj != null) {
            return obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        return null;
    }
}

