/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.repackage.org.jline.builtins.Builtins;
import org.repackage.org.jline.builtins.Completers;
import org.repackage.org.jline.builtins.Options;
import org.repackage.org.jline.builtins.Widgets;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.utils.AttributedString;

public interface CommandRegistry {
    public static Completers.SystemCompleter aggregateCompleters(CommandRegistry ... commandRegistries) {
        Completers.SystemCompleter out = new Completers.SystemCompleter();
        for (CommandRegistry r : commandRegistries) {
            out.add(r.compileCompleters());
        }
        return out;
    }

    public static Completers.SystemCompleter compileCompleters(CommandRegistry ... commandRegistries) {
        Completers.SystemCompleter out = CommandRegistry.aggregateCompleters(commandRegistries);
        out.compile();
        return out;
    }

    default public String name() {
        return this.getClass().getSimpleName();
    }

    public Set<String> commandNames();

    public Map<String, String> commandAliases();

    default public List<String> commandInfo(String command) {
        try {
            Object[] args = new Object[]{"--help"};
            if (command.equals("help")) {
                args = new Object[]{};
            }
            this.invoke(new CommandSession(), command, args);
        }
        catch (Options.HelpException e) {
            return Builtins.compileCommandInfo(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("default CommandRegistry.commandInfo() method must be overridden in class " + this.getClass().getCanonicalName());
    }

    public boolean hasCommand(String var1);

    public Completers.SystemCompleter compileCompleters();

    default public Widgets.CmdDesc commandDescription(String command) {
        try {
            if (command == null) {
                ArrayList<AttributedString> main = new ArrayList<AttributedString>();
                HashMap<String, List<AttributedString>> options = new HashMap<String, List<AttributedString>>();
                for (String c : new TreeSet<String>(this.commandNames())) {
                    Iterator<String> iterator = this.commandInfo(c).iterator();
                    if (!iterator.hasNext()) continue;
                    String info = iterator.next();
                    main.add(Options.HelpException.highlightSyntax(c + " -  " + info, Options.HelpException.defaultStyle(), true));
                }
                return new Widgets.CmdDesc(main, Widgets.ArgDesc.doArgNames(Arrays.asList("")), options);
            }
            this.invoke(new CommandSession(), command, "--help");
        }
        catch (Options.HelpException e) {
            return Builtins.compileCommandDescription(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("default CommandRegistry.commandDescription() method must be overridden in class " + this.getClass().getCanonicalName());
    }

    default public Object execute(CommandSession session, String command, String[] args) throws Exception {
        throw new IllegalArgumentException("CommandRegistry method execute(String command, String[] args) is not implemented!");
    }

    default public Object invoke(CommandSession session, String command, Object ... args) throws Exception {
        String[] _args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException();
            }
            _args[i] = args[i].toString();
        }
        return this.execute(session, command, _args);
    }

    public static class CommandSession {
        private final Terminal terminal;
        private final InputStream in;
        private final PrintStream out;
        private final PrintStream err;

        public CommandSession() {
            this.in = System.in;
            this.out = System.out;
            this.err = System.err;
            this.terminal = null;
        }

        public CommandSession(Terminal terminal) {
            this(terminal, terminal.input(), new PrintStream(terminal.output()), new PrintStream(terminal.output()));
        }

        public CommandSession(Terminal terminal, InputStream in, PrintStream out, PrintStream err) {
            this.terminal = terminal;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }
}

