/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.repackage.org.jline.builtins.Options;
import org.repackage.org.jline.keymap.KeyMap;
import org.repackage.org.jline.reader.Binding;
import org.repackage.org.jline.reader.Buffer;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.Parser;
import org.repackage.org.jline.reader.Reference;
import org.repackage.org.jline.reader.Widget;
import org.repackage.org.jline.reader.impl.BufferImpl;
import org.repackage.org.jline.utils.AttributedString;
import org.repackage.org.jline.utils.AttributedStringBuilder;
import org.repackage.org.jline.utils.AttributedStyle;
import org.repackage.org.jline.utils.Status;

public abstract class Widgets {
    protected static final String AP_TOGGLE = "autopair-toggle";
    protected static final String AP_INSERT = "_autopair-insert";
    protected static final String AP_BACKWARD_DELETE_CHAR = "_autopair-backward-delete-char";
    protected static final String TT_TOGGLE = "tailtip-toggle";
    protected static final String TT_ACCEPT_LINE = "_tailtip-accept-line";
    private final LineReader reader;

    public Widgets(LineReader reader) {
        this.reader = reader;
    }

    public void addWidget(String name, Widget widget) {
        this.reader.getWidgets().put(name, this.namedWidget(name, widget));
    }

    private Widget namedWidget(final String name, final Widget widget) {
        return new Widget(){

            public String toString() {
                return name;
            }

            @Override
            public boolean apply() {
                return widget.apply();
            }
        };
    }

    public void callWidget(String name) {
        if (!name.startsWith("_") && !name.endsWith("-toggle")) {
            name = "." + name;
        }
        this.reader.callWidget(name);
    }

    public void executeWidget(String name) {
        this.getKeyMap().bind((Binding)new Reference(name), (CharSequence)KeyMap.alt(KeyMap.ctrl('X')));
        this.reader.runMacro(KeyMap.alt(KeyMap.ctrl('X')));
    }

    public void aliasWidget(String orig, String alias) {
        this.reader.getWidgets().put(alias, this.widget(orig));
    }

    public String getWidget(String name) {
        return this.widget(name).toString();
    }

    public boolean existsWidget(String name) {
        try {
            this.widget(name);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Widget widget(String name) {
        Widget out = null;
        out = name.startsWith(".") ? this.reader.getBuiltinWidgets().get(name.substring(1)) : this.reader.getWidgets().get(name);
        if (out == null) {
            throw new InvalidParameterException("widget: no such widget " + name);
        }
        return out;
    }

    public Parser parser() {
        return this.reader.getParser();
    }

    public KeyMap<Binding> getKeyMap() {
        return this.reader.getKeyMaps().get("main");
    }

    public Buffer buffer() {
        return this.reader.getBuffer();
    }

    public void replaceBuffer(Buffer buffer) {
        this.reader.getBuffer().copyFrom(buffer);
    }

    public List<String> args() {
        return this.reader.getParser().parse(this.buffer().toString(), 0, Parser.ParseContext.COMPLETE).words();
    }

    public String prevChar() {
        return String.valueOf((char)this.reader.getBuffer().prevChar());
    }

    public String currChar() {
        return String.valueOf((char)this.reader.getBuffer().currChar());
    }

    public String lastBinding() {
        return this.reader.getLastBinding();
    }

    public void putString(String string) {
        this.reader.getBuffer().write(string);
    }

    public String tailTip() {
        return this.reader.getTailTip();
    }

    public void setTailTip(String tailTip) {
        this.reader.setTailTip(tailTip);
    }

    public void setErrorPattern(Pattern errorPattern) {
        this.reader.getHighlighter().setErrorPattern(errorPattern);
    }

    public void setErrorIndex(int errorIndex) {
        this.reader.getHighlighter().setErrorIndex(errorIndex);
    }

    public void clearTailTip() {
        this.reader.setTailTip("");
    }

    public void setSuggestionType(LineReader.SuggestionType type) {
        this.reader.setAutosuggestion(type);
    }

    public void addDescription(List<AttributedString> desc) {
        Status.getStatus(this.reader.getTerminal()).update(desc);
    }

    public void clearDescription() {
        this.initDescription(0);
    }

    public void initDescription(int size) {
        Status status = Status.getStatus(this.reader.getTerminal(), false);
        if (size > 0) {
            if (status == null) {
                status = Status.getStatus(this.reader.getTerminal());
            }
            status.setBorder(true);
            ArrayList<AttributedString> as = new ArrayList<AttributedString>();
            for (int i = 0; i < size; ++i) {
                as.add(new AttributedString(""));
            }
            this.addDescription(as);
            this.executeWidget("redraw-line");
        } else if (status != null) {
            if (size < 0) {
                status.update(null);
                this.executeWidget("redraw-line");
            } else {
                status.clear();
            }
        }
    }

    public void destroyDescription() {
        this.initDescription(-1);
    }

    static class Pair<U, V> {
        final U u;
        final V v;

        public Pair(U u, V v) {
            this.u = u;
            this.v = v;
        }

        public U getU() {
            return this.u;
        }

        public V getV() {
            return this.v;
        }
    }

    public static class CmdDesc {
        private List<AttributedString> mainDesc;
        private List<ArgDesc> argsDesc;
        private TreeMap<String, List<AttributedString>> optsDesc;
        private Pattern errorPattern;
        private int errorIndex = -1;
        private boolean valid = true;
        private boolean command = false;
        private boolean subcommand = false;

        public CmdDesc() {
            this.command = false;
        }

        public CmdDesc(boolean valid) {
            this.valid = valid;
        }

        public CmdDesc(List<ArgDesc> argsDesc) {
            this(new ArrayList<AttributedString>(), argsDesc, new HashMap<String, List<AttributedString>>());
        }

        public CmdDesc(List<ArgDesc> argsDesc, Map<String, List<AttributedString>> optsDesc) {
            this(new ArrayList<AttributedString>(), argsDesc, optsDesc);
        }

        public CmdDesc(List<AttributedString> mainDesc, List<ArgDesc> argsDesc, Map<String, List<AttributedString>> optsDesc) {
            this.argsDesc = new ArrayList<ArgDesc>(argsDesc);
            this.optsDesc = new TreeMap<String, List<AttributedString>>(optsDesc);
            if (mainDesc.isEmpty() && optsDesc.containsKey("main")) {
                this.mainDesc = new ArrayList<AttributedString>((Collection)optsDesc.get("main"));
                this.optsDesc.remove("main");
            } else {
                this.mainDesc = new ArrayList<AttributedString>(mainDesc);
            }
            this.command = true;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected boolean isCommand() {
            return this.command;
        }

        public void setSubcommand(boolean subcommand) {
            this.subcommand = subcommand;
        }

        protected boolean isSubcommand() {
            return this.subcommand;
        }

        public CmdDesc mainDesc(List<AttributedString> mainDesc) {
            this.mainDesc = new ArrayList<AttributedString>(mainDesc);
            return this;
        }

        public void setMainDesc(List<AttributedString> mainDesc) {
            this.mainDesc = new ArrayList<AttributedString>(mainDesc);
        }

        public void setErrorPattern(Pattern errorPattern) {
            this.errorPattern = errorPattern;
        }

        public Pattern getErrorPattern() {
            return this.errorPattern;
        }

        public void setErrorIndex(int errorIndex) {
            this.errorIndex = errorIndex;
        }

        public int getErrorIndex() {
            return this.errorIndex;
        }

        protected List<ArgDesc> getArgsDesc() {
            return this.argsDesc;
        }

        protected List<AttributedString> getMainDescription(int descriptionSize) {
            return this.getMainDescription(descriptionSize, null);
        }

        protected List<AttributedString> getMainDescription(int descriptionSize, String lastArg) {
            List<AttributedString> out = new ArrayList<AttributedString>();
            if (this.mainDesc != null) {
                if (this.mainDesc.size() <= descriptionSize && lastArg == null) {
                    out = this.mainDesc;
                } else {
                    int tabs = 0;
                    int row = 0;
                    for (AttributedString as : this.mainDesc) {
                        if (as.columnLength() >= tabs) {
                            tabs = as.columnLength() + 2;
                        }
                        ++row;
                    }
                    row = 0;
                    ArrayList<AttributedString> descList = new ArrayList<AttributedString>();
                    for (int i = 0; i < descriptionSize; ++i) {
                        descList.add(new AttributedString(""));
                    }
                    for (AttributedString as : this.mainDesc) {
                        if (lastArg != null && !as.toString().startsWith(lastArg)) continue;
                        AttributedStringBuilder asb = new AttributedStringBuilder().tabs(tabs);
                        asb.append((AttributedString)descList.get(row));
                        asb.append(as);
                        asb.append("\t");
                        descList.remove(row);
                        descList.add(row, asb.toAttributedString());
                        if (++row < descriptionSize) continue;
                        row = 0;
                    }
                    out = new ArrayList(descList);
                }
            }
            return out;
        }

        protected List<AttributedString> getOptionDescription(String opt, int descriptionSize) {
            ArrayList<AttributedString> keyList;
            AttributedStringBuilder asb;
            ArrayList<AttributedString> out = new ArrayList<AttributedString>();
            if (!opt.startsWith("-")) {
                return out;
            }
            int ind = opt.indexOf("=");
            if (ind > 0) {
                opt = opt.substring(0, ind);
            }
            ArrayList<String> matched = new ArrayList<String>();
            int tabs = 0;
            block0: for (String key : this.optsDesc.keySet()) {
                for (String k : key.split("\\s+")) {
                    if (!k.trim().startsWith(opt)) continue;
                    matched.add(key);
                    if (key.length() < tabs) continue block0;
                    tabs = key.length() + 2;
                    continue block0;
                }
            }
            if (matched.size() == 1) {
                out.add(this.highlightOption((String)matched.get(0)));
                for (AttributedString as : this.optsDesc.get(matched.get(0))) {
                    asb = new AttributedStringBuilder().tabs(8);
                    asb.append("\t");
                    asb.append(as);
                    out.add(asb.toAttributedString());
                }
            } else if (matched.size() <= descriptionSize) {
                for (String key : matched) {
                    asb = new AttributedStringBuilder().tabs(tabs);
                    asb.append(this.highlightOption(key));
                    asb.append("\t");
                    asb.append(this.optionDescription(key));
                    out.add(asb.toAttributedString());
                }
            } else if (matched.size() <= 2 * descriptionSize) {
                int columnWidth;
                keyList = new ArrayList<AttributedString>();
                int row = 0;
                for (columnWidth = 2 * tabs; columnWidth < 50; columnWidth += tabs) {
                }
                for (String key : matched) {
                    AttributedStringBuilder asb2 = new AttributedStringBuilder().tabs(tabs);
                    if (row < descriptionSize) {
                        asb2.append(this.highlightOption(key));
                        asb2.append("\t");
                        asb2.append(this.optionDescription(key));
                        if (asb2.columnLength() > columnWidth - 2) {
                            AttributedString trunc = asb2.columnSubSequence(0, columnWidth - 5);
                            asb2 = new AttributedStringBuilder().tabs(tabs);
                            asb2.append(trunc);
                            asb2.append("...", new AttributedStyle(AttributedStyle.INVERSE));
                            asb2.append("  ");
                        } else {
                            for (int i = asb2.columnLength(); i < columnWidth; ++i) {
                                asb2.append(" ");
                            }
                        }
                        keyList.add(asb2.toAttributedString().columnSubSequence(0, columnWidth));
                    } else {
                        asb2.append((AttributedString)keyList.get(row - descriptionSize));
                        asb2.append(this.highlightOption(key));
                        asb2.append("\t");
                        asb2.append(this.optionDescription(key));
                        keyList.remove(row - descriptionSize);
                        keyList.add(row - descriptionSize, asb2.toAttributedString());
                    }
                    ++row;
                }
                out = new ArrayList(keyList);
            } else {
                keyList = new ArrayList();
                for (int i = 0; i < descriptionSize; ++i) {
                    keyList.add(new AttributedString(""));
                }
                int row = 0;
                for (String key : matched) {
                    AttributedStringBuilder asb3 = new AttributedStringBuilder().tabs(tabs);
                    asb3.append((AttributedString)keyList.get(row));
                    asb3.append(this.highlightOption(key));
                    asb3.append("\t");
                    keyList.remove(row);
                    keyList.add(row, asb3.toAttributedString());
                    if (++row < descriptionSize) continue;
                    row = 0;
                }
                out = new ArrayList(keyList);
            }
            return out;
        }

        protected boolean optionWithValue(String option) {
            for (String key : this.optsDesc.keySet()) {
                if (!key.matches("(^|.*\\s)" + option + "($|=.*|\\s.*)")) continue;
                return key.contains("=");
            }
            return false;
        }

        private AttributedString optionDescription(String key) {
            return this.optsDesc.get(key).size() > 0 ? this.optsDesc.get(key).get(0) : new AttributedString("");
        }

        private AttributedString highlightOption(String option) {
            return new AttributedStringBuilder().append(option, Options.HelpException.defaultStyle().resolve(".op")).toAttributedString();
        }
    }

    public static class ArgDesc {
        private String name;
        private List<AttributedString> description = new ArrayList<AttributedString>();

        public ArgDesc(String name) {
            this(name, new ArrayList<AttributedString>());
        }

        public ArgDesc(String name, List<AttributedString> description) {
            this.name = name;
            this.description = new ArrayList<AttributedString>(description);
        }

        public String getName() {
            return this.name;
        }

        public List<AttributedString> getDescription() {
            return this.description;
        }

        public static List<ArgDesc> doArgNames(List<String> names) {
            ArrayList<ArgDesc> out = new ArrayList<ArgDesc>();
            for (String n : names) {
                out.add(new ArgDesc(n));
            }
            return out;
        }
    }

    public static class CmdLine {
        private String line;
        private String head;
        private String tail;
        private List<String> args;
        private DescriptionType descType;

        public CmdLine(String line, String head, String tail, List<String> args, DescriptionType descType) {
            this.line = line;
            this.head = head;
            this.tail = tail;
            this.args = new ArrayList<String>(args);
            this.descType = descType;
        }

        public String getLine() {
            return this.line;
        }

        public String getHead() {
            return this.head;
        }

        public String getTail() {
            return this.tail;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public DescriptionType getDescriptionType() {
            return this.descType;
        }

        public static enum DescriptionType {
            COMMAND,
            METHOD,
            SYNTAX;

        }
    }

    public static class TailTipWidgets
    extends Widgets {
        private boolean enabled = false;
        private CommandDescriptions cmdDescs;
        private TipType tipType;
        private int descriptionSize = 0;
        private boolean descriptionEnabled = true;
        private boolean descriptionCache = true;

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips) {
            this(reader, tailTips, 0, TipType.COMBINED);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, TipType tipType) {
            this(reader, tailTips, 0, tipType);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, int descriptionSize) {
            this(reader, tailTips, descriptionSize, TipType.COMBINED);
        }

        public TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, int descriptionSize, TipType tipType) {
            this(reader, tailTips, descriptionSize, tipType, null);
        }

        public TailTipWidgets(LineReader reader, Function<CmdLine, CmdDesc> descFun, int descriptionSize, TipType tipType) {
            this(reader, null, descriptionSize, tipType, descFun);
        }

        private TailTipWidgets(LineReader reader, Map<String, CmdDesc> tailTips, int descriptionSize, TipType tipType, Function<CmdLine, CmdDesc> descFun) {
            super(reader);
            if (this.existsWidget(Widgets.TT_ACCEPT_LINE)) {
                throw new IllegalStateException("TailTipWidgets already created!");
            }
            this.cmdDescs = tailTips != null ? new CommandDescriptions(tailTips) : new CommandDescriptions(descFun);
            this.descriptionSize = descriptionSize;
            this.tipType = tipType;
            this.addWidget(Widgets.TT_ACCEPT_LINE, this::tailtipAcceptLine);
            this.addWidget("_tailtip-self-insert", this::tailtipInsert);
            this.addWidget("_tailtip-backward-delete-char", this::tailtipBackwardDelete);
            this.addWidget("_tailtip-delete-char", this::tailtipDelete);
            this.addWidget("_tailtip-expand-or-complete", this::tailtipComplete);
            this.addWidget("_tailtip-redisplay", this::tailtipUpdateStatus);
            this.addWidget("tailtip-window", this::toggleWindow);
            this.addWidget(Widgets.TT_TOGGLE, this::toggleKeyBindings);
        }

        public void setTailTips(Map<String, CmdDesc> tailTips) {
            this.cmdDescs.setDescriptions(tailTips);
        }

        public void setDescriptionSize(int descriptionSize) {
            this.descriptionSize = descriptionSize;
            this.initDescription(descriptionSize);
        }

        public int getDescriptionSize() {
            return this.descriptionSize;
        }

        public void setTipType(TipType type) {
            this.tipType = type;
            if (this.tipType == TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
            } else {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            }
        }

        public TipType getTipType() {
            return this.tipType;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void disable() {
            if (this.enabled) {
                this.executeWidget(Widgets.TT_TOGGLE);
            }
        }

        public void enable() {
            if (!this.enabled) {
                this.toggleKeyBindings();
            }
        }

        public void setDescriptionCache(boolean cache) {
            this.descriptionCache = cache;
        }

        public boolean tailtipComplete() {
            return this.doTailTip("expand-or-complete");
        }

        public boolean tailtipAcceptLine() {
            if (this.tipType != TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            }
            this.clearDescription();
            this.setErrorPattern(null);
            this.setErrorIndex(-1);
            this.cmdDescs.clearTemporaryDescs();
            return this.clearTailTip("accept-line");
        }

        public boolean tailtipBackwardDelete() {
            return this.doTailTip(this.autopairEnabled() ? Widgets.AP_BACKWARD_DELETE_CHAR : "backward-delete-char");
        }

        private boolean clearTailTip(String widget) {
            this.clearTailTip();
            this.callWidget(widget);
            return true;
        }

        public boolean tailtipDelete() {
            this.clearTailTip();
            return this.doTailTip("delete-char");
        }

        public boolean tailtipInsert() {
            return this.doTailTip(this.autopairEnabled() ? Widgets.AP_INSERT : "self-insert");
        }

        public boolean tailtipUpdateStatus() {
            return this.doTailTip("redisplay");
        }

        private boolean doTailTip(String widget) {
            Buffer buffer = this.buffer();
            this.callWidget(widget);
            Pair<String, Boolean> cmdkey = null;
            List<String> args = this.args();
            cmdkey = buffer.length() == buffer.cursor() ? this.cmdDescs.evaluateCommandLine(buffer.toString(), args) : this.cmdDescs.evaluateCommandLine(buffer.toString(), buffer.cursor());
            CmdDesc cmdDesc = this.cmdDescs.getDescription(cmdkey.getU());
            if (cmdDesc == null) {
                this.setErrorPattern(null);
                this.setErrorIndex(-1);
                this.clearDescription();
                this.resetTailTip();
            } else if (cmdDesc.isValid()) {
                if (cmdkey.getV().booleanValue()) {
                    if (cmdDesc.isCommand() && buffer.length() == buffer.cursor()) {
                        this.doCommandTailTip(widget, cmdDesc, args);
                    }
                } else {
                    this.doDescription(cmdDesc.getMainDescription(this.descriptionSize));
                    this.setErrorPattern(cmdDesc.getErrorPattern());
                    this.setErrorIndex(cmdDesc.getErrorIndex());
                }
            }
            return true;
        }

        private void doCommandTailTip(String widget, CmdDesc cmdDesc, List<String> args) {
            int argnum = 0;
            String prevArg = "";
            for (String a : args) {
                if (!(a.startsWith("-") || prevArg.matches("-[a-zA-Z]{1}") && cmdDesc.optionWithValue(prevArg))) {
                    ++argnum;
                }
                prevArg = a;
            }
            String lastArg = "";
            prevArg = args.get(args.size() - 1);
            if (!this.prevChar().equals(" ") && args.size() > 1) {
                lastArg = args.get(args.size() - 1);
                prevArg = args.get(args.size() - 2);
            }
            int bpsize = argnum;
            boolean doTailTip = true;
            boolean noCompleters = false;
            if (widget.endsWith("backward-delete-char")) {
                this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
                noCompleters = true;
                if (!(lastArg.startsWith("-") || prevArg.matches("-[a-zA-Z]{1}") && cmdDesc.optionWithValue(prevArg))) {
                    --bpsize;
                }
                if (this.prevChar().equals(" ")) {
                    ++bpsize;
                }
            } else if (!this.prevChar().equals(" ")) {
                doTailTip = false;
                this.doDescription(cmdDesc.getMainDescription(this.descriptionSize, cmdDesc.isSubcommand() ? lastArg : null));
            } else if (cmdDesc != null) {
                this.doDescription(cmdDesc.getMainDescription(this.descriptionSize));
            }
            if (cmdDesc != null) {
                if (lastArg.startsWith("-")) {
                    if (lastArg.matches("-[a-zA-Z]{1}[a-zA-Z0-9]+")) {
                        if (cmdDesc.optionWithValue(lastArg.substring(0, 2))) {
                            this.doDescription(cmdDesc.getOptionDescription(lastArg.substring(0, 2), this.descriptionSize));
                            this.setTipType(this.tipType);
                        } else {
                            this.doDescription(cmdDesc.getOptionDescription("-" + lastArg.substring(lastArg.length() - 1), this.descriptionSize));
                            this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
                            noCompleters = true;
                        }
                    } else {
                        this.doDescription(cmdDesc.getOptionDescription(lastArg, this.descriptionSize));
                        if (!lastArg.contains("=")) {
                            this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
                            noCompleters = true;
                        } else {
                            this.setTipType(this.tipType);
                        }
                    }
                } else if (!widget.endsWith("backward-delete-char")) {
                    this.setTipType(this.tipType);
                }
                if (bpsize > 0 && doTailTip) {
                    List<ArgDesc> params = cmdDesc.getArgsDesc();
                    if (!noCompleters) {
                        this.setSuggestionType(this.tipType == TipType.COMPLETER ? LineReader.SuggestionType.COMPLETER : LineReader.SuggestionType.TAIL_TIP);
                    }
                    if (bpsize - 1 < params.size()) {
                        if (!lastArg.startsWith("-")) {
                            List<AttributedString> d = null;
                            d = !prevArg.matches("-[a-zA-Z]{1}") || !cmdDesc.optionWithValue(prevArg) ? params.get(bpsize - 1).getDescription() : cmdDesc.getOptionDescription(prevArg, this.descriptionSize);
                            if (d == null || d.isEmpty()) {
                                d = cmdDesc.getMainDescription(this.descriptionSize, cmdDesc.isSubcommand() ? lastArg : null);
                            }
                            this.doDescription(d);
                        }
                        StringBuilder tip = new StringBuilder();
                        for (int i = bpsize - 1; i < params.size(); ++i) {
                            tip.append(params.get(i).getName());
                            tip.append(" ");
                        }
                        this.setTailTip(tip.toString());
                    } else if (!params.isEmpty() && params.get(params.size() - 1).getName().startsWith("[")) {
                        this.setTailTip(params.get(params.size() - 1).getName());
                        this.doDescription(params.get(params.size() - 1).getDescription());
                    }
                } else if (doTailTip) {
                    this.resetTailTip();
                }
            } else {
                this.clearDescription();
                this.resetTailTip();
            }
        }

        private void resetTailTip() {
            this.setTailTip("");
            if (this.tipType != TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            }
        }

        private void doDescription(List<AttributedString> desc) {
            if (this.descriptionSize == 0 || !this.descriptionEnabled) {
                return;
            }
            if (desc.isEmpty()) {
                this.clearDescription();
            } else if (desc.size() == this.descriptionSize) {
                this.addDescription(desc);
            } else if (desc.size() > this.descriptionSize) {
                AttributedStringBuilder asb = new AttributedStringBuilder();
                asb.append(desc.get(this.descriptionSize - 1)).append("...", new AttributedStyle(AttributedStyle.INVERSE));
                ArrayList<AttributedString> mod = new ArrayList<AttributedString>(desc.subList(0, this.descriptionSize - 1));
                mod.add(asb.toAttributedString());
                this.addDescription(mod);
            } else if (desc.size() < this.descriptionSize) {
                while (desc.size() != this.descriptionSize) {
                    desc.add(new AttributedString(""));
                }
                this.addDescription(desc);
            }
        }

        private boolean autopairEnabled() {
            Binding binding = this.getKeyMap().getBound("(");
            return binding instanceof Reference && ((Reference)binding).name().equals(Widgets.AP_INSERT);
        }

        public boolean toggleWindow() {
            boolean bl = this.descriptionEnabled = !this.descriptionEnabled;
            if (this.descriptionEnabled) {
                this.initDescription(this.descriptionSize);
            } else {
                this.destroyDescription();
            }
            return true;
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
                this.destroyDescription();
            } else {
                this.customBindings();
                if (this.descriptionEnabled) {
                    this.initDescription(this.descriptionSize);
                }
            }
            return this.enabled;
        }

        private boolean defaultBindings() {
            if (!this.enabled) {
                return false;
            }
            this.aliasWidget(".accept-line", "accept-line");
            this.aliasWidget(".backward-delete-char", "backward-delete-char");
            this.aliasWidget(".delete-char", "delete-char");
            this.aliasWidget(".expand-or-complete", "expand-or-complete");
            this.aliasWidget(".self-insert", "self-insert");
            this.aliasWidget(".redisplay", "redisplay");
            KeyMap<Binding> map = this.getKeyMap();
            map.bind((Binding)new Reference("insert-close-paren"), (CharSequence)")");
            this.setSuggestionType(LineReader.SuggestionType.NONE);
            if (this.autopairEnabled()) {
                this.callWidget(Widgets.AP_TOGGLE);
                this.callWidget(Widgets.AP_TOGGLE);
            }
            this.enabled = false;
            return true;
        }

        private void customBindings() {
            if (this.enabled) {
                return;
            }
            this.aliasWidget(Widgets.TT_ACCEPT_LINE, "accept-line");
            this.aliasWidget("_tailtip-backward-delete-char", "backward-delete-char");
            this.aliasWidget("_tailtip-delete-char", "delete-char");
            this.aliasWidget("_tailtip-expand-or-complete", "expand-or-complete");
            this.aliasWidget("_tailtip-self-insert", "self-insert");
            this.aliasWidget("_tailtip-redisplay", "redisplay");
            KeyMap<Binding> map = this.getKeyMap();
            map.bind((Binding)new Reference("_tailtip-self-insert"), (CharSequence)")");
            if (this.tipType != TipType.TAIL_TIP) {
                this.setSuggestionType(LineReader.SuggestionType.COMPLETER);
            } else {
                this.setSuggestionType(LineReader.SuggestionType.TAIL_TIP);
            }
            this.enabled = true;
        }

        private class CommandDescriptions {
            Map<String, CmdDesc> descriptions = new HashMap<String, CmdDesc>();
            Map<String, CmdDesc> temporaryDescs = new HashMap<String, CmdDesc>();
            Map<String, CmdDesc> volatileDescs = new HashMap<String, CmdDesc>();
            Function<CmdLine, CmdDesc> descFun;

            public CommandDescriptions(Map<String, CmdDesc> descriptions) {
                this.descriptions = new HashMap<String, CmdDesc>(descriptions);
            }

            public CommandDescriptions(Function<CmdLine, CmdDesc> descFun) {
                this.descFun = descFun;
            }

            public void setDescriptions(Map<String, CmdDesc> descriptions) {
                this.descriptions = new HashMap<String, CmdDesc>(descriptions);
            }

            public Pair<String, Boolean> evaluateCommandLine(String line, int curPos) {
                return this.evaluateCommandLine(line, TailTipWidgets.this.args(), curPos);
            }

            public Pair<String, Boolean> evaluateCommandLine(String line, List<String> args) {
                return this.evaluateCommandLine(line, args, line.length());
            }

            private Pair<String, Boolean> evaluateCommandLine(String line, List<String> args, int curPos) {
                String cmd = null;
                CmdLine.DescriptionType descType = CmdLine.DescriptionType.METHOD;
                String head = line.substring(0, curPos);
                String tail = line.substring(curPos);
                if (TailTipWidgets.this.prevChar().equals(")")) {
                    descType = CmdLine.DescriptionType.SYNTAX;
                    cmd = head;
                } else {
                    int i;
                    if (line.length() == curPos) {
                        cmd = args != null && (args.size() > 1 || args.size() == 1 && line.endsWith(" ")) ? TailTipWidgets.this.parser().getCommand(args.get(0)) : null;
                        descType = CmdLine.DescriptionType.COMMAND;
                    }
                    int brackets = 0;
                    for (i = head.length() - 1; i >= 0; --i) {
                        if (head.charAt(i) == ')') {
                            ++brackets;
                        } else if (head.charAt(i) == '(') {
                            --brackets;
                        }
                        if (brackets >= 0) continue;
                        descType = CmdLine.DescriptionType.METHOD;
                        cmd = head = head.substring(0, i);
                        break;
                    }
                    if (descType == CmdLine.DescriptionType.METHOD) {
                        brackets = 0;
                        for (i = 0; i < tail.length(); ++i) {
                            if (tail.charAt(i) == ')') {
                                ++brackets;
                            } else if (tail.charAt(i) == '(') {
                                --brackets;
                            }
                            if (brackets <= 0) continue;
                            tail = tail.substring(i + 1);
                            break;
                        }
                    }
                }
                if (cmd != null && this.descFun != null) {
                    if (!TailTipWidgets.this.descriptionCache && descType == CmdLine.DescriptionType.COMMAND) {
                        CmdDesc c = this.descFun.apply(new CmdLine(line, head, tail, args, descType));
                        this.volatileDescs.put(cmd, c);
                    } else if (!this.descriptions.containsKey(cmd) && !this.temporaryDescs.containsKey(cmd)) {
                        if (descType == CmdLine.DescriptionType.COMMAND) {
                            CmdDesc c = this.descFun.apply(new CmdLine(line, head, tail, args, descType));
                            if (c != null) {
                                this.descriptions.put(cmd, c);
                            } else {
                                this.temporaryDescs.put(cmd, c);
                            }
                        } else if (descType == CmdLine.DescriptionType.METHOD) {
                            this.temporaryDescs.put(cmd, this.descFun.apply(new CmdLine(line, head, tail, args, descType)));
                        } else {
                            this.temporaryDescs.put(cmd, this.descFun.apply(new CmdLine(line, head, tail, args, descType)));
                        }
                    }
                }
                return new Pair<String, Boolean>(cmd, descType == CmdLine.DescriptionType.COMMAND);
            }

            public CmdDesc getDescription(String command) {
                CmdDesc out = null;
                if (this.descriptions.containsKey(command)) {
                    out = this.descriptions.get(command);
                } else if (this.temporaryDescs.containsKey(command)) {
                    out = this.temporaryDescs.get(command);
                } else if (this.volatileDescs.containsKey(command)) {
                    out = this.volatileDescs.get(command);
                    this.volatileDescs.remove(command);
                }
                return out;
            }

            public void clearTemporaryDescs() {
                this.temporaryDescs = new HashMap<String, CmdDesc>();
            }
        }

        public static enum TipType {
            TAIL_TIP,
            COMPLETER,
            COMBINED;

        }
    }

    public static class AutosuggestionWidgets
    extends Widgets {
        private boolean enabled = false;

        public AutosuggestionWidgets(LineReader reader) {
            super(reader);
            if (this.existsWidget("_autosuggest-forward-char")) {
                throw new IllegalStateException("AutosuggestionWidgets already created!");
            }
            this.addWidget("_autosuggest-forward-char", this::autosuggestForwardChar);
            this.addWidget("_autosuggest-end-of-line", this::autosuggestEndOfLine);
            this.addWidget("_autosuggest-forward-word", this::partialAccept);
            this.addWidget("autosuggest-toggle", this::toggleKeyBindings);
        }

        public void disable() {
            this.defaultBindings();
        }

        public void enable() {
            this.customBindings();
        }

        public boolean partialAccept() {
            Buffer buffer = this.buffer();
            if (buffer.cursor() == buffer.length()) {
                int curPos = buffer.cursor();
                buffer.write(this.tailTip());
                buffer.cursor(curPos);
                this.replaceBuffer(buffer);
                this.callWidget("forward-word");
                BufferImpl newBuf = new BufferImpl();
                newBuf.write(this.buffer().substring(0, this.buffer().cursor()));
                this.replaceBuffer(newBuf);
            } else {
                this.callWidget("forward-word");
            }
            return true;
        }

        public boolean autosuggestForwardChar() {
            return this.accept("forward-char");
        }

        public boolean autosuggestEndOfLine() {
            return this.accept("end-of-line");
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
            } else {
                this.customBindings();
            }
            return this.enabled;
        }

        private boolean accept(String widget) {
            Buffer buffer = this.buffer();
            if (buffer.cursor() == buffer.length()) {
                this.putString(this.tailTip());
            } else {
                this.callWidget(widget);
            }
            return true;
        }

        private void customBindings() {
            if (this.enabled) {
                return;
            }
            this.aliasWidget("_autosuggest-forward-char", "forward-char");
            this.aliasWidget("_autosuggest-end-of-line", "end-of-line");
            this.aliasWidget("_autosuggest-forward-word", "forward-word");
            this.enabled = true;
            this.setSuggestionType(LineReader.SuggestionType.HISTORY);
        }

        private void defaultBindings() {
            if (!this.enabled) {
                return;
            }
            this.aliasWidget(".forward-char", "forward-char");
            this.aliasWidget(".end-of-line", "end-of-line");
            this.aliasWidget(".forward-word", "forward-word");
            this.enabled = false;
            this.setSuggestionType(LineReader.SuggestionType.NONE);
        }
    }

    public static class AutopairWidgets
    extends Widgets {
        private static final Map<String, String> LBOUNDS = new HashMap<String, String>();
        private static final Map<String, String> RBOUNDS;
        private final Map<String, String> pairs;
        private final Map<String, Binding> defaultBindings = new HashMap<String, Binding>();
        private boolean enabled;

        public AutopairWidgets(LineReader reader) {
            this(reader, false);
        }

        public AutopairWidgets(LineReader reader, boolean addCurlyBrackets) {
            super(reader);
            this.pairs = new HashMap<String, String>();
            this.pairs.put("`", "`");
            this.pairs.put("'", "'");
            this.pairs.put("\"", "\"");
            this.pairs.put("[", "]");
            this.pairs.put("(", ")");
            this.pairs.put(" ", " ");
            if (this.existsWidget(Widgets.AP_INSERT)) {
                throw new IllegalStateException("AutopairWidgets already created!");
            }
            if (addCurlyBrackets) {
                this.pairs.put("{", "}");
            }
            this.addWidget(Widgets.AP_INSERT, this::autopairInsert);
            this.addWidget("_autopair-close", this::autopairClose);
            this.addWidget(Widgets.AP_BACKWARD_DELETE_CHAR, this::autopairDelete);
            this.addWidget(Widgets.AP_TOGGLE, this::toggleKeyBindings);
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                this.defaultBindings.put(p.getKey(), map.getBound(p.getKey()));
                if (p.getKey().equals(p.getValue())) continue;
                this.defaultBindings.put(p.getValue(), map.getBound(p.getValue()));
            }
        }

        public void enable() {
            if (!this.enabled) {
                this.executeWidget(Widgets.AP_TOGGLE);
            }
        }

        public void disable() {
            if (this.enabled) {
                this.executeWidget(Widgets.AP_TOGGLE);
            }
        }

        public boolean toggle() {
            boolean before = this.enabled;
            this.executeWidget(Widgets.AP_TOGGLE);
            return !before;
        }

        public boolean autopairInsert() {
            if (this.pairs.containsKey(this.lastBinding())) {
                if (this.canSkip(this.lastBinding())) {
                    this.callWidget("forward-char");
                } else if (this.canPair(this.lastBinding())) {
                    this.callWidget("self-insert");
                    this.putString(this.pairs.get(this.lastBinding()));
                    this.callWidget("backward-char");
                } else {
                    this.callWidget("self-insert");
                }
            } else {
                this.callWidget("self-insert");
            }
            return true;
        }

        public boolean autopairClose() {
            if (this.pairs.containsValue(this.lastBinding()) && this.currChar().equals(this.lastBinding())) {
                this.callWidget("forward-char");
            } else {
                this.callWidget("self-insert");
            }
            return true;
        }

        public boolean autopairDelete() {
            if (this.pairs.containsKey(this.prevChar()) && this.pairs.get(this.prevChar()).equals(this.currChar()) && this.canDelete(this.prevChar())) {
                this.callWidget("delete-char");
            }
            this.callWidget("backward-delete-char");
            return true;
        }

        public boolean toggleKeyBindings() {
            if (this.enabled) {
                this.defaultBindings();
            } else {
                this.customBindings();
            }
            return this.enabled;
        }

        private void customBindings() {
            boolean ttActive = this.tailtipEnabled();
            if (ttActive) {
                this.callWidget(Widgets.TT_TOGGLE);
            }
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                map.bind((Binding)new Reference(Widgets.AP_INSERT), (CharSequence)p.getKey());
                if (p.getKey().equals(p.getValue())) continue;
                map.bind((Binding)new Reference("_autopair-close"), (CharSequence)p.getValue());
            }
            this.aliasWidget(Widgets.AP_BACKWARD_DELETE_CHAR, "backward-delete-char");
            if (ttActive) {
                this.callWidget(Widgets.TT_TOGGLE);
            }
            this.enabled = true;
        }

        private void defaultBindings() {
            KeyMap<Binding> map = this.getKeyMap();
            for (Map.Entry<String, String> p : this.pairs.entrySet()) {
                map.bind(this.defaultBindings.get(p.getKey()), (CharSequence)p.getKey());
                if (p.getKey().equals(p.getValue())) continue;
                map.bind(this.defaultBindings.get(p.getValue()), (CharSequence)p.getValue());
            }
            this.aliasWidget(".backward-delete-char", "backward-delete-char");
            if (this.tailtipEnabled()) {
                this.callWidget(Widgets.TT_TOGGLE);
                this.callWidget(Widgets.TT_TOGGLE);
            }
            this.enabled = false;
        }

        private boolean tailtipEnabled() {
            return this.getWidget("accept-line").equals(Widgets.TT_ACCEPT_LINE);
        }

        private boolean canPair(String d) {
            if (this.balanced(d) && !this.nexToBoundary(d)) {
                return !d.equals(" ") || !this.prevChar().equals(" ") && !this.currChar().equals(" ");
            }
            return false;
        }

        private boolean canSkip(String d) {
            return this.pairs.get(d).equals(d) && d.charAt(0) != ' ' && this.currChar().equals(d) && this.balanced(d);
        }

        private boolean canDelete(String d) {
            return this.balanced(d);
        }

        private boolean balanced(String d) {
            boolean out = false;
            Buffer buf = this.buffer();
            String lbuf = buf.upToCursor();
            String rbuf = buf.substring(lbuf.length());
            String regx1 = this.pairs.get(d).equals(d) ? d : "\\" + d;
            String regx2 = this.pairs.get(d).equals(d) ? this.pairs.get(d) : "\\" + this.pairs.get(d);
            int llen = lbuf.length() - lbuf.replaceAll(regx1, "").length();
            int rlen = rbuf.length() - rbuf.replaceAll(regx2, "").length();
            if (llen == 0 && rlen == 0) {
                out = true;
            } else if (d.charAt(0) == ' ') {
                out = true;
            } else if (this.pairs.get(d).equals(d)) {
                if (llen == rlen || (llen + rlen) % 2 == 0) {
                    out = true;
                }
            } else {
                int l2len = lbuf.length() - lbuf.replaceAll(regx2, "").length();
                int r2len = rbuf.length() - rbuf.replaceAll(regx1, "").length();
                int ltotal = llen - l2len;
                int rtotal = rlen - r2len;
                if (ltotal < 0) {
                    ltotal = 0;
                }
                if (ltotal >= rtotal) {
                    out = true;
                }
            }
            return out;
        }

        private boolean boundary(String lb, String rb) {
            return lb.length() > 0 && this.prevChar().matches(lb) || rb.length() > 0 && this.currChar().matches(rb);
        }

        private boolean nexToBoundary(String d) {
            ArrayList<String> bk = new ArrayList<String>();
            bk.add("all");
            if (d.matches("['\"`]")) {
                bk.add("quotes");
            } else if (d.matches("[{\\[(<]")) {
                bk.add("braces");
            } else if (d.charAt(0) == ' ') {
                bk.add("spaces");
            }
            if (LBOUNDS.containsKey(d) && RBOUNDS.containsKey(d)) {
                bk.add(d);
            }
            for (String k : bk) {
                if (!this.boundary(LBOUNDS.get(k), RBOUNDS.get(k))) continue;
                return true;
            }
            return false;
        }

        static {
            LBOUNDS.put("all", "[.:/\\!]");
            LBOUNDS.put("quotes", "[\\]})a-zA-Z0-9]");
            LBOUNDS.put("spaces", "[^{(\\[]");
            LBOUNDS.put("braces", "");
            LBOUNDS.put("`", "`");
            LBOUNDS.put("\"", "\"");
            LBOUNDS.put("'", "'");
            RBOUNDS = new HashMap<String, String>();
            RBOUNDS.put("all", "[\\[{(<,.:?/%$!a-zA-Z0-9]");
            RBOUNDS.put("quotes", "[a-zA-Z0-9]");
            RBOUNDS.put("spaces", "[^\\]})]");
            RBOUNDS.put("braces", "");
            RBOUNDS.put("`", "");
            RBOUNDS.put("\"", "");
            RBOUNDS.put("'", "");
        }
    }
}

