/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionsUtil {
    public static void assertArity(String fnName, VncList args, int ... expectedArities) {
        int arity = args.size();
        for (int a : expectedArities) {
            if (a != arity) continue;
            return;
        }
        throw new ArityException(arity, fnName);
    }

    public static void assertMinArity(String fnName, VncList args, int minArity) {
        int arity = args.size();
        if (arity < minArity) {
            throw new ArityException(arity, fnName);
        }
    }

    public static VncList removeNilValues(VncList list) {
        return new VncList(FunctionsUtil.removeNilValues(list.getList()));
    }

    public static List<VncVal> removeNilValues(List<VncVal> items) {
        return items.stream().filter(v -> v != Constants.Nil).collect(Collectors.toList());
    }
}

