/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.VncException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class CIDR {
    private final String cidr;
    private final InetAddress startAddress;
    private final InetAddress endAddress;
    private final BigInteger startAddressBigInt;
    private final BigInteger endAddressBigInt;

    private CIDR(String cidr, InetAddress startAddress, InetAddress endAddress) {
        this.cidr = cidr;
        this.startAddress = startAddress;
        this.endAddress = endAddress;
        this.startAddressBigInt = new BigInteger(1, startAddress.getAddress());
        this.endAddressBigInt = new BigInteger(1, endAddress.getAddress());
    }

    public static CIDR parse(String cidr) {
        if (cidr.contains("/")) {
            try {
                int targetSize;
                ByteBuffer maskBuffer;
                int index = cidr.indexOf("/");
                String addressPart = cidr.substring(0, index);
                String networkPart = cidr.substring(index + 1);
                InetAddress inetAddress = InetAddress.getByName(addressPart);
                int prefixLength = Integer.parseInt(networkPart);
                if (inetAddress.getAddress().length == 4) {
                    maskBuffer = ByteBuffer.allocate(4).putInt(-1);
                    targetSize = 4;
                } else {
                    maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
                    targetSize = 16;
                }
                BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(prefixLength);
                ByteBuffer buffer = ByteBuffer.wrap(inetAddress.getAddress());
                BigInteger ipVal = new BigInteger(1, buffer.array());
                BigInteger startIp = ipVal.and(mask);
                BigInteger endIp = startIp.add(mask.not());
                byte[] startIpArr = CIDR.toBytes(startIp.toByteArray(), targetSize);
                byte[] endIpArr = CIDR.toBytes(endIp.toByteArray(), targetSize);
                return new CIDR(cidr, InetAddress.getByAddress(startIpArr), InetAddress.getByAddress(endIpArr));
            }
            catch (UnknownHostException ex) {
                throw new VncException("Invalid CIDR IP block '" + cidr + "'", ex);
            }
        }
        throw new VncException("Invalid CIDR IP block '" + cidr + "'");
    }

    private static byte[] toBytes(byte[] array, int targetSize) {
        int arr_len = array.length > targetSize ? targetSize : array.length;
        int arr_off = array.length > targetSize ? array.length - targetSize : 0;
        ByteBuffer buf = ByteBuffer.allocate(targetSize);
        buf.position(targetSize - arr_len);
        buf.put(array, arr_off, arr_len);
        return buf.array();
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getStartAddress() {
        return this.startAddress.getHostAddress();
    }

    public String getEndAddress() {
        return this.endAddress.getHostAddress();
    }

    public boolean isInRange(InetAddress ipAddress) {
        BigInteger target = new BigInteger(1, ipAddress.getAddress());
        int st = this.startAddressBigInt.compareTo(target);
        int te = target.compareTo(this.endAddressBigInt);
        return !(st != -1 && st != 0 || te != -1 && te != 0);
    }

    public boolean isInRange(String ipAddress) {
        try {
            return this.isInRange(InetAddress.getByName(ipAddress));
        }
        catch (Exception ex) {
            throw new VncException("Invalid IP address '" + ipAddress + "'", ex);
        }
    }

    public String toString() {
        return String.format("%s: [%s .. %s]", this.cidr, this.startAddress, this.endAddress);
    }
}

