/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.functions.JsonFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.repl.CustomREPL;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.ClassPathResource;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.FileUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class Launcher {
    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        AcceptAllInterceptor interceptor = new AcceptAllInterceptor();
        JavaInterop.register(interceptor);
        List<String> loadPaths = LoadPath.parseFromString(cli.switchValue("-loadpath"));
        boolean macroexpand = cli.switchPresent("-macroexpand");
        try {
            if (cli.switchPresent("-file")) {
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-file"));
                String script = new String(FileUtil.load(new File(file)));
                System.out.println(Launcher.runScript(cli, loadPaths, macroexpand, interceptor, script, new File(file).getName()));
            } else if (cli.switchPresent("-cp-file")) {
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-cp-file"));
                String script = new ClassPathResource(file).getResourceAsString();
                System.out.println(Launcher.runScript(cli, loadPaths, macroexpand, interceptor, script, new File(file).getName()));
            } else if (cli.switchPresent("-script")) {
                String script = cli.switchValue("-script");
                System.out.println(Launcher.runScript(cli, loadPaths, macroexpand, interceptor, script, "script"));
            } else if (cli.switchPresent("-app")) {
                File appFile = new File(Launcher.suffixWithZipFileExt(cli.switchValue("-app")));
                VncMap manifest = Launcher.getManifest(appFile);
                String appName = Coerce.toVncString(manifest.get(new VncString("app-name"))).getValue();
                String mainFile = Coerce.toVncString(manifest.get(new VncString("main-file"))).getValue();
                System.out.println(String.format("Launching Venice application '%s' ...", appName));
                String appBootstrap = String.format("(do (load-file \"%s\") nil)", Launcher.stripVeniceFileExt(mainFile));
                Launcher.runApp(cli, macroexpand, interceptor, appBootstrap, appName, appFile);
            } else if (cli.switchPresent("-app-repl")) {
                String file = cli.switchValue("-app-repl");
                new CustomREPL(interceptor, loadPaths, new File(file)).run(args);
            } else if (cli.switchPresent("-repl")) {
                new REPL(interceptor, loadPaths).run(args);
            } else {
                new REPL(interceptor, loadPaths).run(args);
            }
            System.exit(SystemFunctions.SYSTEM_EXIT_CODE.get());
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(99);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(99);
        }
    }

    private static String runApp(CommandLineArgs cli, boolean macroexpand, IInterceptor interceptor, String script, String name, File appArchive) {
        List<String> loadPaths = Arrays.asList(appArchive.getAbsolutePath());
        VeniceInterpreter venice = new VeniceInterpreter(interceptor, loadPaths);
        Env env = Launcher.createEnv(venice, macroexpand, new VncKeyword("app"), Arrays.asList(Launcher.convertCliArgsToVar(cli), Launcher.convertAppNameToVar(name), Launcher.convertAppArchiveToVar(appArchive)));
        return venice.PRINT(venice.RE(script, name, env));
    }

    private static String runScript(CommandLineArgs cli, List<String> loadPaths, boolean macroexpand, IInterceptor interceptor, String script, String name) {
        VeniceInterpreter venice = new VeniceInterpreter(interceptor, loadPaths);
        Env env = Launcher.createEnv(venice, macroexpand, new VncKeyword("script"), Arrays.asList(Launcher.convertCliArgsToVar(cli)));
        return venice.PRINT(venice.RE(script, name, env, macroexpand));
    }

    private static Env createEnv(VeniceInterpreter venice, boolean macroexpand, VncKeyword runMode, List<Var> vars) {
        return venice.createEnv(macroexpand, false, runMode).addGlobalVars(vars).setStdoutPrintStream(new PrintStream(System.out, true)).setStderrPrintStream(new PrintStream(System.err, true));
    }

    private static Var convertAppNameToVar(String appName) {
        return new Var(new VncSymbol("*app-name*"), new VncString(appName), false);
    }

    private static Var convertAppArchiveToVar(File appArchive) {
        return new Var(new VncSymbol("*app-archive*"), new VncJavaObject(appArchive), false);
    }

    private static Var convertCliArgsToVar(CommandLineArgs cli) {
        return new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false);
    }

    private static String stripVeniceFileExt(String s) {
        return StringUtil.removeEnd(s, ".venice");
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s == null ? null : (s.endsWith(".venice") ? s : s + ".venice");
    }

    private static String suffixWithZipFileExt(String s) {
        return s == null ? null : (s.endsWith(".zip") ? s : s + ".zip");
    }

    private static VncMap getManifest(File app) {
        if (app.exists()) {
            try {
                VncString manifest = ZipFileSystemUtil.loadTextFileFromZip(app, new File("MANIFEST.MF"), "utf-8");
                return Coerce.toVncMap(JsonFunctions.read_str.apply(VncList.of(manifest)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to load manifest from Venice application archive '%s'.", app.getPath()));
            }
        }
        throw new VncException(String.format("The Venice application archive '%s' does not exist", app.getPath()));
    }
}

