/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.ArrayFunctions;
import com.github.jlangch.venice.impl.javainterop.Invoker;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncTinyVector;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ReturnValue;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VncJavaObject
extends VncMap
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Object delegate;
    private final Class<?> delegateFormalType;

    public VncJavaObject(Object obj) {
        this(obj, null, Constants.Nil);
    }

    public VncJavaObject(Object obj, VncVal meta) {
        this(obj, null, meta);
    }

    private VncJavaObject(Object obj, Class<?> formalType, VncVal meta) {
        super(meta);
        this.delegate = obj instanceof VncVal ? ((VncVal)obj).convertToJavaObject() : obj;
        this.delegateFormalType = formalType;
    }

    public static VncJavaObject from(ReturnValue val) {
        return new VncJavaObject(val.getValue(), val.getFormalType(), Constants.Nil);
    }

    public static VncJavaObject from(Object val, Class<?> formalType) {
        return new VncJavaObject(val, formalType, Constants.Nil);
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public Class<?> getDelegateFormalType() {
        return this.delegateFormalType;
    }

    @Override
    public VncMap emptyWithMeta() {
        throw new VncException("not supported");
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals) {
        throw new VncException("not supported");
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap withMeta(VncVal meta) {
        return new VncJavaObject(this.delegate, meta);
    }

    public VncJavaObject castTo(Class<?> clazz) {
        return VncJavaObject.from(this.delegate, clazz);
    }

    public VncVal getProperty(VncString name) {
        return JavaInteropUtil.convertToVncVal(JavaInterop.getInterceptor().onGetBeanProperty(new Invoker(), this.delegate, name.getValue()));
    }

    public void setProperty(VncString name, VncVal value) {
        JavaInterop.getInterceptor().onSetBeanProperty(new Invoker(), this.delegate, name.getValue(), value.convertToJavaObject());
    }

    @Override
    public Map<VncVal, VncVal> getMap() {
        return this.convertBean().getMap();
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return this.getMap().containsKey(key) ? Constants.True : Constants.False;
    }

    @Override
    public VncVal get(VncVal key) {
        return this.getProperty((VncString)key);
    }

    @Override
    public VncList keys() {
        return new VncList(new ArrayList<VncVal>(this.getMap().keySet()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.getMap().entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncMap putAll(VncMap map) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap assoc(VncVal ... mvs) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap assoc(VncSequence mvs) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap dissoc(VncVal ... keys) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap dissoc(VncSequence keys) {
        throw new VncException("not supported");
    }

    @Override
    public VncList toVncList() {
        return VncTinyList.empty();
    }

    @Override
    public VncVector toVncVector() {
        return VncTinyVector.empty();
    }

    public VncMap toVncMap() {
        return new VncHashMap(this.getMap());
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.JAVAOBJECT;
    }

    @Override
    public Object convertToJavaObject() {
        return this.delegate;
    }

    @Override
    public int compareTo(VncVal o) {
        if (this.delegate instanceof Comparable) {
            Object other;
            if (Types.isVncJavaObject(o) && (other = ((VncJavaObject)o).getDelegate()) instanceof Comparable) {
                return ((Comparable)this.delegate).compareTo((Comparable)other);
            }
        } else if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaObject other = (VncJavaObject)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return this.isArray() ? ArrayFunctions.arrayToString(this) : this.delegate.toString();
    }

    @Override
    public String toString(boolean print_readably) {
        return this.toString();
    }

    public boolean isArray() {
        return ReflectionTypes.isArrayType(this.delegate.getClass());
    }

    private VncHashMap convertBean() {
        VncHashMap.Builder builder = new VncHashMap.Builder();
        IInterceptor interceptor = JavaInterop.getInterceptor();
        Invoker invoker = new Invoker();
        ReflectionAccessor.getBeanGetterProperties(this.delegate).forEach(property -> {
            try {
                builder.put(new VncKeyword((String)property), JavaInteropUtil.convertToVncVal(interceptor.onGetBeanProperty(invoker, this.delegate, (String)property)));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        return builder.build();
    }
}

