/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.concurrent;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.impl.util.Watchable;
import com.github.jlangch.venice.impl.util.concurrent.StripedExecutorService;
import com.github.jlangch.venice.impl.util.concurrent.StripedRunnable;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Agent
implements IDeref {
    private static final VncKeyword ERROR_HANDLER = new VncKeyword("error-handler");
    private static final VncKeyword ERROR_MODE = new VncKeyword("error-mode");
    private static final VncKeyword ERROR_MODE_CONTINUE = new VncKeyword("continue");
    private static final VncKeyword ERROR_MODE_FAIL = new VncKeyword("fail");
    private final AtomicReference<VncFunction> errorHandler = new AtomicReference();
    private final AtomicReference<Value> value = new AtomicReference<Value>(new Value(Constants.Nil, null));
    private final Watchable watchable = new Watchable();
    private final long id = agentCounter.getAndIncrement();
    private final boolean continueOnError;
    private static final AtomicLong agentCounter = new AtomicLong(0L);
    private static final AtomicLong sendThreadPoolCounter = new AtomicLong(0L);
    private static final AtomicLong sendOffThreadPoolCounter = new AtomicLong(0L);
    private static final ExecutorService sendExecutor = new StripedExecutorService(Executors.newFixedThreadPool(2 + Runtime.getRuntime().availableProcessors(), ThreadPoolUtil.createThreadFactory("venice-agent-send-pool-%d", sendThreadPoolCounter, true)));
    private static final ExecutorService sendOffExecutor = new StripedExecutorService(Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("venice-agent-send-off-pool-%d", sendOffThreadPoolCounter, true)));

    public Agent(VncVal state, VncList options) {
        this.value.set(new Value(state == null ? Constants.Nil : state, null));
        VncHashMap opts = VncHashMap.ofAll(options);
        this.errorHandler.set(Agent.getErrorHandler(opts));
        VncKeyword errMode = Agent.getErrorMode(opts);
        this.continueOnError = errMode == null ? true : errMode.equals(ERROR_MODE_CONTINUE);
    }

    public long getID() {
        return this.id;
    }

    @Override
    public VncVal deref() {
        return this.value.get().deref();
    }

    public RuntimeException getError() {
        return this.value.get().getException();
    }

    public void send(VncFunction fn, VncList args) {
        sendExecutor.execute(new Action(this, fn, args, SendType.SEND, JavaInterop.getInterceptor(), ThreadLocalMap.getValues()));
    }

    public void send_off(VncFunction fn, VncList args) {
        sendOffExecutor.execute(new Action(this, fn, args, SendType.SEND_OFF, JavaInterop.getInterceptor(), ThreadLocalMap.getValues()));
    }

    public void restart(VncVal state) {
        this.value.set(new Value(state, null));
    }

    public void addWatch(VncKeyword name, VncFunction fn) {
        this.watchable.addWatch(name, fn);
    }

    public void removeWatch(VncKeyword name) {
        this.watchable.removeWatch(name);
    }

    public void setErrorHandler(VncFunction errorHandler) {
        this.errorHandler.set(errorHandler);
    }

    public VncKeyword getErrorMode() {
        return this.continueOnError ? ERROR_MODE_CONTINUE : ERROR_MODE_FAIL;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean print_readably) {
        Value v = this.value.get();
        StringBuilder sb = new StringBuilder();
        sb.append("(agent ");
        if (v.ex != null) {
            sb.append(":error ");
            sb.append(v.ex.getClass().getName());
        }
        sb.append(":value ");
        sb.append(Printer.pr_str(v.val, print_readably));
        sb.append(")");
        return sb.toString();
    }

    public static boolean await(List<Agent> agents, long timeoutMillis) {
        final CountDownLatch latch = new CountDownLatch(agents.size() * 2);
        VncFunction fn = new VncFunction(VncFunction.createAnonymousFuncName()){
            private static final long serialVersionUID = 1L;

            @Override
            public VncVal apply(VncList args) {
                latch.countDown();
                return args.first();
            }
        };
        try {
            agents.forEach(a -> a.send(fn, VncTinyList.empty()));
            agents.forEach(a -> a.send_off(fn, VncTinyList.empty()));
            if (timeoutMillis <= 0L) {
                latch.await();
                return true;
            }
            return latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("Interrupted while waiting for agents (await agents).");
        }
        catch (Exception ex) {
            throw new VncException("Failed awaiting for agents", ex);
        }
    }

    public static void shutdown() {
        sendExecutor.shutdown();
        sendOffExecutor.shutdown();
    }

    public static boolean isShutdown() {
        return sendExecutor.isShutdown() && sendOffExecutor.isShutdown();
    }

    public static void awaitTermination(long timeoutMillis) {
        try {
            sendExecutor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
            sendOffExecutor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new VncException("Failed awaiting for executor termination", ex);
        }
    }

    public static boolean isTerminated() {
        return sendExecutor.isTerminated() && sendOffExecutor.isTerminated();
    }

    private static VncFunction getErrorHandler(VncMap options) {
        VncVal errHandler;
        if (options != null && (errHandler = options.get(ERROR_HANDLER)) != Constants.Nil) {
            return Coerce.toVncFunction(errHandler);
        }
        return null;
    }

    private static VncKeyword getErrorMode(VncMap options) {
        VncConstant mode;
        VncVal vncVal = mode = options == null ? Constants.Nil : options.get(ERROR_MODE);
        if (mode == Constants.Nil) {
            return null;
        }
        VncKeyword errMode = Coerce.toVncKeyword(mode);
        if (errMode.equals(ERROR_MODE_CONTINUE)) {
            return ERROR_MODE_CONTINUE;
        }
        if (errMode.equals(ERROR_MODE_FAIL)) {
            return ERROR_MODE_FAIL;
        }
        return null;
    }

    private static enum SendType {
        SEND,
        SEND_OFF;

    }

    private static class Value {
        private final VncVal val;
        private final RuntimeException ex;

        public Value(VncVal val, RuntimeException ex) {
            this.val = val;
            this.ex = ex;
        }

        public VncVal deref() {
            if (this.ex != null) {
                throw this.ex;
            }
            return this.val;
        }

        public RuntimeException getException() {
            return this.ex;
        }
    }

    private static class Action
    implements StripedRunnable {
        private final Agent agent;
        private final VncFunction fn;
        private final VncList fnArgs;
        private final SendType sendType;
        private final IInterceptor interceptor;
        private final AtomicReference<Map<VncKeyword, VncVal>> threadLocalValues = new AtomicReference();

        public Action(Agent agent, VncFunction fn, VncList fnArgs, SendType sendType, IInterceptor interceptor, Map<VncKeyword, VncVal> threadLocalValues) {
            this.agent = agent;
            this.fn = fn;
            this.fnArgs = fnArgs;
            this.sendType = sendType;
            this.interceptor = interceptor;
            this.threadLocalValues.set(threadLocalValues);
        }

        @Override
        public Object getStripe() {
            return this.agent.getID();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CallStack callStack = ThreadLocalMap.getCallStack();
            CallFrame callFrame = CallFrame.fromVal(String.format("agent->%s->%s", this.sendType.toString().toLowerCase(), this.fn.getQualifiedName()), this.fnArgs);
            try {
                ThreadLocalMap.clearCallStack();
                callStack.push(callFrame);
                ThreadLocalMap.setValues(this.threadLocalValues.get());
                ThreadLocalMap.push(new VncKeyword("*agent*"), new VncJavaObject(this.agent));
                JavaInterop.register(this.interceptor);
                if (this.agent.getError() == null || this.agent.continueOnError) {
                    VncVal oldVal = ((Value)this.agent.value.get()).val;
                    try {
                        VncList fnArgs_ = this.fnArgs.addAtStart(oldVal);
                        VncVal newVal = this.fn.apply(fnArgs_);
                        this.agent.value.set(new Value(newVal, null));
                        this.agent.watchable.notifyWatches(new VncJavaObject(this.agent), oldVal, newVal);
                    }
                    catch (RuntimeException ex) {
                        VncFunction handler;
                        if (!this.agent.continueOnError) {
                            this.agent.value.set(new Value(oldVal, ex));
                        }
                        if ((handler = (VncFunction)this.agent.errorHandler.get()) != null) {
                            handler.apply(VncList.of(new VncJavaObject(this.agent), new VncJavaObject(ex)));
                        }
                    }
                }
            }
            finally {
                callStack.pop();
                JavaInterop.unregister();
                ThreadLocalMap.remove();
            }
        }
    }
}

