/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.crypt;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.crypt.HashException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2_Hash {
    public static byte[] hash(String text, String salt) {
        return PBKDF2_Hash.hash(text, salt, 1000, 256);
    }

    public static byte[] hash(String text, String salt, int iterationCount, int keyLength) {
        if (StringUtil.isEmpty(text)) {
            throw new IllegalArgumentException("A 'text' must not be empty");
        }
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(text.toCharArray(), salt == null ? new byte[]{} : salt.getBytes("UTF-8"), iterationCount, keyLength);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (Exception ex) {
            throw new HashException("Failed to compute PBKDF2 hash.", ex);
        }
    }
}

