/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.Tuple4;
import com.github.jlangch.venice.impl.util.reflect.ArgTypeMatcher;
import com.github.jlangch.venice.impl.util.reflect.Boxing;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionAccessor_old {
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<String>> getterPropertiesCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<String>> setterPropertiesCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Method> getterMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Method> setterMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, Integer>, List<Constructor<?>>> constructorCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Field> staticFieldCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Field> instanceFieldCache = new ConcurrentHashMap();
    private static final Map<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> staticMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> instanceMethodCache = new ConcurrentHashMap();

    public static void clearCache() {
        classCache.clear();
        getterMethodCache.clear();
        setterMethodCache.clear();
        constructorCache.clear();
        staticFieldCache.clear();
        instanceFieldCache.clear();
        instanceMethodCache.clear();
        staticMethodCache.clear();
    }

    public static Class<?> classForName(String className) {
        try {
            return ReflectionAccessor_old.memoizedClassForName(className);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get class '%s'", className), ex);
        }
    }

    public static boolean classExists(String className) {
        try {
            return ReflectionAccessor_old.memoizedClassForName(className) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Object invokeConstructor(Class<?> clazz, Object[] args) {
        try {
            Class<?>[] params;
            List<Constructor<?>> ctors = ReflectionAccessor_old.memoizedPublicConstructors(clazz, args.length);
            if (ctors.isEmpty()) {
                throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingConstructorErrMsg(clazz));
            }
            if (ctors.size() == 1) {
                Constructor<?> ctor = ctors.get(0);
                return ctor.newInstance(Boxing.boxArgs(ctor.getParameterTypes(), args));
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, true, ctor.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, false, ctor.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return ctor.newInstance(boxedArgs);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingConstructorErrMsg(clazz));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke constructor '%s'", clazz.getName()), ex);
        }
    }

    public static Object invokeInstanceMethod(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            List<Method> methods = ReflectionAccessor_old.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor_old.invokeMatchingMethod(methodName, methods, target, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
        }
    }

    public static Object invokeStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        if (methodName.equals("new")) {
            return ReflectionAccessor_old.invokeConstructor(clazz, args);
        }
        try {
            List<Method> methods = ReflectionAccessor_old.memoizedStaticMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor_old.invokeMatchingMethod(methodName, methods, null, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static Object getStaticField(Class<?> clazz, String fieldName) {
        try {
            Field f = ReflectionAccessor_old.memoizedStaticField(clazz, fieldName);
            if (f != null) {
                return f.get(null);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get static field '%s' on class '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static Object getInstanceField(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = ReflectionAccessor_old.memoizedInstanceField(clazz, fieldName);
            if (f != null) {
                return f.get(target);
            }
            throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get instance field '%s' on target '%s'", fieldName, target.getClass().getName()), ex);
        }
    }

    public static List<String> getBeanGetterProperties(Object target) {
        return ReflectionAccessor_old.memoizedBeanGetterProperties(target.getClass());
    }

    public static List<String> getBeanSetterProperties(Object target) {
        return ReflectionAccessor_old.memoizedBeanSetterProperties(target.getClass());
    }

    public static Object getBeanProperty(Object target, String propertyName) {
        Method method = ReflectionAccessor_old.memoizedBeanGetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean get property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get bean property '%s' on target '%s'", propertyName, target.getClass().getName()), ex);
        }
    }

    public static void setBeanProperty(Object target, String propertyName, Object value) {
        Method method = ReflectionAccessor_old.memoizedBeanSetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean set property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            Class<?> type = method.getParameterTypes()[0];
            method.invoke(target, Boxing.boxArg(type, value));
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to set bean property '%s' on target '%s'", propertyName, target.getClass().getName()), ex);
        }
    }

    public static boolean isStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        try {
            List<Method> methods = ReflectionAccessor_old.memoizedStaticMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed check for available static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceMethod(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            List<Method> methods = ReflectionAccessor_old.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
        }
    }

    public static boolean isStaticField(Class<?> clazz, String fieldName) {
        try {
            Field f = ReflectionAccessor_old.memoizedStaticField(clazz, fieldName);
            return f != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available static field '%s' on target '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceField(Object target, String fieldName) {
        try {
            Class<?> clazz = target.getClass();
            Field f = ReflectionAccessor_old.memoizedInstanceField(clazz, fieldName);
            return f != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance field '%s' on target '%s'", fieldName, target.getClass().getName()), ex);
        }
    }

    private static Object invokeMatchingMethod(String methodName, List<Method> methods, Object target, Object[] args) {
        Class<?>[] params;
        if (methods.isEmpty()) {
            throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingMethodErrMsg(methodName, target, args));
        }
        if (methods.size() == 1) {
            Method m = methods.get(0);
            Object[] boxedArgs = Boxing.boxArgs(m.getParameterTypes(), args);
            return ReflectionAccessor_old.invoke(m, target, boxedArgs);
        }
        for (Method m : methods) {
            params = m.getParameterTypes();
            if (!ArgTypeMatcher.isCongruent(params, args, true, m.isVarArgs())) continue;
            Object[] boxedArgs = Boxing.boxArgs(params, args);
            return ReflectionAccessor_old.invoke(m, target, boxedArgs);
        }
        for (Method m : methods) {
            params = m.getParameterTypes();
            if (!ArgTypeMatcher.isCongruent(params, args, false, m.isVarArgs())) continue;
            Object[] boxedArgs = Boxing.boxArgs(params, args);
            return ReflectionAccessor_old.invoke(m, target, boxedArgs);
        }
        throw new JavaMethodInvocationException(ReflectionAccessor_old.noMatchingMethodErrMsg(methodName, target, args));
    }

    private static Object invoke(Method method, Object target, Object[] args) {
        try {
            if (method.getDeclaringClass().getName().equals("java.util.stream.ReferencePipeline")) {
                return ReflectionAccessor_old.invokeStreamMethod(method.getName(), target, args);
            }
            return method.invoke(target, args);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(target == null ? String.format("Failed to invoke static method %s(%s) on class %s", method.getName(), ReflectionAccessor_old.formatMethodArgTypes(method.getParameterTypes()), method.getDeclaringClass().getName()) : String.format("Failed to invoke instance method %s(%s) on target %s", method.getName(), ReflectionAccessor_old.formatMethodArgTypes(method.getParameterTypes()), target.getClass().getName()), ex);
        }
    }

    private static Object invokeStreamMethod(String methodName, Object target, Object[] args) {
        Stream stream = (Stream)target;
        switch (methodName) {
            case "allMatch": {
                return stream.allMatch((Predicate)args[0]);
            }
            case "anyMatch": {
                return stream.anyMatch((Predicate)args[0]);
            }
            case "collect": {
                switch (args.length) {
                    case 1: {
                        return stream.collect((Collector)args[0]);
                    }
                    case 3: {
                        return stream.collect((Supplier)args[0], (BiConsumer)args[1], (BiConsumer)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'collect' with " + args.length + " parameters");
            }
            case "distinct": {
                return stream.distinct();
            }
            case "filter": {
                return stream.filter((Predicate)args[0]);
            }
            case "findAny": {
                return stream.findAny();
            }
            case "findFirst": {
                return stream.findFirst();
            }
            case "limit": {
                return stream.limit((Long)args[0]);
            }
            case "map": {
                return stream.map((Function)args[0]);
            }
            case "mapToDouble": {
                return stream.mapToDouble((ToDoubleFunction)args[0]);
            }
            case "mapToInt": {
                return stream.mapToInt((ToIntFunction)args[0]);
            }
            case "mapToLong": {
                return stream.mapToLong((ToLongFunction)args[0]);
            }
            case "max": {
                return stream.max((Comparator)args[0]);
            }
            case "min": {
                return stream.min((Comparator)args[0]);
            }
            case "noneMatch": {
                return stream.noneMatch((Predicate)args[0]);
            }
            case "reduce": {
                switch (args.length) {
                    case 1: {
                        return stream.reduce((BinaryOperator)args[0]);
                    }
                    case 2: {
                        return stream.reduce(args[0], (BinaryOperator)args[1]);
                    }
                    case 3: {
                        return stream.reduce(args[0], (BiFunction)args[1], (BinaryOperator)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'reduce' with " + args.length + " parameters");
            }
            case "sorted": {
                return args.length == 0 ? stream.sorted() : stream.sorted((Comparator)args[0]);
            }
            case "skip": {
                return stream.skip((Long)args[0]);
            }
        }
        throw new JavaMethodInvocationException("Unsupported stream method '" + methodName + "'");
    }

    private static String noMatchingFieldErrMsg(String fieldName, Object target) {
        return String.format("No matching public field found: '%s' for target '%s'", fieldName, target == null ? "<null>" : target.getClass().getName());
    }

    private static String noMatchingMethodErrMsg(String methodName, Object target, Object ... methodArgs) {
        return String.format("No matching public method found: %s(%s) for target '%s'", methodName, ReflectionAccessor_old.formatArgTypes(methodArgs), target == null ? "<null>" : target.getClass().getName());
    }

    private static String noMatchingConstructorErrMsg(Class<?> clazz) {
        return String.format("No matching public constructor found: '%s'", clazz.getName());
    }

    private static Class<?> memoizedClassForName(String className) {
        return classCache.computeIfAbsent(className, k -> ReflectionUtil.classForName(k));
    }

    private static List<String> memoizedBeanGetterProperties(Class<?> clazz) {
        return getterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanGetterProperties(k));
    }

    private static List<String> memoizedBeanSetterProperties(Class<?> clazz) {
        return setterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanSetterProperties(k));
    }

    private static Method memoizedBeanGetterMethod(Class<?> clazz, String propertyName) {
        return getterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanGetterMethod((Class)k._1, (String)k._2));
    }

    private static Method memoizedBeanSetterMethod(Class<?> clazz, String propertyName) {
        return setterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanSetterMethod((Class)k._1, (String)k._2));
    }

    private static List<Constructor<?>> memoizedPublicConstructors(Class<?> clazz, int args) {
        return constructorCache.computeIfAbsent(new Tuple2(clazz, args), k -> ReflectionUtil.getPublicConstructors((Class)k._1, (Integer)k._2));
    }

    private static Field memoizedStaticField(Class<?> clazz, String fieldName) {
        return staticFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> ReflectionUtil.getPublicStaticField((Class)k._1, (String)k._2));
    }

    private static Field memoizedInstanceField(Class<?> clazz, String fieldName) {
        return instanceFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> ReflectionUtil.getPublicInstanceField((Class)k._1, (String)k._2));
    }

    private static List<Method> memoizedStaticMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return staticMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicStaticMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4));
    }

    private static List<Method> memoizedInstanceMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return instanceMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicInstanceMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4));
    }

    private static String formatArgTypes(Object[] args) {
        return Arrays.stream(args).map(o -> o.getClass().getSimpleName()).collect(Collectors.joining(", "));
    }

    private static String formatMethodArgTypes(Class<?>[] args) {
        return Arrays.stream(args).map(o -> o.getSimpleName()).collect(Collectors.joining(", "));
    }
}

