/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ArrayFunctions {
    public static VncFunction aset = new VncFunction("aset", VncFunction.meta().arglists("(aset array idx val)").doc("Sets the value at the index of an array").examples("(aset (long-array '(1 2 3 4 5)) 1 20)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("aset", args, 3);
            VncJavaObject jo = Coerce.toVncJavaObject(args.first());
            VncInteger idx = Numeric.toInteger(args.second());
            VncVal val = args.third();
            Object delegate = jo.getDelegate();
            Class<?> delegateClass = delegate.getClass();
            if (!ReflectionTypes.isArrayType(delegateClass)) {
                throw new VncException(String.format("The array argument (%s) is not an array", Types.getType(jo)));
            }
            Class<?> componentType = delegateClass.getComponentType();
            if (componentType == String.class) {
                Array.set(delegate, idx.getValue(), Coerce.toVncString(val).getValue());
            } else if (componentType == Integer.TYPE) {
                Array.setInt(delegate, idx.getValue(), Numeric.toInteger(val).getValue());
            } else if (componentType == Long.TYPE) {
                Array.setLong(delegate, idx.getValue(), Numeric.toLong(val).getValue());
            } else if (componentType == Float.TYPE) {
                Array.setFloat(delegate, idx.getValue(), Numeric.toDouble(val).getValue().floatValue());
            } else if (componentType == Double.TYPE) {
                Array.setDouble(delegate, idx.getValue(), Numeric.toDouble(val).getValue());
            } else {
                Array.set(delegate, idx.getValue(), val.convertToJavaObject());
            }
            return jo;
        }
    };
    public static VncFunction aget = new VncFunction("aget", VncFunction.meta().arglists("(aget array idx)").doc("Returns the value at the index of an array of Java Objects").examples("(aget (long-array '(1 2 3 4 5)) 1)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("aget", args, 2);
            VncJavaObject jo = Coerce.toVncJavaObject(args.first());
            VncInteger idx = Numeric.toInteger(args.second());
            Object delegate = jo.getDelegate();
            if (!ReflectionTypes.isArrayType(delegate.getClass())) {
                throw new VncException(String.format("The array argument (%s) is not an array", Types.getType(jo)));
            }
            Object val = Array.get(delegate, idx.getValue());
            if (val != null && ReflectionTypes.isArrayType(val.getClass())) {
                return new VncJavaObject(val);
            }
            return JavaInteropUtil.convertToVncVal(val);
        }
    };
    public static VncFunction alength = new VncFunction("alength", VncFunction.meta().arglists("(alength array)").doc("Returns the length of an array").examples("(alength (long-array '(1 2 3 4 5)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("alength", args, 1);
            VncJavaObject jo = Coerce.toVncJavaObject(args.first());
            Object delegate = jo.getDelegate();
            if (!ReflectionTypes.isArrayType(delegate.getClass())) {
                throw new VncException(String.format("The array argument (%s) is not an array", Types.getType(jo)));
            }
            return new VncLong(Array.getLength(delegate));
        }
    };
    public static VncFunction asub = new VncFunction("asub", VncFunction.meta().arglists("(asub array start len)").doc("Returns a sub array").examples("(asub (long-array '(1 2 3 4 5)) 2 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("asub", args, 3);
            VncJavaObject jo = Coerce.toVncJavaObject(args.first());
            int start = Coerce.toVncLong(args.second()).getIntValue();
            int len = Coerce.toVncLong(args.third()).getIntValue();
            Object delegate = jo.getDelegate();
            Class<?> delegateClass = delegate.getClass();
            if (!ReflectionTypes.isArrayType(delegateClass)) {
                throw new VncException(String.format("The array argument (%s) is not an array", Types.getType(jo)));
            }
            Class<?> componentType = delegateClass.getComponentType();
            Object arr = Array.newInstance(componentType, len);
            System.arraycopy(delegate, start, arr, 0, len);
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction amap = new VncFunction("amap", VncFunction.meta().arglists("(amap f arr)").doc("Applys f to each item in the array arr. Returns a new array with the mapped values.").examples("(str (amap (fn [x] (+ 1 x)) (long-array 6 0)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("amap", args, 2);
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncJavaObject oArr = Coerce.toVncJavaObject(args.second());
            Object arr = oArr.getDelegate();
            if (!ReflectionTypes.isArrayType(arr.getClass())) {
                throw new VncException(String.format("The array argument (%s) is not an array", Types.getType(oArr)));
            }
            Class<?> componentType = arr.getClass().getComponentType();
            int len = Array.getLength(arr);
            Object retArr = Array.newInstance(componentType, len);
            if (componentType == Integer.TYPE) {
                int[] src = (int[])arr;
                int[] dst = (int[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = Coerce.toVncInteger(fn.apply(new VncTinyList(new VncInteger(src[ii]), null))).getValue();
                }
            } else if (componentType == Long.TYPE) {
                long[] src = (long[])arr;
                long[] dst = (long[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = Coerce.toVncLong(fn.apply(new VncTinyList(new VncLong(src[ii]), null))).getValue();
                }
            } else if (componentType == Float.TYPE) {
                float[] src = (float[])arr;
                float[] dst = (float[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = Coerce.toVncDouble(fn.apply(new VncTinyList(new VncDouble(Float.valueOf(src[ii])), null))).getValue().floatValue();
                }
            } else if (componentType == Double.TYPE) {
                double[] src = (double[])arr;
                double[] dst = (double[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = Coerce.toVncDouble(fn.apply(new VncTinyList(new VncDouble(src[ii]), null))).getValue();
                }
            } else if (componentType == String.class) {
                String[] src = (String[])arr;
                String[] dst = (String[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = Coerce.toVncString(fn.apply(new VncTinyList(new VncString(src[ii]), null))).getValue();
                }
            } else {
                Object[] src = (Object[])arr;
                Object[] dst = (Object[])retArr;
                for (int ii = 0; ii < len; ++ii) {
                    dst[ii] = fn.apply(new VncTinyList(JavaInteropUtil.convertToVncVal(src[ii]), null)).convertToJavaObject();
                }
            }
            return new VncJavaObject(retArr);
        }
    };
    public static VncFunction acopy = new VncFunction("acopy", VncFunction.meta().arglists("(acopy src src-pos dest dest-pos dest-len)").doc("Copies an array from the src array, beginning at the specified position, to the specified position of the dest array. Returns the modified destination array").examples("(acopy (long-array '(1 2 3 4 5)) 2 (long-array 20) 10 3)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Class<?> dstCcomponentType;
            FunctionsUtil.assertArity("acopy", args, 5);
            VncJavaObject joSrc = Coerce.toVncJavaObject(args.nth(0));
            int srcPos = Coerce.toVncLong(args.nth(1)).getIntValue();
            VncJavaObject joDst = Coerce.toVncJavaObject(args.nth(2));
            int dstPos = Coerce.toVncLong(args.nth(3)).getIntValue();
            int dstLen = Coerce.toVncLong(args.nth(4)).getIntValue();
            Object delegateSrc = joSrc.getDelegate();
            Class<?> delegateSrcClass = delegateSrc.getClass();
            Object delegateDst = joDst.getDelegate();
            Class<?> delegateDstClass = delegateDst.getClass();
            if (!ReflectionTypes.isArrayType(delegateSrcClass)) {
                throw new VncException(String.format("The source array argument (%s) is not an array", Types.getType(joSrc)));
            }
            if (!ReflectionTypes.isArrayType(delegateDstClass)) {
                throw new VncException(String.format("The destination array argument (%s) is not an array", Types.getType(joDst)));
            }
            Class<?> srcCcomponentType = delegateSrcClass.getComponentType();
            if (srcCcomponentType != (dstCcomponentType = delegateDstClass.getComponentType())) {
                throw new VncException("Source and destination array are not from the same type");
            }
            System.arraycopy(delegateSrc, srcPos, delegateDst, dstPos, dstLen);
            return joDst;
        }
    };
    public static VncFunction make_array = new VncFunction("make-array", VncFunction.meta().arglists("(make-array type len)", "(make-array type dim &more-dims)").doc("Returns an array of the given type and length").examples("(str (make-array :long 5))", "(str (make-array :java.lang.Long 5))", "(str (make-array :long 2 3))", "(aset (make-array :java.lang.Long 5) 3 9999)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("make-array", args, 2);
            String className = Coerce.toVncKeyword(args.first()).getValue();
            if (className.startsWith("venice.")) {
                throw new VncException("make-array does not support Venice data types");
            }
            if (args.size() == 2) {
                int len = Numeric.toInteger(args.second()).getValue();
                return new VncJavaObject(Array.newInstance(ArrayFunctions.classForName(className), len));
            }
            List dimensions = args.slice(1).getList().stream().map(v -> Numeric.toInteger(v).getValue()).collect(Collectors.toList());
            int[] dim = new int[dimensions.size()];
            for (int ii = 0; ii < dimensions.size(); ++ii) {
                dim[ii] = (Integer)dimensions.get(ii);
            }
            return new VncJavaObject(Array.newInstance(ArrayFunctions.classForName(className), dim));
        }
    };
    public static VncFunction object_array = new VncFunction("object-array", VncFunction.meta().arglists("(object-array coll)", "(object-array len)", "(object-array len init-val)").doc("Returns an array of Java Objects containing the contents of coll or returns an array with the given length and optional init value").examples("(object-array '(1 2 3 4 5))", "(object-array '(1 2.0 3.45M \"4\" true))", "(object-array 10)", "(object-array 10 42)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("object-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                Object[] arr = new Object[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, args.second().convertToJavaObject());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            Object[] arr = new Object[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                arr[ii++] = v.convertToJavaObject();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction string_array = new VncFunction("string-array", VncFunction.meta().arglists("(string-array coll)", "(string-array len)", "(string-array len init-val)").doc("Returns an array of Java strings containing the contents of coll or returns an array with the given length and optional init value").examples("(string-array '(\"1\" \"2\" \"3\"))", "(string-array 10)", "(string-array 10 \"42\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("string-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                Object[] arr = new String[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Coerce.toVncString(args.second()).getValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            String[] arr = new String[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (!Types.isVncString(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a string", ii));
                }
                arr[ii++] = ((VncString)v).getValue();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction byte_array = new VncFunction("byte-array", VncFunction.meta().arglists("(byte-array coll)", "(byte-array len)", "(byte-array len byte-val)").doc("Returns an array of Java primitive bytes containing the contents of coll or returns an array with the given length and optional init value").examples("(byte-array '(1 2 3))", "(byte-array 10)", "(byte-array 10 42)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("byte-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                byte[] arr = new byte[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Numeric.toLong(args.second()).getValue().byteValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            byte[] arr = new byte[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (v == Constants.Nil || !Types.isVncNumber(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a number", ii));
                }
                arr[ii++] = Numeric.toLong(v).getValue().byteValue();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction int_array = new VncFunction("int-array", VncFunction.meta().arglists("(int-array coll)", "(int-array len)", "(int-array len init-val)").doc("Returns an array of Java primitive ints containing the contents of coll or returns an array with the given length and optional init value").examples("(int-array '(1I 2I 3I))", "(int-array '(1I 2 3.2 3.56M))", "(int-array 10)", "(int-array 10 42I)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("int-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                int[] arr = new int[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Numeric.toInteger(args.second()).getValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            int[] arr = new int[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (v == Constants.Nil || !Types.isVncNumber(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a number", ii));
                }
                arr[ii++] = Numeric.toInteger(v).getValue();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction long_array = new VncFunction("long-array", VncFunction.meta().arglists("(long-array coll)", "(long-array len)", "(long-array len init-val)").doc("Returns an array of Java primitive longs containing the contents of coll or returns an array with the given length and optional init value").examples("(long-array '(1 2 3))", "(long-array '(1I 2 3.2 3.56M))", "(long-array 10)", "(long-array 10 42)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("long-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                long[] arr = new long[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Numeric.toLong(args.second()).getValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            long[] arr = new long[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (v == Constants.Nil || !Types.isVncNumber(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a number", ii));
                }
                arr[ii++] = Numeric.toLong(v).getValue();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction float_array = new VncFunction("float-array", VncFunction.meta().arglists("(float-array coll)", "(float-array len)", "(float-array len init-val)").doc("Returns an array of Java primitive floats containing the contents of coll or returns an array with the given length and optional init value").examples("(float-array '(1.0 2.0 3.0))", "(float-array '(1I 2 3.2 3.56M))", "(float-array 10)", "(float-array 10 42.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("float-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                float[] arr = new float[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Numeric.toDouble(args.second()).getValue().floatValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            float[] arr = new float[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (v == Constants.Nil || !Types.isVncNumber(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a number", ii));
                }
                arr[ii++] = Numeric.toDouble(v).getValue().floatValue();
            }
            return new VncJavaObject(arr);
        }
    };
    public static VncFunction double_array = new VncFunction("double-array", VncFunction.meta().arglists("(double-array coll)", "(double-array len)", "(double-array len init-val)").doc("Returns an array of Java primitive doubles containing the contents of coll or returns an array with the given length and optional init value").examples("(double-array '(1.0 2.0 3.0))", "(double-array '(1I 2 3.2 3.56M))", "(double-array 10)", "(double-array 10 42.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("double-array", args, 1, 2);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                double[] arr = new double[((VncLong)arg).getIntValue().intValue()];
                if (args.size() == 2) {
                    Arrays.fill(arr, Numeric.toDouble(args.second()).getValue());
                }
                return new VncJavaObject(arr);
            }
            List<VncVal> list = Coerce.toVncSequence(args.first()).getList();
            double[] arr = new double[list.size()];
            int ii = 0;
            for (VncVal v : list) {
                if (v == Constants.Nil || !Types.isVncNumber(v)) {
                    throw new VncException(String.format("The value at pos %d in the collection is not a number", ii));
                }
                arr[ii++] = Numeric.toDouble(v).getValue();
            }
            return new VncJavaObject(arr);
        }
    };
    private static int MAX_TO_STRING_ITEMS = 20;
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(aget).add(aset).add(alength).add(asub).add(acopy).add(amap).add(make_array).add(object_array).add(string_array).add(byte_array).add(int_array).add(long_array).add(float_array).add(double_array).toMap();

    public static String arrayToString(VncJavaObject val) {
        if (val.isArray()) {
            StringBuilder sb = new StringBuilder("[");
            Object delegate = val.getDelegate();
            int length = Array.getLength(delegate);
            for (int ii = 0; ii < length; ++ii) {
                if (ii >= MAX_TO_STRING_ITEMS) {
                    sb.append(String.format(", ... (%d more)", length - MAX_TO_STRING_ITEMS));
                    break;
                }
                if (ii > 0) {
                    sb.append(", ");
                }
                sb.append(JavaInteropUtil.convertToVncVal(Array.get(delegate, ii)));
            }
            sb.append("]");
            return sb.toString();
        }
        throw new VncException(String.format("Not an array. Got %s", Types.getType(val)));
    }

    private static Class<?> classForName(String className) {
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return ReflectionUtil.classForName(className);
    }
}

